/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.particles;

import com.blackgear.vanillabackport.client.level.particles.particleoptions.ColorParticleOption;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FallingLeavesParticle
extends TextureSheetParticle {
    private static final float ACCELERATION_SCALE = 0.0025f;
    private static final int INITIAL_LIFETIME = 300;
    private static final int CURVE_ENDPOINT_TIME = 300;
    private float rotSpeed;
    private final float spinAcceleration;
    private final float windBig;
    private final boolean swirl;
    private final boolean flowAway;
    private final double xaFlowScale;
    private final double zaFlowScale;
    private final double swirlPeriod;

    protected FallingLeavesParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, float fallAcceleration, float windBig, boolean swirl, boolean flowAway, float scale, float initialVelocity) {
        super(level, x, y, z);
        float size;
        this.m_108337_(sprites.m_5819_(this.f_107223_.m_188503_(12), 12));
        this.rotSpeed = (float)Math.toRadians(this.f_107223_.m_188499_() ? -30.0 : 30.0);
        float particleRandom = this.f_107223_.m_188501_();
        this.spinAcceleration = (float)Math.toRadians(this.f_107223_.m_188499_() ? -5.0 : 5.0);
        this.windBig = windBig;
        this.swirl = swirl;
        this.flowAway = flowAway;
        this.f_107225_ = 300;
        this.f_107226_ = fallAcceleration * 1.2f * 0.0025f;
        this.f_107663_ = size = scale * (this.f_107223_.m_188499_() ? 0.05f : 0.075f);
        this.m_107250_(size, size);
        this.f_172258_ = 1.0f;
        this.f_107216_ = -initialVelocity;
        this.xaFlowScale = Math.cos(Math.toRadians(particleRandom * 60.0f)) * (double)this.windBig;
        this.zaFlowScale = Math.sin(Math.toRadians(particleRandom * 60.0f)) * (double)this.windBig;
        this.swirlPeriod = Math.toRadians(1000.0f + particleRandom * 3000.0f);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
        if (!this.f_107220_) {
            float ageInTicks = 300 - this.f_107225_;
            float ageRatio = Math.min(ageInTicks / 300.0f, 1.0f);
            double xAcceleration = 0.0;
            double zAcceleration = 0.0;
            if (this.flowAway) {
                xAcceleration += this.xaFlowScale * Math.pow(ageRatio, 1.25);
                zAcceleration += this.zaFlowScale * Math.pow(ageRatio, 1.25);
            }
            if (this.swirl) {
                xAcceleration += (double)ageRatio * Math.cos((double)ageRatio * this.swirlPeriod) * (double)this.windBig;
                zAcceleration += (double)ageRatio * Math.sin((double)ageRatio * this.swirlPeriod) * (double)this.windBig;
            }
            this.f_107215_ += xAcceleration * (double)0.0025f;
            this.f_107217_ += zAcceleration * (double)0.0025f;
            this.f_107216_ -= (double)this.f_107226_;
            this.rotSpeed += this.spinAcceleration / 20.0f;
            this.f_107204_ = this.f_107231_;
            this.f_107231_ += this.rotSpeed / 20.0f;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.f_107218_ || this.f_107225_ < 299 && (this.f_107215_ == 0.0 || this.f_107217_ == 0.0)) {
                this.m_107274_();
            }
            if (!this.f_107220_) {
                this.f_107215_ *= (double)this.f_172258_;
                this.f_107216_ *= (double)this.f_172258_;
                this.f_107217_ *= (double)this.f_172258_;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record TintedLeavesProvider(SpriteSet sprites) implements ParticleProvider<ColorParticleOption>
    {
        public Particle createParticle(ColorParticleOption type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingLeavesParticle particle = new FallingLeavesParticle(level, x, y, z, this.sprites, 0.07f, 10.0f, true, false, 2.0f, 0.021f);
            particle.m_107253_(type.getRed(), type.getGreen(), type.getBlue());
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record PaleOakProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FallingLeavesParticle(level, x, y, z, this.sprites, 0.07f, 10.0f, true, false, 2.0f, 0.021f);
        }
    }
}

