/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.platform.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.qendolin.betterclouds.platform.EventHooks;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class EventHooksImpl
extends EventHooks {
    private final IEventBus modEventBus;

    public EventHooksImpl(IEventBus modEventBus) {
        this.modEventBus = modEventBus;
    }

    @Override
    public void onClientStarted(Consumer<Minecraft> callback) {
        this.modEventBus.addListener(event -> {
            Minecraft client = Minecraft.m_91087_();
            client.execute(() -> callback.accept(client));
        });
    }

    @Override
    public void onWorldJoin(Consumer<Minecraft> callback) {
        MinecraftForge.EVENT_BUS.addListener(event -> callback.accept(Minecraft.m_91087_()));
    }

    @Override
    public void onClientResourcesReload(Supplier<PreparableReloadListener> supplier) {
        this.modEventBus.addListener(event -> event.registerReloadListener((PreparableReloadListener)supplier.get()));
    }

    @Override
    public void onClientTick(Consumer<Minecraft> callback) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft client = Minecraft.m_91087_();
            client.execute(() -> callback.accept(client));
        });
    }

    @Override
    public void onClientCommandRegistration(Consumer<CommandDispatcher<CommandSourceStack>> callback) {
        MinecraftForge.EVENT_BUS.addListener(event -> callback.accept(event.getDispatcher()));
    }
}

