/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.renderdoc;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class CaptureManager {
    public static final Path LAUNCH_CONFIG_PATH = BetterCloudsStatic.getDataDirectory().resolve("capture.conf");
    private static final List<Map.Entry<Long, Runnable>> callbacks = new ArrayList<Map.Entry<Long, Runnable>>();
    private static final AtomicLong frameIndex = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void capture(Consumer<RenderDoc.Capture> callback) {
        int captureIndex = RenderDoc.getNumCaptures();
        RenderDoc.triggerCapture();
        List<Map.Entry<Long, Runnable>> list = callbacks;
        synchronized (list) {
            callbacks.add(Map.entry(frameIndex.get() + 2L, () -> callback.accept(RenderDoc.getCapture(captureIndex))));
        }
    }

    public static void writeLaunchConfig(LaunchConfig config) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("load", String.valueOf(config.load));
        properties.setProperty("once", String.valueOf(config.once));
        properties.setProperty("expires", String.valueOf(config.expires));
        try (BufferedWriter writer = Files.newBufferedWriter(LAUNCH_CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
            properties.store(writer, "RenderDoc Launch Configuration");
        }
    }

    public static LaunchConfig readLaunchConfig() {
        LaunchConfig launchConfig;
        block9: {
            if (!Files.exists(LAUNCH_CONFIG_PATH, new LinkOption[0])) {
                return new LaunchConfig(false, false, 0L);
            }
            BufferedReader reader = Files.newBufferedReader(LAUNCH_CONFIG_PATH, StandardCharsets.UTF_8);
            try {
                Properties properties = new Properties();
                properties.load(reader);
                boolean load = Boolean.parseBoolean(properties.getProperty("load", "false"));
                boolean once = Boolean.parseBoolean(properties.getProperty("once", "false"));
                long expires = Long.parseLong(properties.getProperty("expires", "0"));
                launchConfig = new LaunchConfig(load, once, expires);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NumberFormatException e) {
                    BetterCloudsStatic.getLogger().error("Failed to read RenderDoc launch configuration", (Throwable)e);
                    return new LaunchConfig(false, false, 0L);
                }
            }
            ((Reader)reader).close();
        }
        return launchConfig;
    }

    public static void deleteLaunchConfig() {
        try {
            Files.delete(LAUNCH_CONFIG_PATH);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void onSwapBuffers() {
        long idx = frameIndex.getAndIncrement();
        if (callbacks.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Long, Runnable>> iterator = callbacks.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Runnable> entry = iterator.next();
            if (idx < entry.getKey()) continue;
            entry.getValue().run();
            iterator.remove();
        }
    }

    public record LaunchConfig(boolean load, boolean once, long expires) {
        public boolean isExpired() {
            return System.currentTimeMillis() >= this.expires;
        }
    }
}

