/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.chainConveyor;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.render.SpecialModels;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import dev.engine_room.flywheel.lib.visual.util.SmartRecycler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ChainConveyorVisual
extends SingleAxisRotatingVisual<ChainConveyorBlockEntity>
implements SimpleDynamicVisual,
SimpleTickableVisual {
    private final List<TransformedInstance> guards = new ArrayList<TransformedInstance>();
    private final SmartRecycler<ResourceLocation, TransformedInstance> boxes;
    private final SmartRecycler<ResourceLocation, TransformedInstance> rigging;

    public ChainConveyorVisual(VisualizationContext context, ChainConveyorBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, Models.partial((PartialModel)AllPartialModels.CHAIN_CONVEYOR_SHAFT));
        this.setupGuards();
        this.boxes = new SmartRecycler(key -> (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.PACKAGES.get(key))).createInstance());
        this.rigging = new SmartRecycler(key -> (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.PACKAGE_RIGGING.get(key))).createInstance());
    }

    @Override
    public void update(float pt) {
        super.update(pt);
        this.setupGuards();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        ((ChainConveyorBlockEntity)this.blockEntity).tickBoxVisuals();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float partialTicks = ctx.partialTick();
        this.boxes.resetCount();
        this.rigging.resetCount();
        for (ChainConveyorPackage chainConveyorPackage : ((ChainConveyorBlockEntity)this.blockEntity).loopingPackages) {
            this.setupBoxVisual((ChainConveyorBlockEntity)this.blockEntity, chainConveyorPackage, partialTicks);
        }
        for (Map.Entry entry : ((ChainConveyorBlockEntity)this.blockEntity).travellingPackages.entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.setupBoxVisual((ChainConveyorBlockEntity)this.blockEntity, box, partialTicks);
            }
        }
        this.boxes.discardExtra();
        this.rigging.discardExtra();
    }

    private void setupBoxVisual(ChainConveyorBlockEntity be, ChainConveyorPackage box, float partialTicks) {
        if (box.worldPosition == null) {
            return;
        }
        if (box.item == null || box.item.m_41619_()) {
            return;
        }
        ChainConveyorPackage.ChainConveyorPackagePhysicsData physicsData = box.physicsData((LevelAccessor)be.m_58904_());
        if (physicsData.prevPos == null) {
            return;
        }
        Vec3 position = physicsData.prevPos.m_165921_(physicsData.pos, (double)partialTicks);
        Vec3 targetPosition = physicsData.prevTargetPos.m_165921_(physicsData.targetPos, (double)partialTicks);
        float yaw = AngleHelper.angleLerp((double)partialTicks, (double)physicsData.prevYaw, (double)physicsData.yaw);
        Vec3 offset = new Vec3(targetPosition.f_82479_ - (double)this.pos.m_123341_(), targetPosition.f_82480_ - (double)this.pos.m_123342_(), targetPosition.f_82481_ - (double)this.pos.m_123343_());
        BlockPos containingPos = BlockPos.m_274446_((Position)position);
        Level level = be.m_58904_();
        int light = LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, containingPos), (int)level.m_45517_(LightLayer.SKY, containingPos));
        if (physicsData.modelKey == null) {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)box.item.m_41720_());
            if (key == null) {
                return;
            }
            physicsData.modelKey = key;
        }
        TransformedInstance rigBuffer = (TransformedInstance)this.rigging.get((Object)physicsData.modelKey);
        TransformedInstance boxBuffer = (TransformedInstance)this.boxes.get((Object)physicsData.modelKey);
        Vec3 dangleDiff = VecHelper.rotate((Vec3)targetPosition.m_82520_(0.0, 0.5, 0.0).m_82546_(position), (double)(-yaw), (Direction.Axis)Direction.Axis.Y);
        float zRot = Mth.m_14177_((float)((float)Mth.m_14136_((double)(-dangleDiff.f_82479_), (double)dangleDiff.f_82480_) * 57.295776f)) / 2.0f;
        float xRot = Mth.m_14177_((float)((float)Mth.m_14136_((double)dangleDiff.f_82481_, (double)dangleDiff.f_82480_) * 57.295776f)) / 2.0f;
        zRot = Mth.m_14036_((float)zRot, (float)-25.0f, (float)25.0f);
        xRot = Mth.m_14036_((float)xRot, (float)-25.0f, (float)25.0f);
        for (TransformedInstance buf : new TransformedInstance[]{rigBuffer, boxBuffer}) {
            buf.setIdentityTransform();
            buf.translate((Vec3i)this.getVisualPosition());
            buf.translate(offset);
            buf.translate(0.0f, 0.625f, 0.0f);
            buf.rotateYDegrees(yaw);
            buf.rotateZDegrees(zRot);
            buf.rotateXDegrees(xRot);
            if (physicsData.flipped && buf == rigBuffer) {
                buf.rotateYDegrees(180.0f);
            }
            buf.uncenter();
            buf.translate(0.0f, -PackageItem.getHookDistance(box.item) + 0.4375f, 0.0f);
            buf.light(light);
            buf.setChanged();
        }
    }

    private void deleteGuards() {
        for (TransformedInstance guard : this.guards) {
            guard.delete();
        }
        this.guards.clear();
    }

    private void setupGuards() {
        this.deleteGuards();
        Instancer wheelInstancer = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.chunkDiffuse(AllPartialModels.CHAIN_CONVEYOR_WHEEL));
        Instancer guardInstancer = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.chunkDiffuse(AllPartialModels.CHAIN_CONVEYOR_GUARD));
        TransformedInstance wheel = (TransformedInstance)wheelInstancer.createInstance();
        ((TransformedInstance)wheel.translate((Vec3i)this.getVisualPosition())).light(this.rotatingModel.light).setChanged();
        this.guards.add(wheel);
        for (BlockPos blockPos : ((ChainConveyorBlockEntity)this.blockEntity).connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = ((ChainConveyorBlockEntity)this.blockEntity).connectionStats.get(blockPos);
            if (stats == null) continue;
            Vec3 diff = stats.end().m_82546_(stats.start());
            double yaw = 57.2957763671875 * Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_);
            TransformedInstance guard = (TransformedInstance)guardInstancer.createInstance();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)guard.translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees((float)yaw)).uncenter()).light(this.rotatingModel.light).setChanged();
            this.guards.add(guard);
        }
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        for (TransformedInstance guard : this.guards) {
            this.relight(new FlatLit[]{guard});
        }
    }

    @Override
    protected void _delete() {
        super._delete();
        this.deleteGuards();
        this.boxes.delete();
        this.rigging.delete();
    }
}

