/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks.entity;

import java.util.UUID;
import net.lyivx.ls_furniture.common.utils.block.BlockEntityHelper;
import net.lyivx.ls_furniture.registry.ModBlockEntitys;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TombstoneBlockEntity
extends BlockEntity {
    private String[] lines = new String[]{"", "", "", ""};
    private float[] textSizes = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private DyeColor color = DyeColor.BLACK;
    private boolean glowing = false;
    private boolean editable = true;
    private boolean isWritten = true;
    private String owner;
    private String ownerDisplayName;

    public TombstoneBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntitys.TOMBSTONE_ENTITY.get(), pos, state);
    }

    public String[] getLines() {
        return this.lines;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor newColor) {
        this.color = newColor;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.m_6596_();
    }

    public void setWritten(boolean written) {
        this.isWritten = written;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isWritten() {
        return this.isWritten;
    }

    public void setLines(String[] newLines) {
        System.arraycopy(newLines, 0, this.lines, 0, Math.min(newLines.length, 4));
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public float[] getTextSizes() {
        return this.textSizes;
    }

    public void setTextSize(int lineIndex, float size) {
        if (lineIndex >= 0 && lineIndex < 4) {
            this.textSizes[lineIndex] = size;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public void updateDisplayName(Player playerEntity) {
        if (this.isOwner(playerEntity)) {
            String playerName = playerEntity.m_36316_().getName();
            if (this.ownerDisplayName == null || !this.ownerDisplayName.equals(playerName)) {
                this.ownerDisplayName = playerName;
                BlockEntityHelper.broadcastUpdate(this, false);
            }
        }
    }

    public void setOwner(Player playerEntity) {
        this.owner = playerEntity.m_20149_();
        this.ownerDisplayName = playerEntity.m_36316_().getName();
        BlockEntityHelper.broadcastUpdate(this, false);
    }

    public UUID getOwner() {
        return UUID.fromString(this.owner);
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public boolean isOwner(Player playerEntity) {
        return this.hasOwner() && playerEntity.m_20149_().equals(this.owner);
    }

    public Component getOwnerDisplayName() {
        return !this.hasOwner() || this.ownerDisplayName == null || this.ownerDisplayName.isEmpty() ? null : Component.m_237113_((String)this.ownerDisplayName);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("Owner", this.owner == null ? "" : this.owner);
        for (int i = 0; i < 4; ++i) {
            tag.m_128359_("Line" + (i + 1), this.lines[i]);
            tag.m_128350_("TextSize" + (i + 1), this.textSizes[i]);
        }
        tag.m_128405_("Color", this.color.m_41060_());
        tag.m_128379_("Glowing", this.glowing);
        tag.m_128379_("Editable", this.editable);
        tag.m_128379_("Written", this.isWritten);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.owner = tag.m_128461_("Owner");
        for (int i = 0; i < 4; ++i) {
            this.lines[i] = tag.m_128461_("Line" + (i + 1));
            this.textSizes[i] = tag.m_128457_("TextSize" + (i + 1));
        }
        this.color = DyeColor.m_41053_((int)tag.m_128451_("Color"));
        this.glowing = tag.m_128471_("Glowing");
        this.editable = tag.m_128471_("Editable");
        this.isWritten = tag.m_128471_("Written");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

