/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.items;

import java.util.List;
import net.lyivx.ls_furniture.client.LYIVXsFurnitureModClient;
import net.lyivx.ls_furniture.registry.ModSoundEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class LetterItem
extends Item {
    public LetterItem(Item.Properties properties) {
        super(properties);
    }

    private void openGui(ItemStack stack, Player playerEntity, InteractionHand hand) {
        playerEntity.m_9236_().m_5594_(null, playerEntity.m_20183_(), SoundEvents.f_11713_, SoundSource.PLAYERS, 1.0f, 1.0f);
        LYIVXsFurnitureModClient.openLetterGui(stack, playerEntity, hand);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag flag) {
        if (stack.m_41782_()) {
            CompoundTag letterTag = stack.m_41783_();
            if (letterTag.m_128441_("Author")) {
                tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.ls_furniture.letter.author", (Object[])new Object[]{letterTag.m_128461_("Author")}).m_130940_(ChatFormatting.GRAY));
            }
            if (letterTag.m_128441_("Attachment")) {
                ItemStack attachment = ItemStack.m_41712_((CompoundTag)letterTag.m_128469_("Attachment"));
                tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.ls_furniture.letter.attachment", (Object[])new Object[]{attachment.m_41720_().m_41466_()}).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (Screen.m_96638_()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.letter_add"));
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.letter_remove"));
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_7373_(stack, level, tooltipComponents, flag);
    }

    public static ItemStack addAttachment(ItemStack letter, ItemStack attachment) {
        CompoundTag letterTag = letter.m_41784_();
        if (!letterTag.m_128441_("Attachment")) {
            CompoundTag attachmentTag = new CompoundTag();
            letterTag.m_128365_("Attachment", (Tag)attachment.m_41739_(attachmentTag));
            letter.m_41751_(letterTag);
            return ItemStack.f_41583_;
        }
        return attachment;
    }

    public static ItemStack removeAttachment(ItemStack letter) {
        CompoundTag letterTag = letter.m_41784_();
        if (letterTag.m_128441_("Attachment")) {
            ItemStack attachment = ItemStack.m_41712_((CompoundTag)letterTag.m_128469_("Attachment"));
            letterTag.m_128473_("Attachment");
            letter.m_41751_(letterTag);
            return attachment;
        }
        return ItemStack.f_41583_;
    }

    public static void signLetter(ItemStack letter, String author) {
        CompoundTag letterTag = letter.m_41784_();
        if (!letterTag.m_128441_("Author")) {
            letterTag.m_128359_("Author", author);
        }
        letter.m_41751_(letterTag);
    }

    public static boolean canEditLetter(ItemStack letter) {
        CompoundTag letterTag = letter.m_41784_();
        return !letterTag.m_128441_("Author");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerEntity, InteractionHand hand) {
        ItemStack letter = playerEntity.m_21120_(hand);
        if (playerEntity.m_6047_()) {
            if (hand != InteractionHand.OFF_HAND) {
                ItemStack result = LetterItem.removeAttachment(letter);
                if (!result.m_41619_()) {
                    playerEntity.m_36356_(result);
                    if (world.m_5776_()) {
                        playerEntity.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.letter.attachment_removed"), true);
                        playerEntity.m_5496_(ModSoundEvents.DETACH_TO_LETTER.get(), 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19092_((Object)letter, (boolean)world.m_5776_());
                }
                ItemStack offHandStack = playerEntity.m_21120_(InteractionHand.OFF_HAND);
                if (!offHandStack.m_41619_()) {
                    result = LetterItem.addAttachment(letter, offHandStack);
                    playerEntity.m_21008_(InteractionHand.OFF_HAND, result);
                    if (result.m_41619_()) {
                        if (world.m_5776_()) {
                            playerEntity.m_5661_((Component)Component.m_237110_((String)"msg.ls_furniture.letter.attachment_added", (Object[])new Object[]{offHandStack.m_41720_().m_41466_()}), true);
                            playerEntity.m_5496_(ModSoundEvents.ATTACH_TO_LETTER.get(), 1.0f, 1.0f);
                        }
                        return InteractionResultHolder.m_19092_((Object)letter, (boolean)world.m_5776_());
                    }
                }
                return InteractionResultHolder.m_19100_((Object)letter);
            }
            return InteractionResultHolder.m_19100_((Object)letter);
        }
        if (world.m_5776_()) {
            this.openGui(letter, playerEntity, hand);
        }
        return InteractionResultHolder.m_19092_((Object)letter, (boolean)world.m_5776_());
    }
}

