/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.menus;

import com.google.common.collect.Lists;
import java.util.List;
import net.lyivx.ls_furniture.common.recipes.FilterableRecipe;
import net.lyivx.ls_furniture.common.recipes.RecipeSorter;
import net.lyivx.ls_furniture.registry.ModBlocks;
import net.lyivx.ls_furniture.registry.ModMenus;
import net.lyivx.ls_furniture.registry.ModRecipes;
import net.lyivx.ls_furniture.registry.ModSoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WorkstationMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    public final Container container;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private List<FilterableRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.f_41583_;
    private long lastSoundTime;
    private final ResultContainer resultContainer;
    private Runnable slotUpdateListener = () -> {};
    private FilterableRecipe lastSelectedRecipe = null;

    public WorkstationMenu(int i, Inventory inventory) {
        this(i, inventory, ContainerLevelAccess.f_39287_);
    }

    public WorkstationMenu(int i, Inventory inventory, final ContainerLevelAccess containerLevelAccess) {
        super((MenuType)ModMenus.WORKSTATION_MENU.get(), i);
        int j;
        this.container = new SimpleContainer(1){

            public void m_6596_() {
                super.m_6596_();
                WorkstationMenu.this.m_6199_((Container)this);
                WorkstationMenu.this.slotUpdateListener.run();
            }
        };
        this.resultContainer = new ResultContainer();
        this.access = containerLevelAccess;
        this.level = inventory.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 17, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 146, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                WorkstationMenu.this.resultContainer.m_58395_(player, this.getRelevantItems());
                ItemStack itemStack = WorkstationMenu.this.inputSlot.m_6201_(WorkstationMenu.this.recipes.get(WorkstationMenu.this.selectedRecipeIndex.m_6501_()).recipe().inputCount());
                if (!itemStack.m_41619_()) {
                    WorkstationMenu.this.setupResultSlot();
                }
                containerLevelAccess.m_39292_((level, blockPos) -> {
                    long l = level.m_46467_();
                    if (WorkstationMenu.this.lastSoundTime != l) {
                        level.m_5594_(null, blockPos, ModSoundEvents.WORKSTATION_TAKE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        WorkstationMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(WorkstationMenu.this.inputSlot.m_7993_());
            }
        });
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<FilterableRecipe> getRecipes() {
        return this.recipes;
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return WorkstationMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.WORKSTATION.get()));
    }

    public boolean m_6366_(Player player, int id) {
        if (this.isValidRecipeIndex(id = Byte.toUnsignedInt((byte)id)) || id == 255) {
            this.selectedRecipeIndex.m_6422_(id);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int recipeIndex) {
        return recipeIndex >= 0 && recipeIndex < this.recipes.size();
    }

    public void m_6199_(Container container) {
        ItemStack itemStack = this.inputSlot.m_7993_();
        ItemStack old = this.input;
        boolean sameStack = itemStack.m_150930_(old.m_41720_());
        int maxItemsThatCanBeConsumed = 5;
        if (!sameStack || itemStack.m_41613_() < maxItemsThatCanBeConsumed || old.m_41613_() < maxItemsThatCanBeConsumed) {
            this.input = itemStack.m_41777_();
            this.setupRecipeList(container, itemStack);
        }
    }

    private void setupRecipeList(Container container, ItemStack stack) {
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            int newInd;
            List matching = this.level.m_7465_().m_44056_(ModRecipes.WORKSTATION_RECIPE.get(), container, this.level);
            RecipeSorter.sort(matching, this.level);
            this.recipes = matching.stream().map(FilterableRecipe::of).toList();
            this.recipes = this.recipes.subList(0, Math.min(this.recipes.size(), 255));
            if (this.lastSelectedRecipe != null && (newInd = this.recipes.indexOf(this.lastSelectedRecipe)) != -1) {
                this.selectedRecipeIndex.m_6422_(newInd);
            }
        }
        this.lastSelectedRecipe = null;
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            FilterableRecipe selected;
            this.lastSelectedRecipe = selected = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack itemStack = selected.recipe().m_5874_(this.container, this.level.m_9598_());
            if (itemStack.m_246617_(this.level.m_246046_())) {
                this.resultContainer.m_6029_((Recipe)selected.recipeHolder());
                this.resultSlot.m_5852_(itemStack);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)ModMenus.WORKSTATION_MENU.get();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            Item item = itemStack2.m_41720_();
            itemStack = itemStack2.m_41777_();
            if (index == 1) {
                item.m_7836_(itemStack2, player.m_9236_(), player);
                if (!this.m_38903_(itemStack2, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
            } else if (index == 0 ? !this.m_38903_(itemStack2, 2, 38, false) : (this.level.m_7465_().m_44015_(ModRecipes.WORKSTATION_RECIPE.get(), (Container)new SimpleContainer(new ItemStack[]{itemStack2}), this.level).isPresent() ? !this.m_38903_(itemStack2, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(itemStack2, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(itemStack2, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
            this.m_38946_();
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(player, this.container));
    }
}

