/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_core;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import net.lyivx.ls_core.common.config.CustomConfigSpec;
import net.lyivx.ls_core.common.config.ILyivxConfigProvider;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LYIVXsCore {
    public static final String MOD_ID = "ls_core";
    public static final Logger LOGGER = LogManager.getLogger((String)"ls_core");
    private static final List<ILyivxConfigProvider> configProviders = new ArrayList<ILyivxConfigProvider>();

    public static void init() {
        LifecycleEvent.SETUP.register(LYIVXsCore::setup);
    }

    public static void setup() {
        LOGGER.info("Looking for configuration providers...");
        ServiceLoader<ILyivxConfigProvider> loader = ServiceLoader.load(ILyivxConfigProvider.class);
        loader.forEach(provider -> {
            configProviders.add((ILyivxConfigProvider)provider);
            LOGGER.info("Found provider: {} (ID: {})", (Object)provider.getModName(), (Object)provider.getModId());
        });
        LYIVXsCore.loadConfigProviders(configProviders);
        LOGGER.info("Total providers found: {}", (Object)configProviders.size());
    }

    public static void loadConfigProviders(List<ILyivxConfigProvider> providers) {
        for (ILyivxConfigProvider provider : providers) {
            try {
                String safeName = provider.getModName().replaceAll("[^a-zA-Z0-9\\-_ ]", "_").replace(" ", "_");
                Path providerConfigDir = Platform.getConfigFolder().resolve(safeName);
                Path configFilePath = providerConfigDir.resolve(provider.getModId() + ".json");
                LOGGER.info("Initializing config for mod '{}'", (Object)provider.getModId());
                LOGGER.info(" > Config directory: {}", (Object)providerConfigDir);
                LOGGER.info(" > Config file path: {}", (Object)configFilePath);
                if (Files.exists(configFilePath, new LinkOption[0])) {
                    LOGGER.info(" > Found existing config file. Loading...");
                } else {
                    LOGGER.info(" > No config file found. Creating new config with defaults.");
                }
                CustomConfigSpec spec = new CustomConfigSpec(providerConfigDir, provider.getModId(), provider.getDefaultConfig());
                provider.registerConfigSpec(spec);
                LOGGER.info(" > Config registered successfully for '{}'\n", (Object)provider.getModId());
            }
            catch (Exception e) {
                LOGGER.error("Failed to load config for mod '{}'", (Object)provider.getModId(), (Object)e);
            }
        }
    }

    public static List<ILyivxConfigProvider> getConfigProviders() {
        return Collections.unmodifiableList(configProviders);
    }

    public static ResourceLocation createResourceLocation(String location) {
        return new ResourceLocation(MOD_ID, location);
    }
}

