/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.selector.entity.PieceSelectorNearbySmeltables;

public class PieceTrickSmeltItem
extends PieceTrick {
    SpellParam<Entity> target;

    public PieceTrickSmeltItem(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(80.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(240.0));
    }

    @Override
    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 80);
        meta.addStat(EnumSpellStat.COST, 240);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = this.getParamValue(context, this.target);
        if (targetVal instanceof ItemEntity && targetVal.m_6084_()) {
            ItemEntity eitem = (ItemEntity)targetVal;
            ItemStack stack = eitem.m_32055_();
            ItemStack result = PieceSelectorNearbySmeltables.simulateSmelt(eitem.m_20193_(), stack);
            if (!result.m_41619_()) {
                stack.m_41774_(1);
                eitem.m_32045_(stack);
                if (stack.m_41613_() == 0) {
                    eitem.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                ItemEntity item = new ItemEntity(context.focalPoint.m_20193_(), eitem.m_20185_(), eitem.m_20186_(), eitem.m_20189_(), result.m_41777_());
                context.focalPoint.m_20193_().m_7967_((Entity)item);
            }
        } else {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return null;
    }
}

