/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge;

import at.petrak.hexcasting.api.mod.HexConfig;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeHexConfig
implements HexConfig.CommonConfigAccess {
    private static ForgeConfigSpec.LongValue dustMediaAmount;
    private static ForgeConfigSpec.LongValue shardMediaAmount;
    private static ForgeConfigSpec.LongValue chargedCrystalMediaAmount;
    private static ForgeConfigSpec.DoubleValue mediaToHealthRate;
    private static ForgeConfigSpec.IntValue cypherCooldown;
    private static ForgeConfigSpec.IntValue trinketCooldown;
    private static ForgeConfigSpec.IntValue artifactCooldown;

    public ForgeHexConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Media Amounts");
        dustMediaAmount = builder.comment("How much media a single Amethyst Dust item is worth").defineInRange("dustMediaAmount", 10000L, 0L, Integer.MAX_VALUE);
        shardMediaAmount = builder.comment("How much media a single Amethyst Shard item is worth").defineInRange("shardMediaAmount", 50000L, 0L, Integer.MAX_VALUE);
        chargedCrystalMediaAmount = builder.comment("How much media a single Charged Amethyst Crystal item is worth").defineInRange("chargedCrystalMediaAmount", 100000L, 0L, Integer.MAX_VALUE);
        mediaToHealthRate = builder.comment("How many points of media a half-heart is worth when casting from HP").defineInRange("mediaToHealthRate", 10000.0, 0.0, Double.POSITIVE_INFINITY);
        builder.pop();
        builder.push("Cooldowns");
        cypherCooldown = builder.comment("Cooldown in ticks of a cypher").defineInRange("cypherCooldown", 8, 0, Integer.MAX_VALUE);
        trinketCooldown = builder.comment("Cooldown in ticks of a trinket").defineInRange("trinketCooldown", 5, 0, Integer.MAX_VALUE);
        artifactCooldown = builder.comment("Cooldown in ticks of a artifact").defineInRange("artifactCooldown", 3, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    @Override
    public long dustMediaAmount() {
        return (Long)dustMediaAmount.get();
    }

    @Override
    public long shardMediaAmount() {
        return (Long)shardMediaAmount.get();
    }

    @Override
    public long chargedCrystalMediaAmount() {
        return (Long)chargedCrystalMediaAmount.get();
    }

    @Override
    public double mediaToHealthRate() {
        return (Double)mediaToHealthRate.get();
    }

    @Override
    public int cypherCooldown() {
        return (Integer)cypherCooldown.get();
    }

    @Override
    public int trinketCooldown() {
        return (Integer)trinketCooldown.get();
    }

    @Override
    public int artifactCooldown() {
        return (Integer)artifactCooldown.get();
    }

    public static class Server
    implements HexConfig.ServerConfigAccess {
        private static ForgeConfigSpec.IntValue opBreakHarvestLevel;
        private static ForgeConfigSpec.IntValue maxOpCount;
        private static ForgeConfigSpec.IntValue maxSpellCircleLength;
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> actionDenyList;
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> circleActionDenyList;
        private static ForgeConfigSpec.BooleanValue greaterTeleportSplatsItems;
        private static ForgeConfigSpec.BooleanValue villagersOffendedByMindMurder;
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> tpDimDenyList;
        private static ForgeConfigSpec.BooleanValue doesTrueNameHaveAmbit;
        private static ForgeConfigSpec.DoubleValue traderScrollChance;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Spells");
            maxOpCount = builder.comment("The maximum number of actions that can be executed in one tick, to avoid hanging the server.").defineInRange("maxOpCount", 100000, 0, Integer.MAX_VALUE);
            opBreakHarvestLevel = builder.comment(new String[]{"The harvest level of the Break Block spell.", "0 = wood, 1 = stone, 2 = iron, 3 = diamond, 4 = netherite."}).defineInRange("opBreakHarvestLevel", 3, 0, 4);
            builder.pop();
            builder.push("Spell Circles");
            maxSpellCircleLength = builder.comment("The maximum number of slates in a spell circle").defineInRange("maxSpellCircleLength", 1024, 4, Integer.MAX_VALUE);
            circleActionDenyList = builder.comment("Resource locations of disallowed actions within circles. Trying to cast one of these in a circle will result in a mishap. For example: hexcasting:get_caster will prevent Mind's Reflection.").defineList("circleActionDenyList", List.of(), Server::isValidReslocArg);
            builder.pop();
            builder.push("Loot");
            traderScrollChance = builder.comment("The chance for wandering traders to sell an Ancient Scroll").defineInRange("traderScrollChance", 0.2, 0.0, 1.0);
            builder.pop();
            actionDenyList = builder.comment("Resource locations of disallowed actions. Trying to cast one of these will result in a mishap.").defineList("actionDenyList", List.of(), Server::isValidReslocArg);
            greaterTeleportSplatsItems = builder.comment("Should items fly out of the player's inventory when using Greater Teleport?").define("greaterTeleportSplatsItems", true);
            villagersOffendedByMindMurder = builder.comment("Should villagers take offense when you flay the mind of their fellow villagers?").define("villagersOffendedByMindMurder", true);
            tpDimDenyList = builder.comment("Resource locations of dimensions you can't Blink or Greater Teleport in.").defineList("tpDimDenyList", DEFAULT_DIM_TP_DENYLIST, Server::isValidReslocArg);
            doesTrueNameHaveAmbit = builder.comment("When false, makes player reference iotas behave as normal entity reference iotas").define("doesTrueNameHaveAmbit", true);
        }

        @Override
        public int opBreakHarvestLevelBecauseForgeThoughtItWasAGoodIdeaToImplementHarvestTiersUsingAnHonestToGodTopoSort() {
            return (Integer)opBreakHarvestLevel.get();
        }

        @Override
        public int maxOpCount() {
            return (Integer)maxOpCount.get();
        }

        @Override
        public int maxSpellCircleLength() {
            return (Integer)maxSpellCircleLength.get();
        }

        @Override
        public boolean isActionAllowed(ResourceLocation actionID) {
            return HexConfig.noneMatch((List)actionDenyList.get(), actionID);
        }

        @Override
        public boolean isActionAllowedInCircles(ResourceLocation actionID) {
            return HexConfig.noneMatch((List)circleActionDenyList.get(), actionID);
        }

        @Override
        public boolean doesGreaterTeleportSplatItems() {
            return (Boolean)greaterTeleportSplatsItems.get();
        }

        @Override
        public boolean doVillagersTakeOffenseAtMindMurder() {
            return (Boolean)villagersOffendedByMindMurder.get();
        }

        @Override
        public boolean canTeleportInThisDimension(ResourceKey<Level> dimension) {
            return HexConfig.noneMatch((List)tpDimDenyList.get(), dimension.m_135782_());
        }

        @Override
        public boolean trueNameHasAmbit() {
            return (Boolean)doesTrueNameHaveAmbit.get();
        }

        @Override
        public double traderScrollChance() {
            return (Double)traderScrollChance.get();
        }

        private static boolean isValidReslocArg(Object o) {
            String s;
            return o instanceof String && ResourceLocation.m_135830_((String)(s = (String)o));
        }
    }

    public static class Client
    implements HexConfig.ClientConfigAccess {
        private static ForgeConfigSpec.BooleanValue ctrlTogglesOffStrokeOrder;
        private static ForgeConfigSpec.BooleanValue invertSpellbookScrollDirection;
        private static ForgeConfigSpec.BooleanValue invertAbacusScrollDirection;
        private static ForgeConfigSpec.DoubleValue gridSnapThreshold;
        private static ForgeConfigSpec.BooleanValue clickingTogglesDrawing;
        private static ForgeConfigSpec.BooleanValue alwaysShowListCommas;

        public Client(ForgeConfigSpec.Builder builder) {
            ctrlTogglesOffStrokeOrder = builder.comment("Whether the ctrl key will instead turn *off* the color gradient on patterns").define("ctrlTogglesOffStrokeOrder", false);
            invertSpellbookScrollDirection = builder.comment("Whether scrolling up (as opposed to down) will increase the page index of the spellbook, and vice versa").define("invertSpellbookScrollDirection", false);
            invertAbacusScrollDirection = builder.comment("Whether scrolling up (as opposed to down) will increase the value of the abacus, and vice versa").define("invertAbacusScrollDirection", false);
            gridSnapThreshold = builder.comment("When using a staff, the distance from one dot you have to go to snap to the next dot, where 0.5 means 50% of the way.").defineInRange("gridSnapThreshold", 0.5, 0.5, 1.0);
            clickingTogglesDrawing = builder.comment("Whether you click to start and stop drawing instead of clicking and dragging").define("clickingTogglesDrawing", false);
            alwaysShowListCommas = builder.comment("Whether all iota types should be comma-separated in lists (by default, pattern iotas don't use commas)").define("alwaysShowListCommas", false);
        }

        @Override
        public boolean invertSpellbookScrollDirection() {
            return (Boolean)invertSpellbookScrollDirection.get();
        }

        @Override
        public boolean invertAbacusScrollDirection() {
            return (Boolean)invertAbacusScrollDirection.get();
        }

        @Override
        public boolean ctrlTogglesOffStrokeOrder() {
            return (Boolean)ctrlTogglesOffStrokeOrder.get();
        }

        @Override
        public double gridSnapThreshold() {
            return (Double)gridSnapThreshold.get();
        }

        @Override
        public boolean clickingTogglesDrawing() {
            return (Boolean)clickingTogglesDrawing.get();
        }

        @Override
        public boolean alwaysShowListCommas() {
            return (Boolean)alwaysShowListCommas.get();
        }
    }
}

