/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.server;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.math.EulerPathFinder;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class ScrungledPatternsSave
extends SavedData {
    public static final String DATA_VERSION = "0.1.0";
    public static final String TAG_SAVED_DATA = "hexcasting.per-world-patterns.0.1.0";
    private static final String TAG_DIR = "startDir";
    private static final String TAG_KEY = "key";
    private final Map<String, PerWorldEntry> lookup;
    private final Map<ResourceKey<ActionRegistryEntry>, String> reverseLookup;

    private ScrungledPatternsSave(Map<String, PerWorldEntry> lookup) {
        this.lookup = lookup;
        this.reverseLookup = new HashMap<ResourceKey<ActionRegistryEntry>, String>();
        this.lookup.forEach((sig, entry) -> this.reverseLookup.put(entry.key, (String)sig));
    }

    @Nullable
    public PerWorldEntry lookup(String signature) {
        return this.lookup.get(signature);
    }

    @Nullable
    public Pair<String, PerWorldEntry> lookupReverse(ResourceKey<ActionRegistryEntry> key) {
        String sig = this.reverseLookup.get(key);
        if (sig == null) {
            return null;
        }
        return Pair.of((Object)sig, (Object)this.lookup.get(sig));
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        this.lookup.forEach((sig, entry) -> {
            CompoundTag inner = new CompoundTag();
            inner.m_128344_(TAG_DIR, (byte)entry.canonicalStartDir.ordinal());
            inner.m_128359_(TAG_KEY, entry.key().m_135782_().toString());
            tag.m_128365_(sig, (Tag)inner);
        });
        return tag;
    }

    private static ScrungledPatternsSave load(CompoundTag tag) {
        ResourceKey registryKey = IXplatAbstractions.INSTANCE.getActionRegistry().m_123023_();
        HashMap<String, PerWorldEntry> map = new HashMap<String, PerWorldEntry>();
        for (String sig : tag.m_128431_()) {
            CompoundTag inner = tag.m_128469_(sig);
            byte rawDir = inner.m_128445_(TAG_DIR);
            String rawKey = inner.m_128461_(TAG_KEY);
            HexDir dir = HexDir.values()[rawDir];
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)registryKey, (ResourceLocation)new ResourceLocation(rawKey));
            map.put(sig, new PerWorldEntry((ResourceKey<ActionRegistryEntry>)key, dir));
        }
        return new ScrungledPatternsSave(map);
    }

    public static ScrungledPatternsSave createFromScratch(long seed) {
        HashMap<String, PerWorldEntry> map = new HashMap<String, PerWorldEntry>();
        Registry<ActionRegistryEntry> registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        for (ResourceKey key : registry.m_214010_()) {
            ActionRegistryEntry entry = (ActionRegistryEntry)registry.m_6246_(key);
            if (!HexUtils.isOfTag(registry, key, HexTags.Actions.PER_WORLD_PATTERN)) continue;
            HexPattern scrungledPat = EulerPathFinder.findAltDrawing(entry.prototype(), seed);
            map.put(scrungledPat.anglesSignature(), new PerWorldEntry((ResourceKey<ActionRegistryEntry>)key, scrungledPat.getStartDir()));
        }
        ScrungledPatternsSave out = new ScrungledPatternsSave(map);
        out.m_77762_();
        return out;
    }

    public static ScrungledPatternsSave open(ServerLevel overworld) {
        return (ScrungledPatternsSave)overworld.m_8895_().m_164861_(ScrungledPatternsSave::load, () -> ScrungledPatternsSave.createFromScratch(overworld.m_7328_()), TAG_SAVED_DATA);
    }

    public record PerWorldEntry(ResourceKey<ActionRegistryEntry> key, HexDir canonicalStartDir) {
    }
}

