/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.io.IOException;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;

public class VersionUtil {
    public static ResourceLocation getId(String path) {
        return new ResourceLocation("particlerain", path);
    }

    public static ResourceLocation getMcId(String path) {
        return new ResourceLocation("minecraft", path);
    }

    public static ResourceLocation parseId(String string) {
        try {
            return ResourceLocation.m_135820_((String)string);
        }
        catch (ResourceLocationException e) {
            return null;
        }
    }

    public static ClipContext getClipContext(Vec3 clipStart, Vec3 clipEnd) {
        return new ClipContext(clipStart, clipEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)Minecraft.m_91087_().f_91074_);
    }

    public static AnimationMetadataSection getEmptySpriteMetadata() {
        return AnimationMetadataSection.f_119012_;
    }

    public static SpriteContents loadSplashSprite(int i) throws IOException {
        ResourceLocation location = VersionUtil.getMcId("textures/particle/splash_" + i + ".png");
        Resource resource = Minecraft.m_91087_().m_91098_().m_215593_(location);
        AnimationMetadataSection metadata = resource.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
        NativeImage splashImage = TextureUtil.loadTexture(resource);
        TextureUtil.desaturate(splashImage);
        return new SpriteContents(VersionUtil.getId("splash_" + i), metadata.m_245821_(splashImage.m_84982_(), splashImage.m_85084_()), splashImage, metadata);
    }

    public static Biome.Precipitation getPrecipitationAt(Level level, Holder<Biome> biome, BlockPos blockPos) {
        return ((Biome)biome.m_203334_()).m_264600_(blockPos);
    }

    public static Color getMapColor(ClientLevel level, BlockPos blockPos) {
        Color color = new Color(level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_7495_()).m_60734_().m_284356_().m_284280_(MapColor.Brightness.NORMAL));
        return new Color(color.getBlue(), color.getGreen(), color.getRed());
    }

    public static void schedule(Runnable task) {
        Minecraft.m_91087_().m_6937_(task);
    }

    public static <T> Stream<TagKey<T>> getTagIds(Registry<T> registry) {
        return registry.m_203613_();
    }

    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> key) {
        return Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(key);
    }

    public static int getCloudHeight(ClientLevel level) {
        return (int)level.m_104583_().m_108871_();
    }

    public static TextureAtlasSprite getSprite(ResourceLocation id) {
        return ((ParticleEngineAccessor)Minecraft.m_91087_().f_91061_).getTextureAtlas().m_118316_(id);
    }

    public static SpriteContents newNonAnimatedSpriteContents(String id, FrameSize frameSize, NativeImage sprite) {
        return new SpriteContents(VersionUtil.getId(id), frameSize, sprite, VersionUtil.getEmptySpriteMetadata());
    }
}

