/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.model;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.MalumMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import team.lodestar.lodestone.systems.model.LodestoneArmorModel;

public class SoulHunterArmorModel
extends LodestoneArmorModel {
    public static ModelLayerLocation LAYER = new ModelLayerLocation(MalumMod.malumPath("soul_hunter_armor"), "main");
    public ModelPart cape;
    public ModelPart lowered_hood;

    public SoulHunterArmorModel(ModelPart root) {
        super(root);
        this.cape = root.m_171324_("cape");
        this.lowered_hood = root.m_171324_("lowered_hood");
    }

    protected Iterable<ModelPart> m_5608_() {
        if (this.slot == EquipmentSlot.CHEST) {
            return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.cape, (Object)this.lowered_hood);
        }
        if (this.slot == EquipmentSlot.LEGS) {
            return ImmutableList.of((Object)this.leftLegging, (Object)this.rightLegging, (Object)this.leggings);
        }
        return this.slot == EquipmentSlot.FEET ? ImmutableList.of((Object)this.leftFoot, (Object)this.rightFoot) : ImmutableList.of();
    }

    public void copyFromDefault(HumanoidModel model) {
        super.copyFromDefault(model);
        this.cape.m_104315_(model.f_102810_);
        this.lowered_hood.m_104315_(model.f_102810_);
    }

    public void m_6973_(LivingEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float pPartialTicks = Minecraft.m_91087_().m_91297_();
        this.lowered_hood.f_104207_ = pEntity.m_6844_(EquipmentSlot.HEAD).m_41619_();
        if (pEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)pEntity;
            double d0 = Mth.m_14139_((double)pPartialTicks, (double)clientPlayer.f_36102_, (double)clientPlayer.f_36105_) - Mth.m_14139_((double)pPartialTicks, (double)pEntity.f_19854_, (double)pEntity.m_20185_());
            double d1 = Mth.m_14139_((double)pPartialTicks, (double)clientPlayer.f_36103_, (double)clientPlayer.f_36106_) - Mth.m_14139_((double)pPartialTicks, (double)pEntity.f_19855_, (double)pEntity.m_20186_());
            double d2 = Mth.m_14139_((double)pPartialTicks, (double)clientPlayer.f_36104_, (double)clientPlayer.f_36075_) - Mth.m_14139_((double)pPartialTicks, (double)pEntity.f_19856_, (double)pEntity.m_20189_());
            float f = pEntity.f_20884_ + (pEntity.f_20883_ - pEntity.f_20884_);
            double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)16.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 65.0f;
            f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)75.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.m_14036_((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Mth.m_14179_((float)pPartialTicks, (float)clientPlayer.f_36099_, (float)clientPlayer.f_36100_);
            f1 += Mth.m_14031_((float)(Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19867_, (float)pEntity.f_19787_) * 6.0f)) * 32.0f * f4;
            if (pEntity.m_6047_()) {
                f1 += 25.0f;
            }
            float x = (float)Math.toRadians(6.0f + f2 / 2.0f + f1);
            float y = (float)Math.toRadians(f3 / 2.0f);
            float z = (float)Math.toRadians(f3 / 2.0f);
            this.cape.f_104203_ = x;
            this.cape.f_104204_ = y;
            this.cape.f_104205_ = z;
            this.lowered_hood.f_104203_ = x / 3.0f;
            this.lowered_hood.f_104204_ = y / 3.0f;
            this.lowered_hood.f_104205_ = z / 3.0f;
        } else {
            this.cape.f_104203_ = 0.0f;
            this.cape.f_104204_ = 0.0f;
            this.cape.f_104205_ = 0.0f;
            this.lowered_hood.f_104203_ = 0.0f;
            this.lowered_hood.f_104204_ = 0.0f;
            this.lowered_hood.f_104205_ = 0.0f;
        }
        super.m_6973_(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.0f), (float)0.0f);
        PartDefinition root = SoulHunterArmorModel.createHumanoidAlias((MeshDefinition)mesh);
        PartDefinition cape = root.m_171599_("cape", new CubeListBuilder(), PartPose.f_171404_);
        PartDefinition lowered_hood = root.m_171599_("lowered_hood", new CubeListBuilder(), PartPose.f_171404_);
        PartDefinition body = root.m_171597_("body");
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-4.5f, -0.5f, -2.5f, 9.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(28, 18).m_171488_(-4.5f, -0.5f, -2.5f, 9.0f, 10.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_stripe = torso.m_171599_("left_stripe", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-1.9074f, 0.0f, -0.6014f, 3.0f, 10.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-2.5f, (float)-0.5f, (float)-2.5f, (float)-0.0892f, (float)0.3487f, (float)-0.0061f));
        PartDefinition right_stripe = torso.m_171599_("right_stripe", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171480_().m_171488_(-1.0926f, 0.0f, -0.6014f, 3.0f, 10.0f, 1.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)-0.5f, (float)-2.5f, (float)-0.0892f, (float)-0.3487f, (float)0.0061f));
        PartDefinition leggings = root.m_171597_("leggings");
        PartDefinition codpiece = leggings.m_171599_("codpiece", CubeListBuilder.m_171558_().m_171514_(0, 84).m_171488_(-5.0f, -14.5f, -3.5f, 10.0f, 3.0f, 7.0f, new CubeDeformation(0.01f)).m_171514_(34, 84).m_171488_(-5.0f, -14.5f, -3.5f, 10.0f, 3.0f, 7.0f, new CubeDeformation(0.26f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_legging = root.m_171597_("right_legging");
        PartDefinition right_leg = right_legging.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(39, 103).m_171488_(-2.5f, -0.5f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg_robe = right_legging.m_171599_("right_leg_robe", CubeListBuilder.m_171558_().m_171514_(0, 118).m_171488_(-1.0f, 3.0f, -5.0f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.25f)).m_171514_(0, 108).m_171488_(-1.0f, 3.0f, -5.0f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(22, 94).m_171488_(0.0f, -1.0f, -5.0f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.25f)).m_171514_(0, 94).m_171488_(0.0f, -1.0f, -5.0f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-0.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition right_foot = root.m_171597_("right_foot");
        PartDefinition right_boot = right_foot.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(16, 116).m_171488_(-3.0f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(40, 116).m_171488_(-3.0f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = root.m_171597_("right_arm");
        PartDefinition right_shoulder = right_arm.m_171599_("right_shoulder", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171480_().m_171488_(-4.5f, 5.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.01f)).m_171555_(false).m_171514_(20, 44).m_171480_().m_171488_(-4.5f, 5.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.26f)).m_171555_(false).m_171514_(40, 46).m_171480_().m_171488_(-5.5f, 4.5f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(50, 46).m_171480_().m_171488_(-5.5f, 4.5f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(8, 33).m_171480_().m_171488_(-4.5f, -2.5f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.01f)).m_171555_(false).m_171514_(28, 33).m_171480_().m_171488_(-4.5f, -2.5f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.26f)).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_legging = root.m_171597_("left_legging");
        PartDefinition left_leg = left_legging.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(39, 103).m_171480_().m_171488_(-2.5f, -0.5f, -2.5f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_robe = left_legging.m_171599_("left_leg_robe", CubeListBuilder.m_171558_().m_171514_(0, 118).m_171480_().m_171488_(0.0f, 3.0f, -5.0f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(0, 108).m_171480_().m_171488_(0.0f, 3.0f, -5.0f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(22, 94).m_171480_().m_171488_(-4.0f, -1.0f, -5.0f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(0, 94).m_171480_().m_171488_(-4.0f, -1.0f, -5.0f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.0f, (float)-0.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition left_foot = root.m_171597_("left_foot");
        PartDefinition left_boot = left_foot.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(16, 116).m_171480_().m_171488_(-3.0f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.01f)).m_171555_(false).m_171514_(40, 116).m_171480_().m_171488_(-3.0f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = root.m_171597_("left_arm");
        PartDefinition left_shoulder = left_arm.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171514_(8, 33).m_171488_(-0.5f, -2.5f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.01f)).m_171514_(28, 33).m_171488_(-0.5f, -2.5f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.26f)).m_171514_(0, 44).m_171488_(-0.5f, 5.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.01f)).m_171514_(20, 44).m_171488_(-0.5f, 5.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.26f)).m_171514_(40, 46).m_171488_(3.5f, 4.5f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(50, 46).m_171488_(3.5f, 4.5f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = root.m_171597_("head");
        PartDefinition helmet = head.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(36, 0).m_171488_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_hood_bit = head.m_171599_("left_hood_bit", CubeListBuilder.m_171558_().m_171514_(53, 59).m_171480_().m_171488_(-2.0f, -5.0f, -4.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(53, 47).m_171480_().m_171488_(-2.0f, -5.0f, -4.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.5f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition back_hood_bit = head.m_171599_("back_hood_bit", CubeListBuilder.m_171558_().m_171514_(48, 33).m_171488_(-3.5f, 0.0f, 0.0f, 7.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.5f, (float)4.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_hood_bit = head.m_171599_("right_hood_bit", CubeListBuilder.m_171558_().m_171514_(53, 59).m_171488_(0.0f, -5.0f, -4.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.25f)).m_171514_(53, 47).m_171488_(0.0f, -5.0f, -4.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cape_top = cape.m_171599_("cape_top", CubeListBuilder.m_171558_().m_171514_(0, 54).m_171488_(-6.5213f, -0.1479f, -1.0812f, 11.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 54).m_171488_(-6.5213f, -0.1479f, -1.0812f, 11.0f, 8.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)1.0f, (float)-0.5f, (float)3.5f, (float)0.0839f, (float)-0.02f, (float)0.0126f));
        PartDefinition cape_middle = cape_top.m_171599_("cape_middle", CubeListBuilder.m_171558_().m_171514_(24, 62).m_171488_(-6.5213f, -0.2878f, -1.0526f, 11.0f, 7.0f, 1.0f, new CubeDeformation(0.25f)).m_171514_(0, 62).m_171488_(-6.5213f, -0.2878f, -1.0526f, 11.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cape_bottom = cape_middle.m_171599_("cape_bottom", CubeListBuilder.m_171558_().m_171514_(24, 77).m_171488_(-6.5213f, -0.9301f, 2.1414f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 77).m_171488_(-3.5213f, -0.9301f, 2.1414f, 5.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 77).m_171480_().m_171488_(1.4787f, -0.9301f, 2.1414f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(32, 77).m_171480_().m_171488_(1.4787f, -0.9301f, 2.1414f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(12, 77).m_171488_(-3.5213f, -0.9301f, 2.1414f, 5.0f, 6.0f, 1.0f, new CubeDeformation(0.25f)).m_171514_(32, 77).m_171488_(-6.5213f, -0.9301f, 2.1414f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)-3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition hood = lowered_hood.m_171599_("hood", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition overhang = hood.m_171599_("overhang", CubeListBuilder.m_171558_().m_171514_(26, 70).m_171488_(-4.98f, -0.5028f, -2.1358f, 8.0f, 2.0f, 5.0f, new CubeDeformation(0.25f)).m_171514_(0, 70).m_171488_(-4.98f, -0.5028f, -2.1358f, 8.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-0.5f, (float)3.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }
}

