/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.storage.jar;

import com.sammy.malum.common.block.storage.jar.SpiritJarBlockEntity;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.block.WaterLoggedEntityBlock;

public class SpiritJarBlock<T extends SpiritJarBlockEntity>
extends WaterLoggedEntityBlock<T> {
    public static final VoxelShape SHAPE = SpiritJarBlock.makeShape();

    public SpiritJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public void m_6256_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        this.handleAttack(pLevel, pPos, pPlayer);
    }

    public boolean handleAttack(Level pLevel, BlockPos pPos, Player pPlayer) {
        SpiritJarBlockEntity jar;
        IItemHandler jarHandler;
        ItemStack item;
        BlockEntity be = pLevel.m_7702_(pPos);
        if (be instanceof SpiritJarBlockEntity && !(item = (jarHandler = (IItemHandler)(jar = (SpiritJarBlockEntity)be).getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).orElse((Object)new EmptyHandler())).extractItem(0, pPlayer.m_6144_() ? 64 : 1, false)).m_41619_()) {
            ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)item, (int)pPlayer.m_150109_().f_35977_);
            if (!pLevel.f_46443_) {
                BlockHelper.updateAndNotifyState((Level)pLevel, (BlockPos)pPos);
            }
            return true;
        }
        return false;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity be = pLevel.m_7702_(pPos);
        if (be instanceof SpiritJarBlockEntity) {
            SpiritJarBlockEntity jar = (SpiritJarBlockEntity)be;
            if (jar.type == null) {
                return 0;
            }
            return Math.min(SpiritTypeRegistry.getIndexForSpiritType(jar.type) + 1, 15);
        }
        return 0;
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.15625, (double)0.03125, (double)0.15625, (double)0.84375, (double)0.84375, (double)0.84375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.21875, (double)0.90625, (double)0.21875, (double)0.78125, (double)1.03125, (double)0.78125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.28125, (double)0.84375, (double)0.28125, (double)0.71875, (double)0.90625, (double)0.71875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.34375, (double)-0.03125, (double)0.34375, (double)0.65625, (double)0.09375, (double)0.65625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }
}

