/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.activator;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.registry.common.AttributeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;

public class SpiritCollectionActivatorEntity
extends FloatingEntity {
    public SpiritCollectionActivatorEntity(Level level) {
        super((EntityType<? extends FloatingEntity>)((EntityType)EntityRegistry.SPIRIT_COLLECTION_ACTIVATOR.get()), level);
        this.maxAge = 4000;
    }

    public SpiritCollectionActivatorEntity(Level level, UUID ownerUUID, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        this(level);
        this.setOwner(ownerUUID);
        this.m_6034_(posX, posY, posZ);
        this.m_20334_(velX, velY, velZ);
        this.maxAge = 800;
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    @Override
    public void collect() {
        AttributeInstance instance = this.owner.m_21051_((Attribute)AttributeRegistry.ARCANE_RESONANCE.get());
        ItemHelper.getEventResponders((LivingEntity)this.owner).forEach(s -> {
            Item patt1414$temp = s.m_41720_();
            if (patt1414$temp instanceof IMalumEventResponderItem) {
                IMalumEventResponderItem eventItem = (IMalumEventResponderItem)patt1414$temp;
                eventItem.pickupSpirit(this.owner, instance != null ? instance.m_22135_() : 0.0);
            }
        });
        SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)SoundRegistry.SPIRIT_PICKUP.get()), (float)0.3f, (float)Mth.m_216267_((RandomSource)this.f_19796_, (float)1.2f, (float)1.5f));
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
        Vec3 motion = this.m_20184_();
        Vec3 norm = motion.m_82541_().m_82490_((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.m_9236_(), new Vec3(x, y, z), SpiritTypeRegistry.ELDRITCH_SPIRIT);
        lightSpecs.getBuilder().setMotion(norm);
        lightSpecs.getBloomBuilder().setMotion(norm);
        lightSpecs.spawnParticles();
    }

    @Override
    public float getMotionCoefficient() {
        return 0.04f;
    }

    @Override
    public float getFriction() {
        return 0.9f;
    }

    protected void m_8097_() {
    }
}

