/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.scythe;

import com.sammy.malum.common.enchantment.scythe.ReboundEnchantment;
import com.sammy.malum.common.entity.scythe.AbstractScytheProjectileEntity;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class ScytheBoomerangEntity
extends AbstractScytheProjectileEntity {
    private static final EntityDataAccessor<Boolean> DATA_ENHANCED = SynchedEntityData.m_135353_(ScytheBoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ScytheBoomerangEntity(Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)EntityRegistry.SCYTHE_BOOMERANG.get()), level);
    }

    public ScytheBoomerangEntity(Level level, double pX, double pY, double pZ) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)EntityRegistry.SCYTHE_BOOMERANG.get()), pX, pY, pZ, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_ENHANCED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isEnhanced", this.isEnhanced());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEnhanced(compound.m_128471_("isEnhanced"));
    }

    public void setEnhanced(boolean enhanced) {
        this.m_20088_().m_135381_(DATA_ENHANCED, (Object)enhanced);
    }

    public boolean isEnhanced() {
        return (Boolean)this.m_20088_().m_135370_(DATA_ENHANCED);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.returnTimer = 0;
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity scytheOwner = (LivingEntity)entity;
            this.flyBack((Entity)scytheOwner);
        }
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (this.isEnhanced()) {
            this.returnTimer = 0;
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity scytheOwner = (LivingEntity)entity;
                this.flyBack((Entity)scytheOwner);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        ItemStack scythe = this.m_7846_();
        Level level = this.m_9236_();
        if (!level.m_5776_()) {
            Entity owner = this.m_19749_();
            if (owner == null || !owner.m_6084_() || !owner.m_9236_().equals(this.m_9236_()) || this.m_20270_(owner) > 1000.0f) {
                this.m_20256_(Vec3.f_82478_);
                return;
            }
            if (owner instanceof LivingEntity) {
                LivingEntity scytheOwner = (LivingEntity)owner;
                if (this.age % 3 == 0) {
                    float pitch = (float)((double)0.8f + Math.sin((float)level.m_46467_() * 0.5f) * (double)0.2f);
                    float volumeScalar = Mth.m_14036_((float)((float)this.age / 12.0f), (float)0.0f, (float)1.0f);
                    if (this.m_20069_()) {
                        volumeScalar *= 0.2f;
                        pitch *= 0.5f;
                    }
                    SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)SoundRegistry.SCYTHE_SPINS.get()), (float)(0.6f * volumeScalar), (float)pitch);
                    SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)SoundRegistry.SCYTHE_SWEEP.get()), (float)(0.4f * volumeScalar), (float)pitch);
                }
                if (this.returnTimer <= 0) {
                    Vec3 ownerPos = scytheOwner.m_20182_().m_82520_(0.0, (double)(scytheOwner.m_20206_() * 0.6f), 0.0);
                    float velocityLimit = 2.0f;
                    if (this.isEnhanced()) {
                        double radians = Math.toRadians(90.0f - scytheOwner.f_20885_);
                        ownerPos = scytheOwner.m_20182_().m_82520_(0.75 * Math.sin(radians), (double)(scytheOwner.m_20206_() * 0.5f), 0.75 * Math.cos(radians));
                        velocityLimit = 4.0f;
                        if (this.returnTimer == 0) {
                            this.flyBack((Entity)scytheOwner);
                        }
                    }
                    Vec3 motion = this.m_20184_();
                    double velocity = Mth.m_14008_((double)(motion.m_82553_() * 3.0), (double)0.5, (double)velocityLimit);
                    Vec3 returnMotion = ownerPos.m_82546_(this.m_20182_()).m_82541_().m_82490_(velocity);
                    float distance = this.m_20270_((Entity)scytheOwner);
                    if (this.m_6084_() && distance < 3.0f && scytheOwner instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)scytheOwner;
                        ReboundEnchantment.pickupScythe(this, scythe, player);
                        SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)SoundRegistry.SCYTHE_CATCH.get()), (float)1.5f, (float)RandomHelper.randomBetween((RandomSource)this.m_9236_().m_213780_(), (float)0.75f, (float)1.25f));
                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                    float delta = 0.1f;
                    double x = Mth.m_14139_((double)delta, (double)motion.f_82479_, (double)returnMotion.f_82479_);
                    double y = Mth.m_14139_((double)delta, (double)motion.f_82480_, (double)returnMotion.f_82480_);
                    double z = Mth.m_14139_((double)delta, (double)motion.f_82481_, (double)returnMotion.f_82481_);
                    this.m_20256_(new Vec3(x, y, z));
                }
                --this.returnTimer;
            }
            this.m_37283_();
        }
    }

    @Override
    public void addTrailPoints() {
        if (this.isEnhanced()) {
            Vec3 direction = this.m_20184_().m_82541_();
            float yRot = (float)(Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.m_82537_(direction);
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.m_20318_(progress);
                float scalar = ((float)this.age + progress) / 2.0f;
                for (int j = 0; j < 2; ++j) {
                    TrailPointBuilder trail = j == 0 ? this.theFormer : this.theLatter;
                    float angle = this.spinOffset + 3.14f * (float)j + scalar;
                    Vec3 offset = direction.m_82490_(Math.sin(angle)).m_82549_(up.m_82490_(Math.cos(angle))).m_82541_().m_82490_((double)1.2f);
                    trail.addTrailPoint(position.m_82549_(offset));
                }
            }
            return;
        }
        super.addTrailPoints();
    }

    public void flyBack(Entity scytheOwner) {
        Vec3 ownerPos = scytheOwner.m_20182_().m_82520_(0.0, (double)(scytheOwner.m_20206_() * 0.5f), 0.0);
        Vec3 returnMotion = ownerPos.m_82546_(this.m_20182_()).m_82541_().m_82490_(0.75);
        this.m_20256_(returnMotion);
    }
}

