/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.curiosities.rite;

import com.sammy.malum.common.packets.particle.base.spirit.SpiritBasedBlockParticleEffectPacket;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.LodestoneClientPacket;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public class InfernalAccelerationRiteEffectPacket
extends SpiritBasedBlockParticleEffectPacket {
    public InfernalAccelerationRiteEffectPacket(List<String> spirits, BlockPos pos) {
        super(spirits, pos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Supplier<NetworkEvent.Context> context, MalumSpiritType spiritType) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RandomSource rand = level.f_46441_;
        Color color = spiritType.getPrimaryColor();
        Color endColor = spiritType.getSecondaryColor();
        for (int i = 0; i < 3; ++i) {
            int spinDirection = rand.m_188499_() ? 1 : -1;
            int spinOffset = rand.m_188503_(360);
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SMOKE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.02f, (float)0.095f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData(SpinParticleData.create((float)((0.125f + rand.m_188501_() * 0.075f) * (float)spinDirection)).setSpinOffset((float)spinOffset).build()).setScaleData(GenericParticleData.create((float)0.25f, (float)0.45f, (float)0.0f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor).build()).setLifetime(50 + rand.m_188503_(10)).setRandomOffset((double)0.4f).enableNoClip().setRandomMotion((double)0.01f, (double)0.01f).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).repeatSurroundBlock((Level)level, this.pos, 1);
        }
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, InfernalAccelerationRiteEffectPacket.class, SpiritBasedBlockParticleEffectPacket::encode, InfernalAccelerationRiteEffectPacket::decode, LodestoneClientPacket::handle);
    }

    public static InfernalAccelerationRiteEffectPacket decode(FriendlyByteBuf buf) {
        return InfernalAccelerationRiteEffectPacket.decode(InfernalAccelerationRiteEffectPacket::new, buf);
    }
}

