/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.curiosities.rite.generic;

import com.sammy.malum.common.packets.particle.base.color.ColorBasedBlockParticleEffectPacket;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.LodestoneClientPacket;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public class BlockSparkleParticlePacket
extends ColorBasedBlockParticleEffectPacket {
    public BlockSparkleParticlePacket(Color color, BlockPos pos) {
        super(color, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void execute(Supplier<NetworkEvent.Context> context) {
        int spinOffset;
        int spinDirection;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RandomSource rand = level.f_46441_;
        for (i = 0; i < 5; ++i) {
            spinDirection = rand.m_188499_() ? 1 : -1;
            spinOffset = rand.m_188503_(360);
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.TWINKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.8f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)(0.7f * (float)spinDirection), (float)0.0f).setCoefficient(1.25f).setSpinOffset((float)spinOffset).setEasing(Easing.CUBIC_IN).build()).setScaleData(GenericParticleData.create((float)0.05f, (float)0.1f, (float)0.0f).setCoefficient(0.8f).setEasing(Easing.QUINTIC_OUT, Easing.EXPO_IN_OUT).build()).setColorData(ColorParticleData.create((Color)ColorHelper.brighter((Color)this.color, (int)2), (Color)this.color).build()).setLifetime(20).enableNoClip().setRandomOffset((double)0.6f).setGravityStrength(1.1f).addMotion(0.0, (double)(0.28f + rand.m_188501_() * 0.15f), 0.0).disableNoClip().setRandomMotion((double)0.1f, (double)0.15f).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).repeat((Level)level, (double)((float)this.pos.m_123341_() + 0.5f), (double)((float)this.pos.m_123342_() + 0.2f), (double)((float)this.pos.m_123343_() + 0.5f), 1);
        }
        for (i = 0; i < 2; ++i) {
            spinDirection = rand.m_188499_() ? 1 : -1;
            spinOffset = rand.m_188503_(360);
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SMOKE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.05f, (float)0.08f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData(SpinParticleData.create((float)((0.125f + rand.m_188501_() * 0.075f) * (float)spinDirection)).setSpinOffset((float)spinOffset).build()).setScaleData(GenericParticleData.create((float)0.35f, (float)0.5f, (float)0.0f).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)this.color, (Color)this.color).build()).setLifetime(50 + rand.m_188503_(10)).setRandomOffset((double)0.4f).enableNoClip().setRandomMotion((double)0.01f, (double)0.01f).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).repeatSurroundBlock((Level)level, this.pos, 1);
        }
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, BlockSparkleParticlePacket.class, ColorBasedBlockParticleEffectPacket::encode, BlockSparkleParticlePacket::decode, LodestoneClientPacket::handle);
    }

    public static BlockSparkleParticlePacket decode(FriendlyByteBuf buf) {
        return BlockSparkleParticlePacket.decode(BlockSparkleParticlePacket::new, buf);
    }
}

