/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.item;

import com.sammy.malum.common.item.cosmetic.skins.ArmorSkin;
import com.sammy.malum.core.systems.ritual.MalumRitualTier;
import com.sammy.malum.registry.common.item.ArmorSkinRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmith;
import team.lodestar.lodestone.systems.item.LodestoneArmorItem;

public class MalumItemModelSmithTypes {
    public static ItemModelSmith IMPETUS_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        List split = (List)DataHelper.reverseOrder(new ArrayList(), Arrays.asList(name.split("_")));
        split.remove(0);
        String alteredName = String.join((CharSequence)"_", split);
        provider.createGenericModel(item, ItemModelSmithTypes.GENERATED, provider.getItemTexture(alteredName));
    });
    public static ItemModelSmith RITUAL_SHARD_ITEM = new ItemModelSmith((item, provider) -> {
        String base = "ritual_shard";
        provider.createGenericModel(item, ItemModelSmithTypes.GENERATED, provider.getItemTexture(base + "_faded"));
        for (MalumRitualTier ritualTier : MalumRitualTier.TIERS) {
            if (ritualTier.equals(MalumRitualTier.FADED)) continue;
            String path = ritualTier.identifier.m_135815_();
            ResourceLocation itemTexturePath = provider.getItemTexture(base + "_" + path);
            ((ItemModelBuilder)provider.getBuilder(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_())).override().predicate(new ResourceLocation("stored_ritual"), (float)ritualTier.potency).model((ModelFile)((ItemModelBuilder)provider.withExistingParent(provider.getItemName(item) + "_" + path, ItemModelSmithTypes.GENERATED)).texture("layer0", itemTexturePath)).end();
        }
    });
    public static ItemModelSmith CATALYST_LOBBER = new ItemModelSmith((item, provider) -> {
        String base = provider.getItemName(item);
        provider.createGenericModel(item, ItemModelSmithTypes.HANDHELD, provider.getItemTexture(base));
        for (int i = 1; i <= 2; ++i) {
            String affix = i == 1 ? "open" : "loaded";
            ResourceLocation itemTexturePath = provider.getItemTexture(base + "_" + affix);
            ((ItemModelBuilder)provider.getBuilder(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_())).override().predicate(new ResourceLocation("malum:state"), (float)i).model((ModelFile)((ItemModelBuilder)provider.withExistingParent(base + "_" + affix, ItemModelSmithTypes.HANDHELD)).texture("layer0", itemTexturePath)).end();
        }
    });
    public static ItemModelSmith SPIRIT_ITEM = new ItemModelSmith((item, provider) -> provider.createGenericModel(item, ItemModelSmithTypes.GENERATED, provider.getItemTexture("spirit_shard")));
    public static ItemModelSmith GENERATED_OVERLAY_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        ((ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, ItemModelSmithTypes.GENERATED)).texture("layer0", provider.getItemTexture(name))).texture("layer1", provider.getItemTexture(name + "_overlay"));
    });
    public static ItemModelSmith HANDHELD_OVERLAY_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        ((ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, ItemModelSmithTypes.HANDHELD)).texture("layer0", provider.getItemTexture(name))).texture("layer1", provider.getItemTexture(name + "_overlay"));
    });
    public static ItemModelSmith ETHER_BRAZIER_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        String rockType = name.split("_")[0];
        String brazierName = rockType + "_ether_brazier";
        String overlayName = name.replace(rockType + "_", "");
        ((ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, ItemModelSmithTypes.GENERATED)).texture("layer0", provider.getItemTexture(brazierName))).texture("layer1", provider.getItemTexture(overlayName + "_overlay"));
    });
    public static ItemModelSmith IRIDESCENT_ETHER_BRAZIER_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        String rockType = name.split("_")[0];
        String brazierName = rockType + "_ether_brazier";
        String overlayName = name.replace(rockType + "_", "");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, ItemModelSmithTypes.GENERATED)).texture("layer0", provider.getItemTexture(brazierName))).texture("layer1", provider.getItemTexture(overlayName))).texture("layer2", provider.getItemTexture(overlayName + "_overlay"));
    });
    public static ItemModelSmith IRIDESCENT_ETHER_TORCH_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, ItemModelSmithTypes.HANDHELD)).texture("layer0", provider.getItemTexture("ether_torch"))).texture("layer1", provider.getItemTexture(name))).texture("layer2", provider.getItemTexture(name + "_overlay"));
    });
    public static ItemModelSmith ARMOR_ITEM = new ItemModelSmith((item, provider) -> {
        String name = provider.getItemName(item);
        provider.createGenericModel(item, ItemModelSmithTypes.GENERATED, provider.getItemTexture(name));
        for (Map.Entry<String, ArmorSkin> entry : ArmorSkinRegistry.SKINS.entrySet()) {
            ArmorSkin skin = entry.getValue();
            int value = skin.index;
            ArmorSkin.ArmorSkinDatagenData datagenData = ArmorSkinRegistry.SKIN_DATAGEN_DATA.get(skin);
            if (datagenData == null) continue;
            String itemSuffix = datagenData.getSuffix((LodestoneArmorItem)item);
            ResourceLocation itemTexturePath = new ResourceLocation(datagenData.itemTexturePrefix + itemSuffix);
            ((ItemModelBuilder)provider.getBuilder(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_())).override().predicate(new ResourceLocation("malum:item_skin"), (float)value).model((ModelFile)((ItemModelBuilder)provider.withExistingParent(entry.getKey() + "_" + itemSuffix, ItemModelSmithTypes.GENERATED)).texture("layer0", itemTexturePath)).end();
        }
    });
}

