/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.capability.MalumLivingEntityDataCapability;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.core.handlers.TouchOfDarknessHandler;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class ScreenParticleEffects {
    public static void spawnRuneParticles(ScreenParticleHolder target, MalumSpiritType spiritType) {
        RandomSource rand = Minecraft.m_91087_().f_91073_.m_213780_();
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.SPARKLE, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)0.03f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)(0.5f + rand.m_188501_() * 0.1f), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.BOUNCE_IN_OUT).build()).setColorData(spiritType.createColorData().build()).setLifetime(RandomHelper.randomBetween((RandomSource)rand, (int)20, (int)30)).setRandomOffset((double)0.05f).setRandomMotion((double)0.05f, (double)0.05f).spawnOnStack(0.0, -1.0);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)0.015f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData(SpinParticleData.create((float)Mth.m_216267_((RandomSource)rand, (float)0.2f, (float)0.4f)).setEasing(Easing.EXPO_OUT).build()).setScaleData(GenericParticleData.create((float)(0.3f + rand.m_188501_() * 0.3f), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setColorData(spiritType.createColorData().build()).setLifetime(RandomHelper.randomBetween((RandomSource)rand, (int)20, (int)30)).setRandomOffset((double)0.1f).setRandomMotion((double)0.4f, (double)0.4f).spawnOnStack(0.0, 0.0).setLifetime(RandomHelper.randomBetween((RandomSource)rand, (int)8, (int)12)).setSpinData(SpinParticleData.create((float)Mth.m_216267_((RandomSource)rand, (float)0.05f, (float)0.1f)).build()).setScaleData(GenericParticleData.create((float)(0.6f + rand.m_188501_() * 0.3f), (float)0.0f).build()).setRandomMotion((double)0.01f, (double)0.01f).spawnOnStack(0.0, -1.0);
    }

    public static void spawnSpiritShardScreenParticles(ScreenParticleHolder target, MalumSpiritType spiritType) {
        RandomSource rand = Minecraft.m_91087_().f_91073_.m_213780_();
        Color color = spiritType.getPrimaryColor();
        Color endColor = spiritType.getSecondaryColor();
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.SPARKLE, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)0.04f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)(0.8f + rand.m_188501_() * 0.1f), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.BOUNCE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor).setCoefficient(2.0f).build()).setLifetime(10 + rand.m_188503_(10)).setRandomOffset((double)0.05f).setRandomMotion((double)0.05f, (double)0.05f).spawnOnStack(0.0, 0.0);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)0.03f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData(SpinParticleData.create((float)Mth.m_216267_((RandomSource)rand, (float)0.2f, (float)0.4f)).setEasing(Easing.EXPO_OUT).build()).setScaleData(GenericParticleData.create((float)(0.6f + rand.m_188501_() * 0.4f), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor).setCoefficient(1.25f).build()).setLifetime(20 + rand.m_188503_(8)).setRandomOffset((double)0.1f).setRandomMotion((double)0.4f, (double)0.4f).spawnOnStack(0.0, 0.0);
    }

    public static void spawnVoidItemScreenParticles(ScreenParticleHolder target, Level level, float intensity, float partialTick) {
        float colorMultiplier = Mth.m_216267_((RandomSource)level.f_46441_, (float)0.4f, (float)1.2f);
        float timeMultiplier = Mth.m_216267_((RandomSource)level.f_46441_, (float)0.9f, (float)1.4f);
        Color color = new Color((int)(31.0f * colorMultiplier), (int)(19.0f * colorMultiplier), (int)(31.0f * colorMultiplier));
        Color endColor = new Color((int)(111.0f * colorMultiplier), (int)(31.0f * colorMultiplier), (int)(121.0f * colorMultiplier));
        float gameTime = (float)level.m_46467_() + partialTick;
        RandomSource rand = Minecraft.m_91087_().f_91073_.m_213780_();
        SpinParticleData spinParticleData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)0.0f, (float)(level.f_46441_.m_188499_() ? 1.0f : -2.0f)).setSpinOffset(0.025f * gameTime % 6.28f).setEasing(Easing.EXPO_IN_OUT).build();
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.STAR, (ScreenParticleHolder)target).setScaleData(GenericParticleData.create((float)(1.2f * intensity + rand.m_188501_() * 0.1f * intensity), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.BOUNCE_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor).setCoefficient(2.0f).build()).setSpinData(spinParticleData).setLifetime((int)((float)(10 + rand.m_188503_(10)) * timeMultiplier)).setRandomOffset((double)0.05f).setRandomMotion((double)0.05f, (double)0.05f).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).spawnOnStack(0.0, 0.0);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setScaleData(GenericParticleData.create((float)(0.8f * intensity + rand.m_188501_() * 0.6f * intensity), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor.darker()).setCoefficient(1.25f).build()).setSpinData(spinParticleData).setLifetime(20 + rand.m_188503_(8)).setRandomOffset((double)0.1f).setRandomMotion((double)0.4f, (double)0.4f).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).spawnOnStack(0.0, 0.0).setLifetime((int)((float)(10 + rand.m_188503_(2)) * timeMultiplier)).setSpinData(SpinParticleData.create((float)Mth.m_216267_((RandomSource)rand, (float)0.05f, (float)0.1f)).build()).setScaleData(GenericParticleData.create((float)(0.8f + rand.m_188501_() * 0.4f), (float)0.0f).build()).setRandomMotion((double)0.01f, (double)0.01f).spawnOnStack(0.0, 0.0);
    }

    public static void spawnEncyclopediaEsotericaScreenParticles(ScreenParticleHolder target, Level level, float partialTick) {
        RandomSource rand = level.m_213780_();
        float distance = 7.5f;
        for (int i = 0; i < 2; ++i) {
            float time = (((float)level.m_46467_() + partialTick) * 0.05f + (float)i * 3.14f) % 6.28f;
            float scalar = 0.6f;
            if (time > 1.57f && time < 4.71f) {
                scalar *= Easing.QUAD_IN.ease(Math.abs(3.14f - time) / 1.57f, 0.0f, 1.0f, 1.0f);
            }
            double xOffset = Math.sin(time) * (double)distance;
            double yOffset = Math.cos(time) * (double)distance * 0.5;
            float colorMultiplier = Mth.m_216267_((RandomSource)level.f_46441_, (float)0.7f, (float)1.0f);
            Color color = new Color((int)(255.0f * colorMultiplier), (int)(51.0f * colorMultiplier), (int)(195.0f * colorMultiplier));
            Color endColor = new Color((int)(56.0f * colorMultiplier), (int)(32.0f * colorMultiplier), (int)(77.0f * colorMultiplier));
            float gameTime = (float)level.m_46467_() + partialTick;
            SpinParticleData spinParticleData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)(level.f_46441_.m_188499_() ? 1.0f : -2.0f)).setSpinOffset(0.025f * gameTime % 6.28f).build();
            ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setScaleData(GenericParticleData.create((float)0.0f, (float)(0.1f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.25f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor.darker()).setCoefficient(1.25f).build()).setSpinData(spinParticleData).setLifetime(60).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawnOnStack(xOffset, yOffset).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).setScaleData(GenericParticleData.create((float)(0.25f * scalar), (float)(RandomHelper.randomBetween((RandomSource)rand, (float)0.3f, (float)0.4f) * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).repeatOnStack(xOffset, yOffset, 2);
        }
    }

    public static class VoidTransmutableParticleEffect
    implements IVoidItem {
        public static VoidTransmutableParticleEffect INSTANCE = new VoidTransmutableParticleEffect();
        private boolean isNearWell;
        private boolean isItemReal;

        @Override
        public float getVoidParticleIntensity() {
            return 1.2f;
        }

        @Override
        public void spawnEarlyParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            TouchOfDarknessHandler handler = MalumLivingEntityDataCapability.getCapability((LivingEntity)player).touchOfDarknessHandler;
            this.isNearWell = handler.isNearWeepingWell;
            if (!this.isNearWell) {
                return;
            }
            if (level.m_46467_() % 20L == 0L) {
                this.isItemReal = Minecraft.m_91087_().f_91074_.m_150109_().m_36063_(stack);
            }
            if (this.isItemReal) {
                IVoidItem.super.spawnEarlyParticles(target, level, partialTick, stack, x, y);
            }
        }

        public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
            if (!this.isNearWell || !this.isItemReal) {
                return;
            }
            RandomSource rand = level.m_213780_();
            float distance = 7.5f;
            for (int i = 0; i < 2; ++i) {
                float time = ((i == 1 ? 3.14f : 0.0f) + ((float)level.m_46467_() + partialTick) * 0.1f) % 6.28f;
                float scalar = 0.6f;
                double xOffset = Math.sin(time) * (double)distance;
                double yOffset = Math.cos(time) * (double)distance;
                float colorMultiplier = Mth.m_216267_((RandomSource)level.f_46441_, (float)0.7f, (float)1.0f);
                Color color = new Color((int)(255.0f * colorMultiplier), (int)(51.0f * colorMultiplier), (int)(195.0f * colorMultiplier));
                Color endColor = new Color((int)(56.0f * colorMultiplier), (int)(32.0f * colorMultiplier), (int)(77.0f * colorMultiplier));
                float gameTime = (float)level.m_46467_() + partialTick;
                SpinParticleData spinParticleData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)(level.f_46441_.m_188499_() ? 1.0f : -2.0f)).setSpinOffset(0.025f * gameTime % 6.28f).build();
                ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setScaleData(GenericParticleData.create((float)(0.1f * scalar), (float)(RandomHelper.randomBetween((RandomSource)rand, (float)0.2f, (float)0.3f) * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.25f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor.darker()).setCoefficient(1.25f).build()).setSpinData(spinParticleData).setLifetime(40).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawnOnStack(xOffset, yOffset).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).setScaleData(GenericParticleData.create((float)(0.25f * scalar), (float)(RandomHelper.randomBetween((RandomSource)rand, (float)0.3f, (float)0.4f) * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).repeatOnStack(xOffset, yOffset, 2);
            }
        }
    }
}

