/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.spirit_crucible.ICatalyzerAccelerationTarget;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICrucibleAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_crucible.SpiritCrucibleCoreBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_crucible.catalyzer.SpiritCatalyzerCoreBlockEntity;
import com.sammy.malum.common.item.augment.AbstractAugmentItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class SpiritCrucibleParticleEffects {
    public static void passiveCrucibleParticles(SpiritCrucibleCoreBlockEntity crucible) {
        ParticleEffectSpawner lightSpecs;
        MalumSpiritType spiritType;
        MalumSpiritType activeSpiritType = crucible.getActiveSpiritType();
        if (activeSpiritType == null) {
            return;
        }
        Level level = crucible.m_58904_();
        RandomSource random = level.f_46441_;
        Vec3 itemPos = crucible.getItemPos();
        LodestoneBlockEntityInventory spiritInventory = crucible.spiritInventory;
        LodestoneBlockEntityInventory augmentInventory = crucible.augmentInventory;
        SpiritFocusingRecipe recipe = crucible.recipe;
        if (recipe != null) {
            for (ICrucibleAccelerator accelerator : crucible.acceleratorData.accelerators) {
                if (accelerator == null) continue;
                accelerator.addParticles(crucible, activeSpiritType);
            }
        }
        if (recipe != null) {
            ParticleEffectSpawner lightSpecs2 = SpiritLightSpecs.spiritLightSpecs(level, itemPos, activeSpiritType, new WorldParticleOptions((ParticleType)ParticleRegistry.STAR.get()));
            lightSpecs2.getBuilder().setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset((float)level.m_46467_() * 0.05f % 6.28f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.25f));
            lightSpecs2.getBloomBuilder().modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.5f));
            lightSpecs2.spawnParticles();
        }
        int spiritsRendered = 0;
        for (int i = 0; i < spiritInventory.slotCount; ++i) {
            ItemStack item = spiritInventory.getStackInSlot(i);
            Item item2 = item.m_41720_();
            if (!(item2 instanceof SpiritShardItem)) continue;
            SpiritShardItem spiritSplinterItem = (SpiritShardItem)item2;
            Vec3 offset = crucible.getSpiritItemOffset(spiritsRendered++, 0.0f);
            spiritType = spiritSplinterItem.type;
            BlockPos blockPos = crucible.m_58899_();
            Vec3 spiritPosition = new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
            if (recipe == null) continue;
            Vec3 velocity = itemPos.m_82546_(spiritPosition).m_82541_().m_82490_((double)RandomHelper.randomBetween((RandomSource)random, (float)0.03f, (float)0.06f));
            if (random.m_188501_() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, spiritPosition, spiritType);
                sparkParticles.getBuilder().setMotion(velocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                sparkParticles.getBloomBuilder().setMotion(velocity);
                sparkParticles.spawnParticles();
            }
            if (!(random.m_188501_() < 0.85f)) continue;
            lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, spiritType);
            lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(velocity.m_82490_(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.6f));
            lightSpecs.getBloomBuilder().setMotion(velocity);
            lightSpecs.spawnParticles();
        }
        if (level.m_46467_() % 4L == 0L) {
            int augmentsRendered = 0;
            for (int i = 0; i < augmentInventory.slotCount; ++i) {
                ItemStack item = augmentInventory.getStackInSlot(i);
                spiritType = item.m_41720_();
                if (!(spiritType instanceof AbstractAugmentItem)) continue;
                AbstractAugmentItem augmentItem = (AbstractAugmentItem)((Object)spiritType);
                Vec3 offset = crucible.getAugmentItemOffset(augmentsRendered++, 0.0f);
                MalumSpiritType spiritType2 = augmentItem.spiritType;
                BlockPos blockPos = crucible.m_58899_();
                Vec3 particlePosition = new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
                if (recipe != null) {
                    Vec3 velocity = itemPos.m_82546_(particlePosition).m_82541_().m_82490_((double)RandomHelper.randomBetween((RandomSource)random, (float)0.01f, (float)0.02f));
                    if (random.m_188501_() < 0.15f) {
                        ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, particlePosition, spiritType2);
                        sparkParticles.getBuilder().multiplyLifetime(2.5f).setMotion(velocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                        sparkParticles.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity);
                        sparkParticles.spawnParticles();
                    }
                    if (random.m_188501_() < 0.15f) {
                        ParticleEffectSpawner lightSpecs3 = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, spiritType2);
                        lightSpecs3.getBuilder().multiplyLifetime(2.5f).setMotion(velocity.m_82490_(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.6f));
                        lightSpecs3.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity);
                        lightSpecs3.spawnParticles();
                    }
                }
                lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, spiritType2);
                lightSpecs.getBuilder().multiplyLifetime(2.5f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.3f));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f);
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void activeSpiritCatalyzerParticles(SpiritCatalyzerCoreBlockEntity catalyzer, ICatalyzerAccelerationTarget target, MalumSpiritType spiritType) {
        ItemStack item;
        Item spinData;
        Vec3 velocity;
        Level level = catalyzer.m_58904_();
        BlockPos catalyzerPos = catalyzer.m_58899_();
        Vec3 startPos = catalyzer.getItemOffset().m_82520_((double)catalyzerPos.m_123341_(), (double)catalyzerPos.m_123342_(), (double)catalyzerPos.m_123343_());
        RandomSource random = level.f_46441_;
        Vec3 targetPos = target.getAccelerationPoint();
        if (level.m_46467_() % 2L == 0L) {
            velocity = targetPos.m_82546_(startPos).m_82541_().m_82490_((double)RandomHelper.randomBetween((RandomSource)random, (float)0.06f, (float)0.12f));
            Vec3 sparkPos = startPos.m_82520_((double)(0.05f - random.m_188501_() * 0.1f), (double)(0.05f - random.m_188501_() * 0.1f), (double)(0.05f - random.m_188501_() * 0.1f));
            ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, sparkPos, spiritType);
            sparkParticles.getBuilder().setMotion(velocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f)).modifyOptionalData(b -> b.getBehaviorData(SparkBehaviorComponent.class, SparkBehaviorComponent::getLengthData), d -> d.multiplyValue(2.0f).multiplyCoefficient(0.75f)).modifyColorData(c -> c.multiplyCoefficient(0.8f));
            sparkParticles.getBloomBuilder().setMotion(velocity);
            sparkParticles.spawnParticlesRaw();
        }
        if (level.m_46467_() % 10L == 0L) {
            velocity = targetPos.m_82546_(startPos).m_82541_().m_82490_((double)0.02f * targetPos.m_82554_(startPos));
            Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)0.98f));
            spinData = SpinParticleData.createRandomDirection((RandomSource)random, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.1f, (float)0.2f)).randomSpinOffset(random).build();
            WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)ParticleRegistry.HEXAGON.get()), (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(velocity.m_82541_())).setTransparencyData(GenericParticleData.create((float)0.6f, (float)0.4f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData((SpinParticleData)spinData).setScaleData(GenericParticleData.create((float)0.15f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(spiritType.createColorData().build()).setLifetime(60).setMotion(velocity).enableNoClip().setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.RANDOM_SPRITE).addTickActor(behavior).spawn(level, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_);
        }
        if (level.m_46467_() % 4L == 0L && (spinData = (item = catalyzer.augmentInventory.getStackInSlot(0)).m_41720_()) instanceof AbstractAugmentItem) {
            AbstractAugmentItem augmentItem = (AbstractAugmentItem)spinData;
            Vec3 offset = catalyzer.getAugmentOffset();
            MalumSpiritType augmentSpiritType = augmentItem.spiritType;
            BlockPos blockPos = catalyzer.m_58899_();
            Vec3 particlePosition = new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
            Vec3 velocity2 = targetPos.m_82546_(particlePosition).m_82541_().m_82490_((double)RandomHelper.randomBetween((RandomSource)random, (float)0.03f, (float)0.06f));
            if (random.m_188501_() < 0.15f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, particlePosition, augmentSpiritType);
                sparkParticles.getBuilder().multiplyLifetime(2.5f).setMotion(velocity2).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                sparkParticles.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity2);
                sparkParticles.spawnParticles();
            }
            if (random.m_188501_() < 0.15f) {
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, augmentSpiritType);
                lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion(velocity2.m_82490_(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.6f));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity2);
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void craftItemParticles(SpiritCrucibleCoreBlockEntity crucible, ColorEffectData colorData) {
        int i;
        MalumSpiritType activeSpiritType = crucible.getActiveSpiritType();
        if (activeSpiritType == null) {
            return;
        }
        Level level = crucible.m_58904_();
        RandomSource random = level.f_46441_;
        BlockPos altarPos = crucible.m_58899_();
        Vec3 targetPos = crucible.getCentralItemOffset().m_82520_((double)altarPos.m_123341_(), (double)altarPos.m_123342_(), (double)altarPos.m_123343_());
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, targetPos, activeSpiritType);
        }
        for (i = 0; i < 24; ++i) {
            int lifeDelay = i / 8;
            MalumSpiritType cyclingSpiritType = colorData.getCyclingColorRecord().spiritType();
            float xVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float yVelocity = RandomHelper.randomBetween((RandomSource)random, (float)0.2f, (float)0.5f);
            float zVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float gravityStrength = RandomHelper.randomBetween((RandomSource)random, (float)0.75f, (float)1.0f);
            if (random.m_188501_() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, targetPos, cyclingSpiritType);
                sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f));
                sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(random.m_188501_() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, targetPos, cyclingSpiritType);
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 8; ++i) {
            MalumSpiritType cyclingSpiritType = colorData.getCyclingColorRecord().spiritType();
            float xVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.025f, (float)0.025f);
            float yVelocity = RandomHelper.randomBetween((RandomSource)random, (float)0.015f, (float)0.035f);
            float zVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.025f, (float)0.025f);
            if (!(random.m_188501_() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, targetPos.m_82492_(0.0, 0.5, 0.0), cyclingSpiritType, new WorldParticleOptions((ParticleType)ParticleRegistry.STRANGE_SMOKE.get()));
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(i).multiplyLifetime(5.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).modifyColorData(c -> c.multiplyCoefficient(0.5f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.1f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(i).multiplyLifetime(5.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).modifyColorData(c -> c.multiplyCoefficient(0.5f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.25f));
            lightSpecs.spawnParticles();
        }
    }

    public static void passiveSpiritCatalyzerParticles(SpiritCatalyzerCoreBlockEntity catalyzer) {
        ItemStack item;
        Item item2;
        Level level = catalyzer.m_58904_();
        RandomSource random = level.f_46441_;
        if (level.m_46467_() % 16L == 0L && (item2 = (item = catalyzer.augmentInventory.getStackInSlot(0)).m_41720_()) instanceof AbstractAugmentItem) {
            AbstractAugmentItem augmentItem = (AbstractAugmentItem)item2;
            Vec3 offset = catalyzer.getAugmentOffset().m_82520_((double)Mth.m_216267_((RandomSource)random, (float)-0.1f, (float)0.1f), (double)Mth.m_216267_((RandomSource)random, (float)-0.1f, (float)0.1f), (double)Mth.m_216267_((RandomSource)random, (float)-0.1f, (float)0.1f));
            MalumSpiritType augmentSpiritType = augmentItem.spiritType;
            BlockPos blockPos = catalyzer.m_58899_();
            Vec3 particlePosition = new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, augmentSpiritType);
            lightSpecs.getBuilder().multiplyLifetime(2.5f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.3f));
            lightSpecs.getBloomBuilder().multiplyLifetime(1.5f);
            lightSpecs.spawnParticles();
        }
    }
}

