/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.widget.container;

import java.util.Iterator;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.navigation.NavigationDirection;
import org.thinkingstudio.obsidianui.navigation.NavigationUtils;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceWidget;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceParentWidget;

public abstract class AbstractSpruceParentWidget<E extends SpruceWidget>
extends AbstractSpruceWidget
implements SpruceParentWidget<E> {
    private final Class<E> childClass;
    @Nullable
    private E focused;

    public AbstractSpruceParentWidget(Position position, Class<E> childClass) {
        super(position);
        this.childClass = childClass;
    }

    @Override
    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
        if (!focused) {
            this.setFocused(null);
        }
    }

    @Override
    @Nullable
    public E getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(@Nullable E focused) {
        if (this.focused == focused) {
            return;
        }
        if (this.focused != null) {
            this.focused.m_93692_(false);
        }
        if (focused == null) {
            this.focused = null;
        } else if (this.childClass.isInstance(focused)) {
            this.focused = focused;
            this.focused.m_93692_(true);
        }
    }

    protected void setOwnerShip(E child) {
        child.getPosition().setAnchor(this);
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (this.requiresCursor()) {
            return false;
        }
        boolean result = NavigationUtils.tryNavigate(direction, tab, this.children(), this.focused, this::setFocused, false);
        if (result) {
            this.m_93692_(true);
        }
        return result;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        SpruceWidget element;
        Iterator it = this.iterator();
        do {
            if (it.hasNext()) continue;
            return false;
        } while (!(element = (SpruceWidget)it.next()).m_6375_(mouseX, mouseY, button));
        this.setFocused(element);
        if (button == 0) {
            this.setDragging(true);
        }
        return true;
    }

    @Override
    protected boolean onMouseRelease(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        return this.hoveredElement(mouseX, mouseY).filter(element -> element.m_6348_(mouseX, mouseY, button)).isPresent();
    }

    @Override
    protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    protected boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        return this.hoveredElement(mouseX, mouseY).filter(element -> element.m_6050_(mouseX, mouseY, amount)).isPresent();
    }

    @Override
    protected boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        return this.getFocused() != null && this.getFocused().m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean onKeyRelease(int keyCode, int scanCode, int modifiers) {
        return this.getFocused() != null && this.getFocused().m_7920_(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean onCharTyped(char chr, int keyCode) {
        return this.getFocused() != null && this.getFocused().m_5534_(chr, keyCode);
    }
}

