/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.fullbody;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.api.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.NMSWrapper;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import dev.tr7zw.notenoughanimations.versionless.animations.DataHolder;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class FallingAnimation
extends BasicAnimation
implements DataHolder<FallingData> {
    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.fallingAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayer entity, PlayerData data) {
        if (!(entity.m_21255_() || NMSWrapper.onGround((Entity)entity) || entity.m_6147_() || entity.m_150110_().f_35935_ || entity.m_6069_())) {
            FallingData fallData = data.getData(this, () -> new FallingData(entity.m_20186_()));
            if (entity instanceof LocalPlayer) {
                fallData.fallingSpeed = (float)(entity.m_20184_().m_82556_() / 11.0);
                return entity.f_19789_ > 3.0f;
            }
            if (entity.m_20186_() == fallData.lastY) {
                return fallData.fallingSpeed > 0.14285715f;
            }
            fallData.fallingSpeed = (float)(fallData.lastY - entity.m_20186_()) / 3.5f;
            fallData.lastY = entity.m_20186_();
            return fallData.fallingSpeed > 0.14285715f;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayer entity, PlayerData data) {
        return BodyPart.values();
    }

    @Override
    public int getPriority(AbstractClientPlayer entity, PlayerData data) {
        return 400;
    }

    @Override
    public void apply(AbstractClientPlayer entity, PlayerData data, PlayerModel model, BodyPart part, float delta, float tickCounter) {
        FallingData fallData = data.getData(this, () -> new FallingData(entity.m_20186_()));
        float moveSqrt = fallData.fallingSpeed;
        float armsMove = Math.min(1.0f, moveSqrt * 2.0f);
        moveSqrt = Math.min(1.0f, moveSqrt);
        float moveOutArms = 1.9f * armsMove;
        float moveOutLegs = 0.6f * moveSqrt;
        float movement = (float)entity.f_19797_ + delta;
        if (part == BodyPart.LEFT_ARM) {
            model.f_102812_.f_104203_ = Mth.m_14089_((float)(movement * 0.6662f)) * moveSqrt;
            model.f_102812_.f_104205_ = -moveOutArms;
        }
        if (part == BodyPart.RIGHT_ARM) {
            model.f_102811_.f_104203_ = Mth.m_14089_((float)(movement * 0.6662f + (float)Math.PI)) * moveSqrt;
            model.f_102811_.f_104205_ = moveOutArms;
        }
        if (part == BodyPart.LEFT_LEG) {
            model.f_102814_.f_104203_ = Mth.m_14089_((float)(movement * 0.6662f + (float)Math.PI)) * 1.4f * moveSqrt;
            model.f_102814_.f_104205_ = -moveOutLegs;
        }
        if (part == BodyPart.RIGHT_LEG) {
            model.f_102813_.f_104203_ = Mth.m_14089_((float)(movement * 0.6662f)) * 1.4f * moveSqrt;
            model.f_102813_.f_104205_ = moveOutLegs;
        }
    }

    public static class FallingData {
        public double lastY = 0.0;
        public float fallingSpeed = 0.0f;

        public FallingData(double y) {
            this.lastY = y;
        }
    }
}

