/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class MineralMixSerializer
extends IERecipeSerializer<MineralMix> {
    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.CRUSHER.iconStack();
    }

    @Override
    public MineralMix readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        JsonArray array = json.getAsJsonArray("ores");
        ArrayList<StackWithChance> temp = new ArrayList<StackWithChance>();
        float totalChance = 0.0f;
        for (int i = 0; i < array.size(); ++i) {
            JsonObject element = array.get(i).getAsJsonObject();
            if (!CraftingHelper.processConditions((JsonObject)element, (String)"conditions", (ICondition.IContext)context)) continue;
            Lazy<ItemStack> stack2 = MineralMixSerializer.readOutput(element.get("output"));
            float chance = GsonHelper.m_13915_((JsonObject)element, (String)"chance");
            totalChance += chance;
            temp.add(new StackWithChance(stack2, chance));
        }
        float finalTotalChance = totalChance;
        StackWithChance[] ores = (StackWithChance[])temp.stream().map(stack -> stack.recalculate(finalTotalChance)).toArray(StackWithChance[]::new);
        array = json.getAsJsonArray("spoils");
        temp.clear();
        float totalSpoilChance = 0.0f;
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                JsonObject element = array.get(i).getAsJsonObject();
                if (!CraftingHelper.processConditions((JsonObject)element, (String)"conditions", (ICondition.IContext)context)) continue;
                Lazy<ItemStack> stack3 = MineralMixSerializer.readOutput(element.get("output"));
                float chance = GsonHelper.m_13915_((JsonObject)element, (String)"chance");
                totalSpoilChance += chance;
                temp.add(new StackWithChance(stack3, chance));
            }
        }
        float finalTotalSpoilChance = totalSpoilChance;
        StackWithChance[] spoils = (StackWithChance[])temp.stream().map(stack -> stack.recalculate(finalTotalSpoilChance)).toArray(StackWithChance[]::new);
        int weight = GsonHelper.m_13927_((JsonObject)json, (String)"weight");
        float failChance = GsonHelper.m_13820_((JsonObject)json, (String)"fail_chance", (float)0.0f);
        array = json.getAsJsonArray("dimensions");
        ArrayList<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
        for (int i = 0; i < array.size(); ++i) {
            dimensions.add(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(array.get(i).getAsString())));
        }
        ResourceLocation rl = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"sample_background", (String)"minecraft:stone"));
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(rl);
        if (b == Blocks.f_50016_) {
            b = Blocks.f_50069_;
        }
        return new MineralMix(recipeId, ores, spoils, weight, failChance, dimensions, b);
    }

    @Nullable
    public MineralMix fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        StackWithChance[] outputs = new StackWithChance[count];
        for (int i = 0; i < count; ++i) {
            outputs[i] = StackWithChance.read(buffer);
        }
        count = buffer.readInt();
        StackWithChance[] spoils = new StackWithChance[count];
        for (int i = 0; i < count; ++i) {
            spoils[i] = StackWithChance.read(buffer);
        }
        int weight = buffer.readInt();
        float failChance = buffer.readFloat();
        count = buffer.readInt();
        ArrayList<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
        for (int i = 0; i < count; ++i) {
            dimensions.add(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_()));
        }
        Block bg = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        return new MineralMix(recipeId, outputs, spoils, weight, failChance, dimensions, bg);
    }

    public void toNetwork(FriendlyByteBuf buffer, MineralMix recipe) {
        buffer.writeInt(recipe.outputs.length);
        for (StackWithChance secondaryOutput : recipe.outputs) {
            secondaryOutput.write(buffer);
        }
        buffer.writeInt(recipe.spoils.length);
        for (StackWithChance spoils : recipe.spoils) {
            spoils.write(buffer);
        }
        buffer.writeInt(recipe.weight);
        buffer.writeFloat(recipe.failChance);
        buffer.writeInt(recipe.dimensions.size());
        for (ResourceKey dimension : recipe.dimensions) {
            buffer.m_130085_(dimension.m_135782_());
        }
        buffer.m_130085_(ForgeRegistries.BLOCKS.getKey((Object)recipe.background));
    }
}

