/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.particle.phantom;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PhantomGunnerParticle
extends TextureSheetParticle {
    private static final Vector3f ROTATION_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
    private static final Vector3f TRANSFORM_VECTOR = new Vector3f(-1.0f, -1.0f, 0.0f);
    private static final float MAGICAL_X_ROT = 1.0472f;
    private int layerY = 125;

    protected PhantomGunnerParticle(ClientLevel level, double x, double y, double z, double pXSpeed, double pYSpeed, double pZSpeed) {
        super(level, x, y, z);
        this.f_172258_ = 1.0f;
        this.m_172260_(pXSpeed, 0.0, pZSpeed);
        this.f_107215_ = pXSpeed;
        this.f_107216_ = 0.0;
        this.f_107217_ = pZSpeed;
        this.f_107230_ = 1.0f;
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        this.renderRotatedParticle(pBuffer, pRenderInfo, pPartialTicks, quaternionf -> quaternionf.mul((Quaternionfc)new Quaternionf().rotationX(1.5707964f)));
    }

    private void renderRotatedParticle(VertexConsumer pConsumer, Camera pCamera, float pPartialTick, Consumer<Quaternionf> pQuaternion) {
        Vec3 vec3 = pCamera.m_90583_();
        float f = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = this.layerY;
        float f2 = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        float motionX = (float)this.f_107215_;
        float motionZ = (float)this.f_107217_;
        float yaw = (float)Math.atan2(motionZ, motionX);
        Quaternionf quaternionf = new Quaternionf().rotationY(-yaw);
        pQuaternion.accept(quaternionf);
        quaternionf.transform(TRANSFORM_VECTOR);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-100.0f, -100.0f, 100.0f), new Vector3f(-100.0f, 100.0f, 100.0f), new Vector3f(100.0f, 100.0f, 100.0f), new Vector3f(100.0f, -100.0f, 100.0f)};
        float f3 = this.m_5902_(pPartialTick);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f3);
            vector3f.add(f, f1, f2);
        }
        int j = this.m_6355_(pPartialTick);
        this.makeCornerVertex(pConsumer, avector3f[0], this.m_5952_(), this.m_5950_(), j);
        this.makeCornerVertex(pConsumer, avector3f[1], this.m_5952_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[2], this.m_5970_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[3], this.m_5970_(), this.m_5950_(), j);
        this.makeCornerVertex(pConsumer, avector3f[0], this.m_5952_(), this.m_5950_(), j);
        this.makeCornerVertex(pConsumer, avector3f[3], this.m_5970_(), this.m_5950_(), j);
        this.makeCornerVertex(pConsumer, avector3f[2], this.m_5970_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[1], this.m_5952_(), this.m_5951_(), j);
    }

    private void makeCornerVertex(VertexConsumer pConsumer, Vector3f pVertex, float pU, float pV, int pPackedLight) {
        pConsumer.m_5483_((double)pVertex.x(), (double)pVertex.y(), (double)pVertex.z()).m_7421_(pU, pV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(pPackedLight).m_5752_();
    }

    protected int m_6355_(float pPartialTick) {
        BlockPos blockpos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        return this.f_107208_.m_46805_(blockpos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)blockpos) : 0;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SecondLayerSwarmProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public SecondLayerSwarmProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            PhantomGunnerParticle phantomGunnerParticle = new PhantomGunnerParticle(pLevel, pX, pY, pZ, 0.0, 0.0, 1.0);
            phantomGunnerParticle.m_108335_(this.sprite);
            phantomGunnerParticle.m_107257_(300);
            phantomGunnerParticle.layerY = 150;
            return phantomGunnerParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SwarmProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public SwarmProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            PhantomGunnerParticle phantomGunnerParticle = new PhantomGunnerParticle(pLevel, pX, pY, pZ, 0.0, 0.0, 1.0);
            phantomGunnerParticle.m_108335_(this.sprite);
            phantomGunnerParticle.m_107257_(300);
            return phantomGunnerParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            PhantomGunnerParticle phantomGunnerParticle = new PhantomGunnerParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            phantomGunnerParticle.m_108335_(this.sprite);
            phantomGunnerParticle.m_107257_(200);
            return phantomGunnerParticle;
        }
    }
}

