/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.render.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ttv.migami.jeg.client.render.IHeldAnimation;
import ttv.migami.jeg.client.render.pose.AimPose;
import ttv.migami.jeg.client.render.pose.LimbPose;

public abstract class WeaponPose
implements IHeldAnimation {
    private final AimPose upPose = this.getUpPose();
    private final AimPose forwardPose = this.getForwardPose();
    private final AimPose downPose = this.getDownPose();

    protected abstract AimPose getUpPose();

    protected abstract AimPose getForwardPose();

    protected abstract AimPose getDownPose();

    protected boolean hasAimPose() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerModelRotation(Player player, ModelPart rightArm, ModelPart leftArm, ModelPart head, InteractionHand hand, float aimProgress) {
        Minecraft mc = Minecraft.m_91087_();
        boolean right = mc.f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
        ModelPart mainArm = right ? rightArm : leftArm;
        ModelPart secondaryArm = right ? leftArm : rightArm;
        float angle = this.getPlayerPitch(player);
        float angleAbs = Math.abs(angle);
        float zoom = this.hasAimPose() ? aimProgress : 0.0f;
        AimPose targetPose = (double)angle > 0.0 ? this.downPose : this.upPose;
        this.applyAimPose(targetPose, mainArm, secondaryArm, angleAbs, zoom, right ? 1.0f : -1.0f, player.m_6047_());
    }

    protected float getPlayerPitch(Player player) {
        if (Minecraft.m_91087_().m_91288_() == player && Minecraft.m_91087_().f_91080_ != null) {
            return 0.0f;
        }
        return Mth.m_14179_((float)Minecraft.m_91087_().m_91296_(), (float)player.f_19860_, (float)player.m_146909_()) / 90.0f;
    }

    private void applyAimPose(AimPose targetPose, ModelPart rightArm, ModelPart leftArm, float partial, float zoom, float offhand, boolean sneaking) {
        this.applyLimbPoseToModelRenderer(targetPose.getIdle().getRightArm(), targetPose.getAiming().getRightArm(), this.forwardPose.getIdle().getRightArm(), this.forwardPose.getAiming().getRightArm(), rightArm, partial, zoom, offhand, sneaking);
        this.applyLimbPoseToModelRenderer(targetPose.getIdle().getLeftArm(), targetPose.getAiming().getLeftArm(), this.forwardPose.getIdle().getLeftArm(), this.forwardPose.getAiming().getLeftArm(), leftArm, partial, zoom, offhand, sneaking);
    }

    private void applyLimbPoseToModelRenderer(LimbPose targetIdlePose, LimbPose targetAimingPose, LimbPose idlePose, LimbPose aimingPose, ModelPart renderer, float partial, float zoom, float leftHanded, boolean sneaking) {
        renderer.f_104203_ = (float)Math.toRadians(this.getValue(targetIdlePose.getRotationAngleX(), targetAimingPose.getRotationAngleX(), idlePose.getRotationAngleX(), aimingPose.getRotationAngleX(), Float.valueOf(renderer.f_104203_), partial, zoom, 1.0f));
        renderer.f_104204_ = (float)Math.toRadians(this.getValue(targetIdlePose.getRotationAngleY(), targetAimingPose.getRotationAngleY(), idlePose.getRotationAngleY(), aimingPose.getRotationAngleY(), Float.valueOf(renderer.f_104204_), partial, zoom, leftHanded));
        renderer.f_104205_ = (float)Math.toRadians(this.getValue(targetIdlePose.getRotationAngleZ(), targetAimingPose.getRotationAngleZ(), idlePose.getRotationAngleZ(), aimingPose.getRotationAngleZ(), Float.valueOf(renderer.f_104205_), partial, zoom, leftHanded));
        renderer.f_104200_ = this.getValue(targetIdlePose.getRotationPointX(), targetAimingPose.getRotationPointX(), idlePose.getRotationPointX(), aimingPose.getRotationPointX(), Float.valueOf(renderer.f_104200_), partial, zoom, leftHanded);
        renderer.f_104201_ = this.getValue(targetIdlePose.getRotationPointY(), targetAimingPose.getRotationPointY(), idlePose.getRotationPointY(), aimingPose.getRotationPointY(), Float.valueOf(renderer.f_104201_), partial, zoom, 1.0f) + (sneaking ? 2.0f : 0.0f);
        renderer.f_104202_ = this.getValue(targetIdlePose.getRotationPointZ(), targetAimingPose.getRotationPointZ(), idlePose.getRotationPointZ(), aimingPose.getRotationPointZ(), Float.valueOf(renderer.f_104202_), partial, zoom, 1.0f);
    }

    private float getValue(@Nullable Float t1, @Nullable Float t2, Float s1, Float s2, Float def, float partial, float zoom, float leftHanded) {
        float start;
        float f = t1 != null && s1 != null ? (s1.floatValue() + (t1.floatValue() - s1.floatValue()) * partial) * leftHanded : (start = s1 != null ? s1.floatValue() * leftHanded : def.floatValue());
        float end = t2 != null && s2 != null ? (s2.floatValue() + (t2.floatValue() - s2.floatValue()) * partial) * leftHanded : (s2 != null ? s2.floatValue() * leftHanded : def.floatValue());
        return Mth.m_14179_((float)zoom, (float)start, (float)end);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerPreRender(Player player, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
        float angle = this.getPlayerPitch(player);
        float angleAbs = Math.abs(angle);
        float zoom = this.hasAimPose() ? aimProgress : 0.0f;
        AimPose targetPose = (double)angle > 0.0 ? this.downPose : this.upPose;
        float rightOffset = this.getValue(Float.valueOf(targetPose.getIdle().getRenderYawOffset()), Float.valueOf(targetPose.getAiming().getRenderYawOffset()), Float.valueOf(this.forwardPose.getIdle().getRenderYawOffset()), Float.valueOf(this.forwardPose.getAiming().getRenderYawOffset()), Float.valueOf(0.0f), angleAbs, zoom, right ? 1.0f : -1.0f);
        player.f_20884_ = player.f_19859_ + rightOffset;
        player.f_20883_ = player.m_146908_() + rightOffset;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHeldItemTransforms(Player player, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        if (hand == InteractionHand.MAIN_HAND) {
            boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT;
            float leftHanded = right ? 1.0f : -1.0f;
            poseStack.m_85837_(0.0, 0.0, 0.05);
            float angle = this.getPlayerPitch(player);
            float angleAbs = Math.abs(angle);
            float zoom = this.hasAimPose() ? aimProgress : 0.0f;
            AimPose targetPose = (double)angle > 0.0 ? this.downPose : this.upPose;
            float translateX = this.getValue(Float.valueOf(targetPose.getIdle().getItemTranslate().x()), Float.valueOf(targetPose.getAiming().getItemTranslate().x()), Float.valueOf(this.forwardPose.getIdle().getItemTranslate().x()), Float.valueOf(this.forwardPose.getAiming().getItemTranslate().x()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            float translateY = this.getValue(Float.valueOf(targetPose.getIdle().getItemTranslate().y()), Float.valueOf(targetPose.getAiming().getItemTranslate().y()), Float.valueOf(this.forwardPose.getIdle().getItemTranslate().y()), Float.valueOf(this.forwardPose.getAiming().getItemTranslate().y()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            float translateZ = this.getValue(Float.valueOf(targetPose.getIdle().getItemTranslate().z()), Float.valueOf(targetPose.getAiming().getItemTranslate().z()), Float.valueOf(this.forwardPose.getIdle().getItemTranslate().z()), Float.valueOf(this.forwardPose.getAiming().getItemTranslate().z()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            poseStack.m_85837_((double)translateX * 0.0625 * (double)leftHanded, (double)translateY * 0.0625, (double)translateZ * 0.0625);
            float rotateX = this.getValue(Float.valueOf(targetPose.getIdle().getItemRotation().x()), Float.valueOf(targetPose.getAiming().getItemRotation().x()), Float.valueOf(this.forwardPose.getIdle().getItemRotation().x()), Float.valueOf(this.forwardPose.getAiming().getItemRotation().x()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            float rotateY = this.getValue(Float.valueOf(targetPose.getIdle().getItemRotation().y()), Float.valueOf(targetPose.getAiming().getItemRotation().y()), Float.valueOf(this.forwardPose.getIdle().getItemRotation().y()), Float.valueOf(this.forwardPose.getAiming().getItemRotation().y()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            float rotateZ = this.getValue(Float.valueOf(targetPose.getIdle().getItemRotation().z()), Float.valueOf(targetPose.getAiming().getItemRotation().z()), Float.valueOf(this.forwardPose.getIdle().getItemRotation().z()), Float.valueOf(this.forwardPose.getAiming().getItemRotation().z()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rotateX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotateY * leftHanded));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotateZ * leftHanded));
        }
    }
}

