/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.monster.phantom.gunner;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.handler.SoundHandler;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.ai.EntityHurtByTargetGoal;
import ttv.migami.jeg.entity.ai.owned.NearestAttackableTargetGoal;
import ttv.migami.jeg.entity.ai.owned.PlayerHurtTargetGoal;
import ttv.migami.jeg.entity.ai.phantom.PhantomGunnerGunAttackGoal;
import ttv.migami.jeg.entity.monster.phantom.gunner.PhantomGunnerAnimations;
import ttv.migami.jeg.entity.monster.phantom.terror.TerrorPhantom;
import ttv.migami.jeg.entity.throwable.GrenadeEntity;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;

public class PhantomGunner
extends Phantom
implements GeoEntity {
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int attackTimer = 0;
    Vec3 f_33097_ = Vec3.f_82478_;
    BlockPos f_33098_ = BlockPos.f_121853_;
    AttackPhase f_33096_ = AttackPhase.CIRCLE;
    private boolean isDying = false;
    private int deathTimer = 0;
    private static final int DEATH_ANIMATION_DURATION = 100;
    private double forwardSpeed = 0.1;
    private Player player;
    public boolean playerOwned = false;
    private int despawnTimer;
    private boolean makeSound = true;
    private static final EntityDataAccessor<Boolean> IS_DYING = SynchedEntityData.m_135353_(PhantomGunner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_OWNED = SynchedEntityData.m_135353_(PhantomGunner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public PhantomGunner(EntityType<? extends Phantom> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ModItems.LIGHT_MACHINE_GUN.get()));
        this.f_21342_ = new PhantomMoveControl((Mob)this);
        this.despawnTimer = 1200;
    }

    public void setPlayer(Player player) {
        if (player != null) {
            this.player = player;
            this.playerOwned = true;
            this.setPlayerOwned(true);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PhantomGunnerAttackStrategyGoal());
        this.f_21345_.m_25352_(2, new PhantomGunnerGunAttackGoal(this, 100.0, 5));
        this.f_21345_.m_25352_(2, (Goal)new PhantomGunnerSweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new PhantomGunnerCircleAroundAnchorGoal());
        this.f_21346_.m_25352_(1, (Goal)new PhantomGunnerAttackPlayerTargetGoal());
        this.f_21346_.m_25352_(1, (Goal)new EntityHurtByTargetGoal((Mob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new PlayerHurtTargetGoal((Mob)this));
        this.f_21346_.m_25352_(7, new NearestAttackableTargetGoal<Mob>((Mob)this, Mob.class, 5, true, true, livingEntity -> livingEntity instanceof Enemy && !(livingEntity instanceof Creeper) && !(livingEntity instanceof PhantomGunner) && !(livingEntity instanceof TerrorPhantom) && !(livingEntity instanceof EnderMan)));
    }

    private void explode() {
        GrenadeEntity.createExplosion((Entity)this, ((Double)Config.COMMON.grenades.explosionRadius.get()).floatValue(), true);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.BIG_EXPLOSION.get(), true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.m_9236_().f_46443_) {
            double posX = this.m_20185_() - this.m_20184_().m_7096_();
            double posY = this.m_20186_() - this.m_20184_().m_7098_();
            double posZ = this.m_20189_() - this.m_20184_().m_7094_();
            for (int i = 0; i < 10; ++i) {
                double xSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                double ySpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                double zSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.SMOKE.get(), true, posX, posY + 2.0, posZ, xSpeed, ySpeed, zSpeed);
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FIRE.get(), true, posX, posY + 2.0, posZ, xSpeed, ySpeed, zSpeed);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.makeSound) {
                SoundHandler.playPhantomGunnerFlySound(this);
                this.makeSound = false;
            }
            if (this.isDying()) {
                SoundHandler.playPhantomGunnerDiveSound(this);
            }
        }
        if (this.isPlayerOwned() && this.m_5448_() != null && this.m_5448_().m_19880_().contains("PlayerOwned")) {
            this.m_6710_(null);
        }
        if (this.isPlayerOwned() && !this.m_9236_().f_46443_) {
            --this.despawnTimer;
            if (this.despawnTimer <= 0) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (this.player != null) {
                this.f_33098_ = BlockPos.m_274446_((Position)this.player.m_20182_());
            } else if (this.f_19797_ >= 60) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.isDying()) {
            ++this.deathTimer;
            this.forwardSpeed = Math.min(this.forwardSpeed + 0.05, 2.0);
            Vec3 forwardMotion = Vec3.m_82498_((float)this.m_146909_(), (float)this.m_146908_()).m_82490_(this.forwardSpeed);
            this.m_20334_(forwardMotion.f_82479_, -1.0, forwardMotion.f_82481_);
            this.m_146926_(this.m_146909_() + 2.0f);
            if (this.deathTimer >= 100 || this.f_19862_ || this.f_19863_) {
                this.explode();
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        if (this.m_33172_() != 4) {
            this.m_33108_(4);
        }
        if (!this.isDying()) {
            if (this.f_33096_.equals((Object)AttackPhase.SWOOP)) {
                this.f_19862_ = false;
            }
            this.f_19794_ = this.player != null || this.m_5448_() != null || this.f_19862_;
        } else {
            this.f_19794_ = false;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            --this.attackTimer;
            if (this.attackTimer <= 0) {
                this.f_33096_ = AttackPhase.CIRCLE;
            }
        }
        if (this.m_21223_() <= 0.0f) {
            this.isDying = true;
            this.setDying(true);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.isDying) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public boolean m_21224_() {
        return this.isDying && this.deathTimer >= 100;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public AttackPhase getAttackPhase() {
        return this.f_33096_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{PhantomGunnerAnimations.genericIdleController(this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_21532_() {
        return this.playerOwned;
    }

    public boolean isDying() {
        return (Boolean)this.f_19804_.m_135370_(IS_DYING);
    }

    public void setDying(boolean dying) {
        this.f_19804_.m_135381_(IS_DYING, (Object)dying);
    }

    public boolean isPlayerOwned() {
        return (Boolean)this.f_19804_.m_135370_(IS_OWNED);
    }

    public void setPlayerOwned(boolean isPlayerOwned) {
        this.f_19804_.m_135381_(IS_OWNED, (Object)isPlayerOwned);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_DYING, (Object)false);
        this.f_19804_.m_135372_(IS_OWNED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsPlayerOwned", this.isPlayerOwned());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("IsPlayerOwned")) {
            this.setPlayerOwned(compound.m_128471_("IsPlayerOwned"));
        }
    }

    public static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class PhantomMoveControl
    extends MoveControl {
        private float speed;

        public PhantomMoveControl(Mob pMob) {
            super(pMob);
            this.speed = 0.4f;
        }

        public void m_8126_() {
            this.speed = PhantomGunner.this.f_33096_.equals((Object)AttackPhase.SWOOP) ? 1.0f : 0.75f;
            double $$0 = PhantomGunner.this.f_33097_.f_82479_ - PhantomGunner.this.m_20185_();
            double $$1 = PhantomGunner.this.f_33097_.f_82480_ - PhantomGunner.this.m_20186_();
            double $$2 = PhantomGunner.this.f_33097_.f_82481_ - PhantomGunner.this.m_20189_();
            double $$3 = Math.sqrt($$0 * $$0 + $$2 * $$2);
            if (Math.abs($$3) > (double)1.0E-5f) {
                double $$4 = 1.0 - Math.abs($$1 * (double)0.7f) / $$3;
                $$3 = Math.sqrt(($$0 *= $$4) * $$0 + ($$2 *= $$4) * $$2);
                double $$5 = Math.sqrt($$0 * $$0 + $$2 * $$2 + $$1 * $$1);
                float $$6 = PhantomGunner.this.m_146908_();
                float $$7 = (float)Mth.m_14136_((double)$$2, (double)$$0);
                float $$8 = Mth.m_14177_((float)(PhantomGunner.this.m_146908_() + 90.0f));
                float $$9 = Mth.m_14177_((float)($$7 * 57.295776f));
                PhantomGunner.this.m_146922_(Mth.m_14148_((float)$$8, (float)$$9, (float)4.0f) - 90.0f);
                PhantomGunner.this.f_20883_ = PhantomGunner.this.m_146908_();
                this.speed = Mth.m_14145_((float)$$6, (float)PhantomGunner.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)2.5f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.4f, (float)0.025f);
                float $$10 = (float)(-(Mth.m_14136_((double)(-$$1), (double)$$3) * 57.2957763671875));
                PhantomGunner.this.m_146926_($$10);
                float $$11 = PhantomGunner.this.m_146908_() + 90.0f;
                double $$12 = (double)(this.speed * Mth.m_14089_((float)($$11 * ((float)Math.PI / 180)))) * Math.abs($$0 / $$5);
                double $$13 = (double)(this.speed * Mth.m_14031_((float)($$11 * ((float)Math.PI / 180)))) * Math.abs($$2 / $$5);
                double $$14 = (double)(this.speed * Mth.m_14031_((float)($$10 * ((float)Math.PI / 180)))) * Math.abs($$1 / $$5);
                Vec3 $$15 = PhantomGunner.this.m_20184_();
                PhantomGunner.this.m_20256_($$15.m_82549_(new Vec3($$12, $$14, $$13).m_82546_($$15).m_82490_(0.2)));
            }
        }
    }

    public class PhantomGunnerAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        public boolean m_8036_() {
            if (PhantomGunner.this.getPlayer() != null) {
                double dz;
                double dx = PhantomGunner.this.m_20185_() - PhantomGunner.this.getPlayer().m_20185_();
                return dx * dx + (dz = PhantomGunner.this.m_20189_() - PhantomGunner.this.getPlayer().m_20189_()) * dz <= 256.0;
            }
            LivingEntity $$0 = PhantomGunner.this.m_5448_();
            return $$0 != null ? PhantomGunner.this.m_21040_($$0, TargetingConditions.m_148352_().m_148355_()) : false;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            PhantomGunner.this.f_33096_ = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            PhantomGunner.this.f_33098_ = PhantomGunner.this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, PhantomGunner.this.f_33098_).m_6630_(10 + PhantomGunner.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (PhantomGunner.this.f_33096_ == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    PhantomGunner.this.f_33096_ = AttackPhase.SWOOP;
                    PhantomGunner.this.attackTimer = 80;
                    this.setAnchorOvershot();
                    this.nextSweepTick = this.m_183277_(120);
                    PhantomGunner.this.m_5496_(SoundEvents.f_12232_, 10.0f, 0.95f + PhantomGunner.this.f_19796_.m_188501_() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            if (PhantomGunner.this.m_5448_() == null) {
                return;
            }
            PhantomGunner.this.f_33098_ = PhantomGunner.this.m_5448_().m_20183_().m_6630_(20 + PhantomGunner.this.f_19796_.m_188503_(20));
            if (PhantomGunner.this.f_33098_.m_123342_() < PhantomGunner.this.m_9236_().m_5736_()) {
                PhantomGunner.this.f_33098_ = new BlockPos(PhantomGunner.this.f_33098_.m_123341_(), PhantomGunner.this.m_9236_().m_5736_() + 1, PhantomGunner.this.f_33098_.m_123343_());
            }
        }

        private void setAnchorOvershot() {
            if (PhantomGunner.this.m_5448_() == null) {
                return;
            }
            LivingEntity target = PhantomGunner.this.m_5448_();
            Vec3 phantomPos = PhantomGunner.this.m_20182_();
            Vec3 targetPos = target.m_20182_();
            Vec3 direction = targetPos.m_82546_(phantomPos).m_82541_();
            double overshootDistance = 32 + PhantomGunner.this.f_19796_.m_188503_(6);
            Vec3 overshotPos = targetPos.m_82549_(direction.m_82490_(overshootDistance));
            int targetHeight = target.m_146904_();
            int maxHeight = Math.min(targetHeight + 32, PhantomGunner.this.m_9236_().m_151558_() - 1);
            int finalHeight = Math.min(targetHeight, maxHeight);
            PhantomGunner.this.f_33098_ = new BlockPos((int)overshotPos.f_82479_, finalHeight, (int)overshotPos.f_82481_);
        }
    }

    class PhantomGunnerSweepAttackGoal
    extends PhantomMoveTargetGoal {
        PhantomGunnerSweepAttackGoal() {
        }

        public boolean m_8036_() {
            return !PhantomGunner.this.isDying() && PhantomGunner.this.m_5448_() != null && PhantomGunner.this.f_33096_ == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            if (PhantomGunner.this.isDying()) {
                return false;
            }
            LivingEntity $$0 = PhantomGunner.this.m_5448_();
            if ($$0 == null) {
                return false;
            }
            if (!$$0.m_6084_()) {
                return false;
            }
            if ($$0 instanceof Player) {
                Player $$1 = (Player)$$0;
                if ($$0.m_5833_() || $$1.m_7500_()) {
                    return false;
                }
            }
            return this.m_8036_();
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            PhantomGunner.this.m_6710_(null);
            PhantomGunner.this.f_33096_ = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            LivingEntity $$0 = PhantomGunner.this.m_5448_();
            if ($$0 != null) {
                PhantomGunner.this.f_33097_ = new Vec3($$0.m_20185_(), $$0.m_20227_(8.0), $$0.m_20189_());
                if (PhantomGunner.this.m_20191_().m_82400_((double)0.2f).m_82381_($$0.m_20191_())) {
                    PhantomGunner.this.m_7327_((Entity)$$0);
                    PhantomGunner.this.f_33096_ = AttackPhase.CIRCLE;
                    if (!PhantomGunner.this.m_20067_()) {
                        PhantomGunner.this.m_9236_().m_46796_(1039, PhantomGunner.this.m_20183_(), 0);
                    }
                }
            }
        }
    }

    public class PhantomGunnerCircleAroundAnchorGoal
    extends PhantomMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        public boolean m_8036_() {
            return !PhantomGunner.this.isDying() && (PhantomGunner.this.m_5448_() == null || PhantomGunner.this.getPlayer() != null || PhantomGunner.this.f_33096_ == AttackPhase.CIRCLE);
        }

        public void m_8056_() {
            this.distance = 5.0f + PhantomGunner.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + PhantomGunner.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = PhantomGunner.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (PhantomGunner.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + PhantomGunner.this.f_19796_.m_188501_() * 9.0f;
            }
            if (PhantomGunner.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (PhantomGunner.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = PhantomGunner.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (PhantomGunner.this.f_33097_.f_82480_ < PhantomGunner.this.m_20186_() && !PhantomGunner.this.m_9236_().m_46859_(PhantomGunner.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (PhantomGunner.this.f_33097_.f_82480_ > PhantomGunner.this.m_20186_() && !PhantomGunner.this.m_9236_().m_46859_(PhantomGunner.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)PhantomGunner.this.f_33098_)) {
                PhantomGunner.this.f_33098_ = PhantomGunner.this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, PhantomGunner.this.m_20183_()).m_6630_(40);
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            PhantomGunner.this.f_33097_ = Vec3.m_82528_((Vec3i)PhantomGunner.this.f_33098_).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), 24.0, (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    public class PhantomGunnerAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = PhantomGunnerAttackPlayerTargetGoal.m_186073_((int)20);

        public boolean m_8036_() {
            if (PhantomGunner.this.isPlayerOwned() || PhantomGunner.this.playerOwned) {
                return false;
            }
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = PhantomGunnerAttackPlayerTargetGoal.m_186073_((int)60);
            List $$0 = PhantomGunner.this.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)PhantomGunner.this, PhantomGunner.this.m_20191_().m_82377_(64.0, 100.0, 64.0));
            if (!$$0.isEmpty()) {
                for (Player $$1 : $$0) {
                    if (!PhantomGunner.this.m_21040_((LivingEntity)$$1, TargetingConditions.m_148352_().m_148355_())) continue;
                    PhantomGunner.this.m_6710_((LivingEntity)$$1);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity $$0 = PhantomGunner.this.m_5448_();
            return $$0 != null ? PhantomGunner.this.m_21040_($$0, TargetingConditions.m_148352_().m_148355_()) : false;
        }
    }

    public abstract class PhantomMoveTargetGoal
    extends Goal {
        public PhantomMoveTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return PhantomGunner.this.f_33097_.m_82531_(PhantomGunner.this.m_20185_(), PhantomGunner.this.m_20186_(), PhantomGunner.this.m_20189_()) < 4.0;
        }
    }
}

