/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import ttv.migami.jeg.item.ToolTipItem;

public class ScoreStreakItem
extends ToolTipItem {
    private int maxPoints = 2000;
    private static final int TICK_INTERVAL = 200;

    public ScoreStreakItem(Item.Properties properties, int maxPoints) {
        super(properties);
        this.maxPoints = maxPoints;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.f_46443_ && entity instanceof Player) {
            int points = this.getPoints(stack);
            int seconds = this.getSeconds(stack);
            if (seconds <= 0 && points < this.maxPoints) {
                this.setPoints(stack, points + 200);
                this.setSeconds(stack, 200);
            }
            if (seconds > 0 && points < this.maxPoints) {
                this.setSeconds(stack, seconds - 1);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null) {
            tooltip.add((Component)Component.m_237115_((String)"info.jeg.score_streak_points").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(tagCompound.m_128451_("Points"))).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"/")).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)String.valueOf(this.maxPoints)).m_130940_(ChatFormatting.GOLD))));
        }
        tooltip.add((Component)Component.m_237115_((String)("info.jeg.tooltip_item." + this.m_5456_())).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.score_streak_item").m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getPoints(stack) >= this.maxPoints || player.m_7500_()) {
            this.useScoreStreak(player);
            if (!player.m_7500_()) {
                this.setPoints(stack, 0);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void useScoreStreak(Player player) {
    }

    public int getPoints(ItemStack stack) {
        return stack.m_41784_().m_128451_("Points");
    }

    public void setPoints(ItemStack stack, int points) {
        stack.m_41784_().m_128405_("Points", Math.min(points, this.maxPoints));
    }

    public int getSeconds(ItemStack stack) {
        return stack.m_41784_().m_128451_("Seconds");
    }

    public void setSeconds(ItemStack stack, int seconds) {
        stack.m_41784_().m_128405_("Seconds", seconds);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getPoints(stack) < this.maxPoints;
    }

    public int m_142158_(ItemStack stack) {
        return (int)(13.0 * (double)this.getPoints(stack) / (double)this.maxPoints);
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.getPoints(stack) / (float)this.maxPoints) * 0.33f), (float)1.0f, (float)1.0f);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }
}

