/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.rear;

import com.mojang.datafixers.util.Pair;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.screen.SingleSlotScreenHandler;
import io.github.foundationgames.automobility.util.network.CommonPackets;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BannerPostRearAttachment
extends RearAttachment {
    private static final Component UI_TITLE = Component.m_237115_((String)"container.automobility.banner_post");
    @Nullable
    private DyeColor baseColor = null;
    private ListTag patternNbt = new ListTag();
    private List<Pair<Holder<BannerPattern>, DyeColor>> patterns;
    public final Container inventory = new SimpleContainer(1){

        public void m_6836_(int slot, ItemStack stack) {
            super.m_6836_(slot, stack);
            BannerPostRearAttachment.this.setFromItem(stack);
        }
    };

    public BannerPostRearAttachment(RearAttachmentType<?> type, AutomobileEntity entity) {
        super(type, entity);
    }

    public void sendPacket() {
        CompoundTag nbt = new CompoundTag();
        this.putToNbt(nbt);
        if (!this.world().m_5776_()) {
            this.automobile().forNearbyPlayers(200, false, p -> CommonPackets.sendBannerPostAttachmentUpdatePacket(this.automobile(), nbt, p));
        }
    }

    @Override
    public void updatePacketRequested(ServerPlayer player) {
        super.updatePacketRequested(player);
        CompoundTag nbt = new CompoundTag();
        this.putToNbt(nbt);
        CommonPackets.sendBannerPostAttachmentUpdatePacket(this.automobile(), nbt, player);
    }

    public void putToNbt(CompoundTag nbt) {
        if (this.baseColor != null) {
            nbt.m_128405_("Color", this.baseColor.m_41060_());
        }
        if (this.patternNbt != null) {
            nbt.m_128365_("Patterns", (Tag)this.patternNbt);
        }
    }

    public void setFromNbt(CompoundTag nbt) {
        this.baseColor = nbt.m_128441_("Color") ? DyeColor.m_41053_((int)nbt.m_128451_("Color")) : null;
        this.patternNbt = nbt.m_128425_("Patterns", 9) ? nbt.m_128437_("Patterns", 10) : new ListTag();
        this.patterns = null;
    }

    public void setFromItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof BannerItem)) {
            this.erase();
            return;
        }
        BannerItem banner = (BannerItem)item;
        this.baseColor = banner.m_40545_();
        CompoundTag nbt = BlockItem.m_186336_((ItemStack)stack);
        this.patternNbt = nbt != null && nbt.m_128425_("Patterns", 9) ? nbt.m_128437_("Patterns", 10) : new ListTag();
        this.patterns = null;
        if (!this.world().m_5776_()) {
            this.sendPacket();
        }
    }

    public void erase() {
        this.baseColor = null;
        if (!this.world().m_5776_()) {
            this.sendPacket();
        }
    }

    @Nullable
    public DyeColor getBaseColor() {
        return this.baseColor;
    }

    public List<Pair<Holder<BannerPattern>, DyeColor>> getPatterns() {
        if (this.patterns == null) {
            this.patterns = BannerBlockEntity.m_58484_((DyeColor)this.baseColor, (ListTag)this.patternNbt);
        }
        return this.patterns;
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        Vec3 pos = this.pos();
        Containers.m_18992_((Level)this.world(), (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (ItemStack)this.inventory.m_8020_(0));
    }

    @Override
    public void writeNbt(CompoundTag nbt) {
        super.writeNbt(nbt);
        this.putToNbt(nbt);
        CompoundTag item = new CompoundTag();
        this.inventory.m_8020_(0).m_41739_(item);
        nbt.m_128365_("Banner", (Tag)item);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.setFromNbt(nbt);
        this.inventory.m_6836_(0, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Banner")));
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    @Nullable
    public MenuProvider createMenu(ContainerLevelAccess ctx) {
        return new SimpleMenuProvider((syncId, playerInv, player) -> new SingleSlotScreenHandler(syncId, playerInv, this.inventory), UI_TITLE);
    }
}

