/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.WheelBase;
import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.render.AutomobileModels;
import io.github.foundationgames.automobility.automobile.render.BaseModel;
import io.github.foundationgames.automobility.automobile.render.ExhaustFumesModel;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.automobile.render.SkidEffectModel;
import io.github.foundationgames.automobility.automobile.render.attachment.front.FrontAttachmentRenderModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.RearAttachmentRenderModel;
import io.github.foundationgames.automobility.automobile.render.wheel.WheelContextReceiver;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public final class AutomobileRenderer
extends Enum<AutomobileRenderer> {
    private static final /* synthetic */ AutomobileRenderer[] $VALUES;

    public static AutomobileRenderer[] values() {
        return (AutomobileRenderer[])$VALUES.clone();
    }

    public static AutomobileRenderer valueOf(String name) {
        return Enum.valueOf(AutomobileRenderer.class, name);
    }

    public static void render(PoseStack pose, MultiBufferSource buffers, int light, int overlay, float tickDelta, RenderableAutomobile automobile) {
        FrontAttachmentType<?> frontAtt;
        AutomobileFrame frame = automobile.getFrame();
        AutomobileWheel wheels = automobile.getWheels();
        AutomobileEngine engine = automobile.getEngine();
        Model skidEffectModel = AutomobileModels.getModel(AutomobileModels.SKID_EFFECT);
        Model exhaustFumesModel = AutomobileModels.getModel(AutomobileModels.EXHAUST_FUMES);
        pose.m_85836_();
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(automobile.getAutomobileYaw(tickDelta) + 180.0f));
        float chassisRaise = wheels.model().radius() / 16.0f;
        float bounce = automobile.getSuspensionBounce(tickDelta) * 0.048f;
        Model frameModel = AutomobileModels.getModel(automobile.getFrame().model().modelId());
        Model wheelModel = AutomobileModels.getModel(automobile.getWheels().model().modelId());
        Model engineModel = AutomobileModels.getModel(automobile.getEngine().model().modelId());
        Model rearAttachmentModel = AutomobileModels.getModel(automobile.getRearAttachmentType().model().modelId());
        Model frontAttachmentModel = AutomobileModels.getModel(automobile.getFrontAttachmentType().model().modelId());
        pose.m_252880_(0.0f, -chassisRaise, 0.0f);
        pose.m_85836_();
        pose.m_85837_(0.0, (double)bounce + (automobile.engineRunning() ? Math.cos((double)((float)automobile.getTime() + tickDelta) * 2.7) / 156.0 : 0.0), 0.0);
        ResourceLocation frameTexture = frame.model().texture();
        ResourceLocation engineTexture = engine.model().texture();
        if (!frame.isEmpty() && frameModel != null) {
            frameModel.m_7695_(pose, buffers.m_6299_(frameModel.m_103119_(frameTexture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (frameModel instanceof BaseModel) {
                BaseModel base = (BaseModel)frameModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
        }
        float eBack = frame.model().enginePosBack() / 16.0f;
        float eUp = frame.model().enginePosUp() / 16.0f;
        pose.m_252880_(0.0f, -eUp, eBack);
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        if (!engine.isEmpty() && engineModel != null) {
            engineModel.m_7695_(pose, buffers.m_6299_(engineModel.m_103119_(engineTexture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (engineModel instanceof BaseModel) {
                BaseModel base = (BaseModel)engineModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
        }
        VertexConsumer exhaustBuffer = null;
        if (automobile.getBoostTimer() > 0) {
            exhaustTexes = ExhaustFumesModel.FLAME_TEXTURES;
            index = (int)(automobile.getTime() % (long)exhaustTexes.length);
            exhaustBuffer = buffers.m_6299_(RenderType.m_110488_((ResourceLocation)exhaustTexes[index]));
        } else if (automobile.engineRunning()) {
            exhaustTexes = ExhaustFumesModel.SMOKE_TEXTURES;
            index = (int)Math.floor(((float)automobile.getTime() + tickDelta) / 1.5f % (float)exhaustTexes.length);
            exhaustBuffer = buffers.m_6299_(RenderType.m_110473_((ResourceLocation)exhaustTexes[index]));
        }
        if (exhaustBuffer != null) {
            for (AutomobileEngine.ExhaustPos exhaust : engine.model().exhausts()) {
                pose.m_85836_();
                pose.m_252880_(exhaust.x() / 16.0f, -exhaust.y() / 16.0f, exhaust.z() / 16.0f);
                pose.m_252781_(Axis.f_252436_.m_252977_(exhaust.yaw()));
                pose.m_252781_(Axis.f_252529_.m_252977_(exhaust.pitch()));
                exhaustFumesModel.m_7695_(pose, exhaustBuffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                pose.m_85849_();
            }
        }
        pose.m_85849_();
        RearAttachmentType<?> rearAtt = automobile.getRearAttachmentType();
        if (!rearAtt.isEmpty()) {
            pose.m_85836_();
            pose.m_252880_(0.0f, chassisRaise, frame.model().rearAttachmentPos() / 16.0f);
            pose.m_252781_(Axis.f_252392_.m_252977_(automobile.getAutomobileYaw(tickDelta) - automobile.getRearAttachmentYaw(tickDelta)));
            pose.m_252880_(0.0f, 0.0f, rearAtt.model().pivotDistPx() / 16.0f);
            if (rearAttachmentModel instanceof RearAttachmentRenderModel) {
                RearAttachmentRenderModel rm = (RearAttachmentRenderModel)rearAttachmentModel;
                rm.setRenderState(automobile.getRearAttachment(), (float)Math.toRadians(automobile.getWheelAngle(tickDelta)), tickDelta);
            }
            rearAttachmentModel.m_7695_(pose, buffers.m_6299_(rearAttachmentModel.m_103119_(rearAtt.model().texture())), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (rearAttachmentModel instanceof BaseModel) {
                BaseModel base = (BaseModel)rearAttachmentModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
            pose.m_85849_();
        }
        if (!(frontAtt = automobile.getFrontAttachmentType()).isEmpty()) {
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, frame.model().frontAttachmentPos() / -16.0f);
            if (frontAttachmentModel instanceof FrontAttachmentRenderModel) {
                FrontAttachmentRenderModel fm = (FrontAttachmentRenderModel)frontAttachmentModel;
                fm.setRenderState(automobile.getFrontAttachment(), chassisRaise, tickDelta);
            }
            frontAttachmentModel.m_7695_(pose, buffers.m_6299_(frontAttachmentModel.m_103119_(frontAtt.model().texture())), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (frontAttachmentModel instanceof BaseModel) {
                BaseModel base = (BaseModel)frontAttachmentModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
            pose.m_85849_();
        }
        WheelBase.WheelPos[] wPoses = frame.model().wheelBase().wheels;
        if (!wheels.isEmpty()) {
            VertexConsumer wheelBuffer = buffers.m_6299_(wheelModel.m_103119_(wheels.model().texture()));
            float wheelAngle = automobile.getWheelAngle(tickDelta);
            int wheelCount = automobile.getWheelCount();
            for (WheelBase.WheelPos pos : wPoses) {
                if (wheelCount <= 0) break;
                if (wheelModel instanceof WheelContextReceiver) {
                    WheelContextReceiver receiver = (WheelContextReceiver)wheelModel;
                    receiver.provideContext(pos);
                }
                float scale = pos.scale();
                float wheelRadius = wheels.model().radius() - wheels.model().radius() * (scale - 1.0f);
                pose.m_85836_();
                pose.m_252880_(pos.right() / 16.0f, wheelRadius / 16.0f, -pos.forward() / 16.0f);
                if (pos.end() == WheelBase.WheelEnd.FRONT) {
                    pose.m_252781_(Axis.f_252436_.m_252977_(automobile.getSteering(tickDelta) * 27.0f));
                }
                pose.m_252880_(0.0f, -chassisRaise, 0.0f);
                pose.m_252781_(Axis.f_252529_.m_252977_(wheelAngle));
                pose.m_85841_(scale, scale, scale);
                pose.m_252781_(Axis.f_252436_.m_252977_(180.0f + pos.yaw()));
                wheelModel.m_7695_(pose, wheelBuffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                if (wheelModel instanceof BaseModel) {
                    BaseModel base = (BaseModel)wheelModel;
                    base.doOtherLayerRender(pose, buffers, light, overlay);
                }
                pose.m_85849_();
                --wheelCount;
            }
        }
        if ((automobile.getTurboCharge() > 35 || automobile.debris()) && automobile.automobileOnGround()) {
            ResourceLocation[] skidTexes = SkidEffectModel.COOL_SPARK_TEXTURES;
            boolean bright = true;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (automobile.getTurboCharge() > 115) {
                skidTexes = SkidEffectModel.FLAME_TEXTURES;
            } else if (automobile.getTurboCharge() > 70) {
                skidTexes = SkidEffectModel.HOT_SPARK_TEXTURES;
            } else if (automobile.debris()) {
                skidTexes = SkidEffectModel.DEBRIS_TEXTURES;
                Vector3f c = automobile.debrisColor();
                r = c.x() * 0.85f;
                g = c.y() * 0.85f;
                b = c.z() * 0.85f;
                bright = false;
            }
            int index = (int)Math.floor(((float)automobile.getTime() + tickDelta) / 1.5f % (float)skidTexes.length);
            VertexConsumer skidEffectBuffer = buffers.m_6299_(bright ? RenderType.m_110488_((ResourceLocation)skidTexes[index]) : RenderType.m_110476_((ResourceLocation)skidTexes[index]));
            for (WheelBase.WheelPos pos : wPoses) {
                if (pos.end() != WheelBase.WheelEnd.BACK) continue;
                float scale = pos.scale();
                float heightOffset = wheels.model().radius();
                float wheelRadius = wheels.model().radius() * scale;
                float wheelWidth = wheels.model().width() / 16.0f * scale;
                float back = wheelRadius > 2.0f ? (float)(Math.sqrt((double)(wheelRadius * wheelRadius) - Math.pow(wheelRadius - 2.0f, 2.0)) - 0.85) / 16.0f : 0.08f;
                pose.m_85836_();
                pose.m_252880_(pos.right() / 16.0f + wheelWidth * (float)(pos.side() == WheelBase.WheelSide.RIGHT ? 1 : -1), heightOffset / 16.0f, -pos.forward() / 16.0f + back);
                pose.m_85841_(pos.side() == WheelBase.WheelSide.LEFT ? -1.0f : 1.0f, 1.0f, -1.0f);
                skidEffectModel.m_7695_(pose, skidEffectBuffer, light, overlay, r, g, b, 0.6f);
                pose.m_85849_();
            }
        }
        pose.m_85849_();
    }

    private static /* synthetic */ AutomobileRenderer[] $values() {
        return new AutomobileRenderer[0];
    }

    static {
        $VALUES = AutomobileRenderer.$values();
    }
}

