/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.entity;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileStats;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.WheelBase;
import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.DeployableRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.block.AutomobileAssemblerBlock;
import io.github.foundationgames.automobility.block.LaunchGelBlock;
import io.github.foundationgames.automobility.block.OffRoadBlock;
import io.github.foundationgames.automobility.entity.AutomobilityEntities;
import io.github.foundationgames.automobility.entity.EntityWithInventory;
import io.github.foundationgames.automobility.item.AutomobileInteractable;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import io.github.foundationgames.automobility.particle.AutomobilityParticles;
import io.github.foundationgames.automobility.platform.Platform;
import io.github.foundationgames.automobility.screen.AutomobileContainerLevelAccess;
import io.github.foundationgames.automobility.sound.AutomobilitySounds;
import io.github.foundationgames.automobility.util.AUtils;
import io.github.foundationgames.automobility.util.duck.CollisionArea;
import io.github.foundationgames.automobility.util.network.ClientPackets;
import io.github.foundationgames.automobility.util.network.CommonPackets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AutomobileEntity
extends Entity
implements RenderableAutomobile,
EntityWithInventory {
    public static Consumer<AutomobileEntity> engineSound = e -> {};
    public static Consumer<AutomobileEntity> skidSound = e -> {};
    private static final EntityDataAccessor<Float> REAR_ATTACHMENT_YAW = SynchedEntityData.m_135353_(AutomobileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> REAR_ATTACHMENT_ANIMATION = SynchedEntityData.m_135353_(AutomobileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> FRONT_ATTACHMENT_ANIMATION = SynchedEntityData.m_135353_(AutomobileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private AutomobileFrame frame = AutomobileFrame.REGISTRY.getOrDefault(null);
    private AutomobileWheel wheels = AutomobileWheel.REGISTRY.getOrDefault(null);
    private AutomobileEngine engine = AutomobileEngine.REGISTRY.getOrDefault(null);
    private RearAttachment rearAttachment;
    private FrontAttachment frontAttachment;
    private final AutomobileStats stats = new AutomobileStats();
    public static final int SMALL_TURBO_TIME = 35;
    public static final int MEDIUM_TURBO_TIME = 70;
    public static final int LARGE_TURBO_TIME = 115;
    public static final float TERMINAL_VELOCITY = -1.2f;
    private long clientTime;
    private double trackedX;
    private double trackedY;
    private double trackedZ;
    private float trackedYaw;
    private int lerpTicks;
    private boolean dirty = false;
    private float engineSpeed = 0.0f;
    private float boostSpeed = 0.0f;
    private float speedDirection = 0.0f;
    private float lastBoostSpeed = this.boostSpeed;
    private int boostTimer = 0;
    private float boostPower = 0.0f;
    private int jumpCooldown = 0;
    private float hSpeed = 0.0f;
    private float vSpeed = 0.0f;
    private Vec3 addedVelocity = this.m_20184_();
    private float steering;
    private float lastSteering = this.steering = 0.0f;
    private float angularSpeed = 0.0f;
    private float wheelAngle = 0.0f;
    private float lastWheelAngle = 0.0f;
    private final Displacement displacement = new Displacement();
    private boolean drifting = false;
    private boolean burningOut = false;
    private int driftDir = 0;
    private int turboCharge = 0;
    private float lockedViewOffset = 0.0f;
    private boolean automobileOnGround;
    private boolean wasOnGround = this.automobileOnGround = true;
    private boolean isFloorDirectlyBelow = true;
    private boolean touchingWall = false;
    private Vec3 lastVelocity = Vec3.f_82478_;
    private Vec3 lastPosForDisplacement = Vec3.f_82478_;
    private Vec3 prevTailPos = null;
    private int slopeStickingTimer = 0;
    private float grip = 1.0f;
    private int suspensionBounceTimer;
    private int lastSusBounceTimer = this.suspensionBounceTimer = 0;
    private final Deque<Double> prevYDisplacements = new ArrayDeque<Double>();
    private boolean offRoad = false;
    private Vector3f debrisColor = new Vector3f();
    private int fallTicks = 0;
    private int despawnTime = -1;
    private int despawnCountdown = 0;
    private boolean decorative = false;
    private boolean wasEngineRunning = false;
    private float standStillTime = -1.3f;
    private boolean accelerating = false;
    private boolean braking = false;
    private boolean steeringLeft = false;
    private boolean steeringRight = false;
    private boolean holdingDrift;
    private boolean prevHoldDrift = this.holdingDrift = false;

    public void writeSyncToClientData(FriendlyByteBuf buf) {
        buf.writeInt(this.boostTimer);
        buf.writeFloat(this.steering);
        buf.writeFloat(this.wheelAngle);
        buf.writeInt(this.turboCharge);
        buf.writeFloat(this.engineSpeed);
        buf.writeFloat(this.boostSpeed);
        buf.writeByte((int)this.compactInputData());
        buf.writeBoolean(this.drifting);
        buf.writeBoolean(this.burningOut);
    }

    public void readSyncToClientData(FriendlyByteBuf buf) {
        this.boostTimer = buf.readInt();
        this.steering = buf.readFloat();
        this.wheelAngle = buf.readFloat();
        this.turboCharge = buf.readInt();
        this.engineSpeed = buf.readFloat();
        this.boostSpeed = buf.readFloat();
        this.readCompactedInputData(buf.readByte());
        this.setDrifting(buf.readBoolean());
        this.setBurningOut(buf.readBoolean());
    }

    public void m_7378_(CompoundTag nbt) {
        this.setComponents(AutomobileFrame.REGISTRY.getOrDefault(ResourceLocation.m_135820_((String)nbt.m_128461_("frame"))), AutomobileWheel.REGISTRY.getOrDefault(ResourceLocation.m_135820_((String)nbt.m_128461_("wheels"))), AutomobileEngine.REGISTRY.getOrDefault(ResourceLocation.m_135820_((String)nbt.m_128461_("engine"))));
        CompoundTag rAtt = nbt.m_128469_("rearAttachment");
        this.setRearAttachment(RearAttachment.fromNbt(rAtt));
        this.rearAttachment.readNbt(rAtt);
        CompoundTag fAtt = nbt.m_128469_("frontAttachment");
        this.setFrontAttachment(FrontAttachment.fromNbt(fAtt));
        this.frontAttachment.readNbt(fAtt);
        this.engineSpeed = nbt.m_128457_("engineSpeed");
        this.boostSpeed = nbt.m_128457_("boostSpeed");
        this.boostTimer = nbt.m_128451_("boostTimer");
        this.boostPower = nbt.m_128457_("boostPower");
        this.speedDirection = nbt.m_128457_("speedDirection");
        this.vSpeed = nbt.m_128457_("verticalSpeed");
        this.hSpeed = nbt.m_128457_("horizontalSpeed");
        this.addedVelocity = AUtils.v3dFromNbt(nbt.m_128469_("addedVelocity"));
        this.lastVelocity = AUtils.v3dFromNbt(nbt.m_128469_("lastVelocity"));
        this.angularSpeed = nbt.m_128457_("angularSpeed");
        this.steering = nbt.m_128457_("steering");
        this.wheelAngle = nbt.m_128457_("wheelAngle");
        this.drifting = nbt.m_128471_("drifting");
        this.driftDir = nbt.m_128451_("driftDir");
        this.burningOut = nbt.m_128471_("burningOut");
        this.turboCharge = nbt.m_128451_("turboCharge");
        this.accelerating = nbt.m_128471_("accelerating");
        this.braking = nbt.m_128471_("braking");
        this.steeringLeft = nbt.m_128471_("steeringLeft");
        this.steeringRight = nbt.m_128471_("steeringRight");
        this.holdingDrift = nbt.m_128471_("holdingDrift");
        this.fallTicks = nbt.m_128451_("fallTicks");
        this.despawnTime = nbt.m_128451_("despawnTime");
        this.despawnCountdown = nbt.m_128451_("despawnCountdown");
        this.decorative = nbt.m_128471_("decorative");
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128359_("frame", this.frame.getId().toString());
        nbt.m_128359_("wheels", this.wheels.getId().toString());
        nbt.m_128359_("engine", this.engine.getId().toString());
        nbt.m_128365_("rearAttachment", (Tag)this.rearAttachment.toNbt());
        nbt.m_128365_("frontAttachment", (Tag)this.frontAttachment.toNbt());
        nbt.m_128350_("engineSpeed", this.engineSpeed);
        nbt.m_128350_("boostSpeed", this.boostSpeed);
        nbt.m_128405_("boostTimer", this.boostTimer);
        nbt.m_128350_("boostPower", this.boostPower);
        nbt.m_128350_("speedDirection", this.speedDirection);
        nbt.m_128350_("verticalSpeed", this.vSpeed);
        nbt.m_128350_("horizontalSpeed", this.hSpeed);
        nbt.m_128365_("addedVelocity", (Tag)AUtils.v3dToNbt(this.addedVelocity));
        nbt.m_128365_("lastVelocity", (Tag)AUtils.v3dToNbt(this.lastVelocity));
        nbt.m_128350_("angularSpeed", this.angularSpeed);
        nbt.m_128350_("steering", this.steering);
        nbt.m_128350_("wheelAngle", this.wheelAngle);
        nbt.m_128379_("drifting", this.drifting);
        nbt.m_128405_("driftDir", this.driftDir);
        nbt.m_128379_("burningOut", this.burningOut);
        nbt.m_128405_("turboCharge", this.turboCharge);
        nbt.m_128379_("accelerating", this.accelerating);
        nbt.m_128379_("braking", this.braking);
        nbt.m_128379_("steeringLeft", this.steeringLeft);
        nbt.m_128379_("steeringRight", this.steeringRight);
        nbt.m_128379_("holdingDrift", this.holdingDrift);
        nbt.m_128405_("fallTicks", this.fallTicks);
        nbt.m_128405_("despawnTime", this.despawnTime);
        nbt.m_128405_("despawnCountdown", this.despawnCountdown);
        nbt.m_128379_("decorative", this.decorative);
    }

    public byte compactInputData() {
        int r = ((((this.accelerating ? 1 : 0) << 1 | (this.braking ? 1 : 0)) << 1 | (this.steeringLeft ? 1 : 0)) << 1 | (this.steeringRight ? 1 : 0)) << 1 | (this.holdingDrift ? 1 : 0);
        return (byte)r;
    }

    public void readCompactedInputData(byte data) {
        int d = data;
        this.holdingDrift = (1 & d) > 0;
        this.steeringRight = (1 & (d >>= 1)) > 0;
        this.steeringLeft = (1 & (d >>= 1)) > 0;
        this.braking = (1 & (d >>= 1)) > 0;
        this.accelerating = (1 & (d >>= 1)) > 0;
    }

    public AutomobileEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.setRearAttachment(RearAttachmentType.REGISTRY.getOrDefault(null));
        this.setFrontAttachment(FrontAttachmentType.REGISTRY.getOrDefault(null));
    }

    public AutomobileEntity(Level world) {
        this(AutomobilityEntities.AUTOMOBILE.require(), world);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        if (this.m_9236_().m_5776_()) {
            ClientPackets.requestSyncAutomobileComponentsPacket(this);
        }
    }

    @Override
    public AutomobileFrame getFrame() {
        return this.frame;
    }

    @Override
    public AutomobileWheel getWheels() {
        return this.wheels;
    }

    @Override
    public AutomobileEngine getEngine() {
        return this.engine;
    }

    @Override
    @Nullable
    public RearAttachment getRearAttachment() {
        return this.rearAttachment;
    }

    @Override
    @Nullable
    public FrontAttachment getFrontAttachment() {
        return this.frontAttachment;
    }

    @Override
    public float getSteering(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.lastSteering, (float)this.steering);
    }

    @Override
    public float getWheelAngle(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.lastWheelAngle, (float)this.wheelAngle);
    }

    public float getBoostSpeed(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.lastBoostSpeed, (float)this.boostSpeed);
    }

    @Override
    public float getSuspensionBounce(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.lastSusBounceTimer, (float)this.suspensionBounceTimer);
    }

    @Override
    public boolean engineRunning() {
        return this.boostTimer > 0 || this.m_20160_();
    }

    @Override
    public int getTurboCharge() {
        return this.turboCharge;
    }

    @Override
    public long getTime() {
        return this.clientTime;
    }

    public float getHSpeed() {
        return this.hSpeed;
    }

    public float getVSpeed() {
        return this.vSpeed;
    }

    @Override
    public int getBoostTimer() {
        return this.boostTimer;
    }

    public double getEffectiveSpeed() {
        Player player;
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_7578_()) {
            return Math.max(this.addedVelocity.m_82553_(), (double)Math.abs(this.hSpeed));
        }
        return Math.max(this.addedVelocity.m_82553_(), (double)Math.abs(this.engineSpeed + this.boostSpeed));
    }

    @Override
    public boolean automobileOnGround() {
        return this.automobileOnGround;
    }

    @Override
    public boolean debris() {
        return this.offRoad && this.hSpeed != 0.0f;
    }

    @Override
    public Vector3f debrisColor() {
        return this.debrisColor;
    }

    public boolean burningOut() {
        return this.burningOut;
    }

    private void setDrifting(boolean drifting) {
        if (this.m_9236_().m_5776_() && !this.drifting && drifting) {
            skidSound.accept(this);
        }
        this.drifting = drifting;
    }

    private void setBurningOut(boolean burningOut) {
        if (this.m_9236_().m_5776_() && !this.drifting && !this.burningOut && burningOut) {
            skidSound.accept(this);
        }
        this.burningOut = burningOut;
    }

    public boolean isDrifting() {
        return this.drifting;
    }

    public <T extends RearAttachment> void setRearAttachment(RearAttachmentType<T> rearAttachment) {
        if (rearAttachment == null) {
            return;
        }
        if (this.rearAttachment == null || this.rearAttachment.type != rearAttachment) {
            if (this.rearAttachment != null) {
                this.rearAttachment.onRemoved();
            }
            this.rearAttachment = (RearAttachment)rearAttachment.constructor().apply(rearAttachment, this);
            this.rearAttachment.setYaw(this.m_146908_());
            if (!this.m_9236_().m_5776_() && !this.rearAttachment.isRideable() && this.m_20197_().size() > 1) {
                ((Entity)this.m_20197_().get(1)).m_8127_();
            }
            this.syncAttachments();
        }
    }

    public <T extends FrontAttachment> void setFrontAttachment(FrontAttachmentType<T> frontAttachment) {
        if (frontAttachment == null) {
            return;
        }
        if (this.frontAttachment == null || this.frontAttachment.type != frontAttachment) {
            if (this.frontAttachment != null) {
                this.frontAttachment.onRemoved();
            }
            this.frontAttachment = (FrontAttachment)frontAttachment.constructor().apply(frontAttachment, this);
            this.syncAttachments();
        }
    }

    public void setComponents(AutomobileFrame frame, AutomobileWheel wheel, AutomobileEngine engine) {
        this.frame = frame;
        this.wheels = wheel;
        this.engine = engine;
        this.m_274367_(this.wheels.size());
        this.stats.from(frame, wheel, engine);
        this.displacement.applyWheelbase(frame.model().wheelBase());
        if (!this.m_9236_().m_5776_()) {
            this.syncComponents();
        }
    }

    public void forNearbyPlayers(int radius, boolean ignoreDriver, Consumer<ServerPlayer> action) {
        for (Player p : this.m_9236_().m_6907_()) {
            if (ignoreDriver && p == this.m_146895_() || !(p.m_20182_().m_82554_(this.m_20182_()) < (double)radius) || !(p instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)p;
            action.accept(player);
        }
    }

    public Vec3 getTailPos() {
        return this.m_20182_().m_82549_(new Vec3(0.0, 0.0, (double)this.getFrame().model().rearAttachmentPos() * 0.0625).m_82524_((float)Math.toRadians(180.0f - this.m_146908_())));
    }

    public Vec3 getHeadPos() {
        return this.m_20182_().m_82549_(new Vec3(0.0, 0.0, (double)this.getFrame().model().frontAttachmentPos() * 0.0625).m_82524_((float)Math.toRadians(-this.m_146908_())));
    }

    public boolean hasSpaceForPassengers() {
        return this.rearAttachment.isRideable() ? this.m_20197_().size() < 2 : !this.m_20160_();
    }

    public void setSpeed(float horizontal, float vertical) {
        this.hSpeed = horizontal;
        this.vSpeed = vertical;
    }

    public void m_8119_() {
        boolean first = this.f_19803_;
        if (this.lastWheelAngle != this.wheelAngle) {
            this.markDirty();
        }
        this.lastWheelAngle = this.wheelAngle;
        if (!this.wasEngineRunning && this.engineRunning() && this.m_9236_().m_5776_()) {
            engineSound.accept(this);
        }
        this.wasEngineRunning = this.engineRunning();
        if (!this.m_20160_() || !this.getFrontAttachment().canDrive(this.m_146895_())) {
            this.accelerating = false;
            this.braking = false;
            this.steeringLeft = false;
            this.steeringRight = false;
            this.holdingDrift = false;
        }
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        super.m_8119_();
        if (!((RearAttachmentType)this.rearAttachment.type).isEmpty()) {
            this.rearAttachment.tick();
        }
        if (!((FrontAttachmentType)this.frontAttachment.type).isEmpty()) {
            this.frontAttachment.tick();
        }
        Vec3 prevPos = this.m_20182_();
        this.positionTrackingTick();
        this.collisionStateTick();
        this.steeringTick();
        this.driftingTick();
        this.burnoutTick();
        this.movementTick();
        if (this.m_6109_()) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        this.postMovementTick();
        if (!this.m_9236_().m_5776_()) {
            Object object;
            Vec3 prevTailPos = this.prevTailPos != null ? this.prevTailPos : this.getTailPos();
            Vec3 tailPos = this.getTailPos();
            this.rearAttachment.pull(prevTailPos.m_82546_(tailPos));
            this.prevTailPos = tailPos;
            if (this.dirty) {
                this.syncData();
                this.dirty = false;
            }
            if (this.hasSpaceForPassengers() && !this.decorative) {
                List touchingEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(0.2, 0.0, 0.2), EntitySelector.m_20421_((Entity)this));
                object = touchingEntities.iterator();
                while (object.hasNext()) {
                    Entity entity = (Entity)object.next();
                    if (entity.m_20363_((Entity)this) || entity.m_20159_() || !(entity.m_20205_() <= this.m_20205_()) || !(entity instanceof Mob) || entity instanceof WaterAnimal) continue;
                    entity.m_20329_((Entity)this);
                }
            }
            if (this.m_20160_()) {
                if (this.getFrontAttachment().canDrive(this.m_146895_()) && (object = this.m_146895_()) instanceof Mob) {
                    Mob mob = (Mob)object;
                    this.provideMobDriverInputs(mob);
                }
                this.despawnCountdown = 0;
            } else if (this.despawnTime > 0) {
                ++this.despawnCountdown;
                if (this.despawnCountdown >= this.despawnTime) {
                    this.destroyAutomobile(false, Entity.RemovalReason.DISCARDED);
                }
            }
        } else {
            ++this.clientTime;
            this.lastSusBounceTimer = this.suspensionBounceTimer;
            if (this.suspensionBounceTimer > 0) {
                --this.suspensionBounceTimer;
            }
            this.standStillTime = (double)Math.abs(this.hSpeed) < 0.05 && !this.burningOut && this.m_6688_() instanceof Player ? AUtils.shift(this.standStillTime, 0.05f, 1.0f) : AUtils.shift(this.standStillTime, 0.15f, -1.3f);
        }
        this.displacementTick(first || this.m_20182_().m_82546_(prevPos).m_82553_() > 0.0 || this.m_146908_() != this.f_19859_);
    }

    public void positionTrackingTick() {
        if (this.m_6109_()) {
            this.lerpTicks = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        } else if (this.lerpTicks > 0) {
            this.m_6034_(this.m_20185_() + (this.trackedX - this.m_20185_()) / (double)this.lerpTicks, this.m_20186_() + (this.trackedY - this.m_20186_()) / (double)this.lerpTicks, this.m_20189_() + (this.trackedZ - this.m_20189_()) / (double)this.lerpTicks);
            this.m_146922_(this.m_146908_() + Mth.m_14177_((float)(this.trackedYaw - this.m_146908_())) / (float)this.lerpTicks);
            --this.lerpTicks;
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void syncData() {
        this.forNearbyPlayers(200, true, player -> CommonPackets.sendSyncAutomobileDataPacket(this, player));
    }

    private void syncComponents() {
        this.forNearbyPlayers(200, false, player -> CommonPackets.sendSyncAutomobileComponentsPacket(this, player));
    }

    private void syncAttachments() {
        this.forNearbyPlayers(200, false, player -> CommonPackets.sendSyncAutomobileAttachmentsPacket(this, player));
    }

    public ItemStack asPrefabItem() {
        ItemStack stack = new ItemStack((ItemLike)AutomobilityItems.AUTOMOBILE.require());
        CompoundTag automobile = stack.m_41698_("Automobile");
        automobile.m_128359_("frame", this.frame.getId().toString());
        automobile.m_128359_("wheels", this.wheels.getId().toString());
        automobile.m_128359_("engine", this.engine.getId().toString());
        return stack;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.asPrefabItem();
    }

    public void provideMobDriverInputs(Mob driver) {
        if (driver == null || driver.m_21224_() || driver.m_213877_()) {
            if (this.accelerating || this.steeringLeft || this.steeringRight) {
                this.markDirty();
            }
            this.accelerating = false;
            this.steeringLeft = false;
            this.steeringRight = false;
            return;
        }
        Path path = driver.m_21573_().m_26570_();
        if (path != null && !path.m_77392_() && path.m_77395_() != null) {
            Vec3 fnPos;
            double fnTarget;
            Vec3 pos = path.m_77395_().m_164701_().m_82546_(this.m_20182_());
            double target = Mth.m_14175_((double)Math.toDegrees(Math.atan2(pos.m_7096_(), pos.m_7094_())));
            if (Math.abs(target - (fnTarget = Mth.m_14175_((double)Math.toDegrees(Math.atan2((fnPos = path.m_77401_().m_164701_().m_82546_(this.m_20182_())).m_7096_(), fnPos.m_7094_()))))) > 69.0) {
                pos = fnPos;
                target = fnTarget;
            }
            float yaw = Mth.m_14177_((float)(-this.m_146908_()));
            double offset = Mth.m_14175_((double)((double)yaw - target));
            boolean reverse = false;
            float mul = 0.5f + Mth.m_14036_((float)this.hSpeed, (float)0.0f, (float)1.0f) * 0.5f;
            if (pos.m_82553_() < (double)(20.0f * mul) && Math.abs(offset) > (double)(180.0f - 170.0f * mul)) {
                long time = this.m_9236_().m_46467_();
                reverse = time % 80L <= 30L;
            }
            this.accelerating = !reverse;
            this.braking = reverse;
            if (offset < -7.0) {
                this.steeringRight = reverse;
                this.steeringLeft = !reverse;
            } else if (offset > 7.0) {
                this.steeringRight = !reverse;
                this.steeringLeft = reverse;
            }
            this.markDirty();
        } else {
            if (this.accelerating || this.steeringLeft || this.steeringRight) {
                this.markDirty();
            }
            this.accelerating = false;
            this.steeringLeft = false;
            this.steeringRight = false;
        }
    }

    public void movementTick() {
        Block block;
        this.lastBoostSpeed = this.boostSpeed;
        if (this.boostTimer > 0) {
            --this.boostTimer;
            this.boostSpeed = Math.min(this.boostPower, this.boostSpeed + 0.09f);
            if (this.engineSpeed < this.stats.getComfortableSpeed()) {
                this.engineSpeed += 0.012f;
            }
            this.markDirty();
        } else {
            this.boostSpeed = AUtils.zero(this.boostSpeed, 0.09f);
        }
        BlockPos blockBelow = new BlockPos((int)this.m_20185_(), (int)(this.m_20186_() - 0.05), (int)this.m_20189_());
        this.grip = 1.0f - Mth.m_14036_((float)((this.m_9236_().m_8055_(blockBelow).m_60734_().m_49958_() - 0.6f) / 0.4f), (float)0.0f, (float)1.0f) * (1.0f - this.stats.getGrip() * 0.8f);
        this.grip *= this.grip;
        if (this.automobileOnGround && this.jumpCooldown <= 0 && this.m_9236_().m_8055_(this.m_20183_()).m_60734_() instanceof LaunchGelBlock) {
            this.setSpeed(Math.max(this.getHSpeed(), 0.1f), Math.max(this.getVSpeed(), 0.9f));
            this.jumpCooldown = 5;
            this.automobileOnGround = false;
        }
        this.lastPosForDisplacement = this.m_20182_();
        Vec3 cumulative = this.addedVelocity;
        cumulative = cumulative.m_82520_(0.0, (double)(this.vSpeed * (this.m_5842_() ? 0.15f : 1.0f)), 0.0);
        this.speedDirection = this.m_146908_() - (this.drifting ? Math.min((float)(this.turboCharge * 6), 43.0f + -this.steering * 12.0f) * (float)this.driftDir : -this.steering * 12.0f);
        if (this.accelerating) {
            float speed = Math.max(this.engineSpeed, 0.0f);
            this.engineSpeed = (float)((double)this.engineSpeed + (this.drifting && AUtils.haveSameSign(this.steering, this.driftDir) || !this.drifting && this.steering != 0.0f && (double)this.hSpeed > 0.5 ? (this.hSpeed < this.stats.getComfortableSpeed() ? 0.001 : 0.0) : (double)this.calculateAcceleration(speed, this.stats) * (this.drifting ? 0.86 : 1.0) * (double)(this.engineSpeed > this.stats.getComfortableSpeed() ? 0.25f : 1.0f) * (double)this.grip));
        }
        if (this.braking) {
            this.engineSpeed = Math.max(this.engineSpeed - 0.15f, -0.25f);
        }
        if (!this.accelerating && !this.braking) {
            this.engineSpeed = AUtils.zero(this.engineSpeed, 0.025f);
        }
        if (!this.drifting && this.steering != 0.0f && (double)this.hSpeed > 0.8) {
            this.engineSpeed -= this.engineSpeed * 4.2E-4f;
        }
        if (this.burningOut()) {
            this.engineSpeed = (float)((double)this.engineSpeed - (double)this.engineSpeed * 0.5);
        }
        BlockPos below = new BlockPos((int)this.m_20185_(), (int)(this.m_20186_() - 0.51), (int)this.m_20189_());
        BlockState state = this.m_9236_().m_8055_(below);
        this.slopeStickingTimer = state.m_204336_(Automobility.STICKY_SLOPES) ? 1 : Math.max(0, this.slopeStickingTimer--);
        if (this.boostSpeed < 0.4f && (block = this.m_9236_().m_8055_(this.m_20183_()).m_60734_()) instanceof OffRoadBlock) {
            OffRoadBlock offRoad = (OffRoadBlock)block;
            int layers = (Integer)this.m_9236_().m_8055_(this.m_20183_()).m_61143_((Property)OffRoadBlock.LAYERS);
            float cap = this.stats.getComfortableSpeed() * (1.0f - (float)layers / 3.5f);
            this.engineSpeed = Math.min(cap, this.engineSpeed);
            this.debrisColor = offRoad.color;
            this.offRoad = true;
        } else {
            this.offRoad = false;
        }
        if (!this.burningOut()) {
            this.hSpeed = this.engineSpeed + this.boostSpeed;
        }
        double lowestPrevYDisp = 0.0;
        for (double d : this.prevYDisplacements) {
            lowestPrevYDisp = Math.min(d, lowestPrevYDisp);
        }
        if (this.slopeStickingTimer > 0 && this.automobileOnGround && lowestPrevYDisp <= 0.0) {
            double cumulHSpeed = Math.sqrt(cumulative.f_82479_ * cumulative.f_82479_ + cumulative.f_82481_ * cumulative.f_82481_);
            cumulative = cumulative.m_82520_(0.0, -(0.25 + cumulHSpeed), 0.0);
        }
        float angle = (float)Math.toRadians(-this.speedDirection);
        if (this.burningOut()) {
            if ((double)Math.abs(this.hSpeed) > 0.02) {
                this.addedVelocity = new Vec3(Math.sin(angle) * (double)this.hSpeed, 0.0, Math.cos(angle) * (double)this.hSpeed);
                this.hSpeed = 0.0f;
                cumulative = cumulative.m_82549_(this.addedVelocity);
            }
        } else {
            cumulative = cumulative.m_82520_(Math.sin(angle) * (double)this.hSpeed, 0.0, Math.cos(angle) * (double)this.hSpeed);
        }
        if ((cumulative = cumulative.m_82490_((double)this.grip).m_82549_(this.lastVelocity.m_82490_((double)(1.0f - this.grip)))).m_82553_() < 0.001) {
            cumulative = Vec3.f_82478_;
        }
        float wheelCircumference = (float)((double)(2.0f * (this.wheels.model().radius() / 16.0f)) * Math.PI);
        if (this.hSpeed > 0.0f) {
            this.markDirty();
        }
        this.wheelAngle += 300.0f * (this.hSpeed / wheelCircumference) + (this.hSpeed > 0.0f ? (1.0f - this.grip) * 15.0f : 0.0f);
        if (this.m_6109_()) {
            this.m_20256_(cumulative);
        }
        this.m_5834_();
        this.f_19812_ = true;
        this.lastVelocity = cumulative;
        if ((double)Math.abs(this.hSpeed) > 0.2) {
            this.runOverEntities(cumulative);
        }
    }

    public void runOverEntities(Vec3 velocity) {
        AABB frontBox = this.m_20191_().m_82383_(velocity.m_82490_(0.5));
        Vec3 velAdd = velocity.m_82520_(0.0, 0.1, 0.0).m_82490_(3.0);
        for (Entity entity2 : this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Entity.class), frontBox, entity -> entity != this && entity != this.m_146895_())) {
            if (entity2.m_20147_() || !(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            if (entity2.m_20202_() == this) continue;
            AutomobilityEntities.automobileDamageSource(this.m_9236_()).ifPresent(dmg -> living.m_6469_(dmg, this.hSpeed * 10.0f));
            entity2.m_5997_(velAdd.f_82479_, velAdd.f_82480_, velAdd.f_82481_);
        }
    }

    public void postMovementTick() {
        double addVelLen;
        float addedVelReduction = 0.1f;
        if (this.burningOut()) {
            addedVelReduction = 0.05f;
        }
        if ((addVelLen = this.addedVelocity.m_82553_()) > 0.0) {
            this.addedVelocity = this.addedVelocity.m_82490_(Math.max(0.0, addVelLen - (double)addedVelReduction) / addVelLen);
        }
        float angle = (float)Math.toRadians(-this.speedDirection);
        if (this.touchingWall && (double)this.hSpeed > 0.1 && this.addedVelocity.m_82553_() <= 0.0) {
            this.engineSpeed = (float)((double)this.engineSpeed / 3.6);
            double knockSpeed = -0.2 * (double)this.hSpeed - 0.5;
            this.addedVelocity = this.addedVelocity.m_82520_(Math.sin(angle) * knockSpeed, 0.0, Math.cos(angle) * knockSpeed);
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), AutomobilitySounds.COLLISION.require(), SoundSource.AMBIENT, 0.76f, 0.65f + 0.06f * (this.m_9236_().f_46441_.m_188501_() - 0.5f), true);
        }
        double yDisp = this.m_20182_().m_82546_(this.lastPosForDisplacement).m_7098_();
        this.fallTicks = !this.automobileOnGround && yDisp < 0.0 ? ++this.fallTicks : 0;
        double highestPrevYDisp = 0.0;
        for (double d : this.prevYDisplacements) {
            highestPrevYDisp = Math.max(d, highestPrevYDisp);
        }
        if (this.wasOnGround && !this.automobileOnGround && !this.isFloorDirectlyBelow) {
            this.vSpeed = (float)Mth.m_14008_((double)highestPrevYDisp, (double)0.0, (double)(this.hSpeed * 0.6f));
        }
        this.vSpeed = Math.max(this.vSpeed - 0.08f, !this.automobileOnGround ? -1.2f : -0.01f);
        this.prevYDisplacements.push(yDisp);
        if (this.prevYDisplacements.size() > 2) {
            this.prevYDisplacements.removeLast();
        }
        if (this.hSpeed != 0.0f) {
            float vOTarget;
            float f = vOTarget = this.drifting ? (float)(this.driftDir * -23) : this.steering * -5.6f;
            this.lockedViewOffset = vOTarget == 0.0f ? AUtils.zero(this.lockedViewOffset, 2.5f) : (this.lockedViewOffset < vOTarget ? Math.min(this.lockedViewOffset + 3.7f, vOTarget) : Math.max(this.lockedViewOffset - 3.7f, vOTarget));
        }
        float newAngularSpeed = this.angularSpeed;
        if (this.burningOut()) {
            float speed = (float)this.addedVelocity.m_82553_();
            float acc = 1.7f / (1.0f + this.frame.weight()) + 4.0f * speed;
            float lim = 9.0f + 4.0f * speed;
            newAngularSpeed = this.steering != 0.0f ? Mth.m_14036_((float)(newAngularSpeed + acc * this.steering), (float)(-lim), (float)lim) : AUtils.shift(newAngularSpeed, acc * 0.5f, 0.0f);
        } else if (this.hSpeed != 0.0f) {
            float traction = 1.0f / (1.0f + 4.0f * this.hSpeed) + 0.3f * this.stats.getGrip();
            newAngularSpeed = AUtils.shift(newAngularSpeed, 6.0f * traction, (this.drifting ? ((this.steering + (float)this.driftDir) * (float)this.driftDir * 2.5f + 1.5f) * (float)this.driftDir * ((1.0f - this.stats.getGrip() + 2.0f) / 2.5f) : this.steering * (4.0f * Math.min(this.hSpeed, 1.0f) + (this.hSpeed > 0.0f ? 2.0f : -3.5f))) * ((this.stats.getHandling() + 1.0f) / 2.0f));
        } else {
            newAngularSpeed = AUtils.shift(newAngularSpeed, 3.0f, 0.0f);
        }
        this.angularSpeed = newAngularSpeed * this.grip + this.angularSpeed * (1.0f - this.grip);
        if ((double)Math.abs(this.angularSpeed) < 3.0E-5) {
            this.angularSpeed = 0.0f;
        }
        if (this.hSpeed != 0.0f || this.burningOut()) {
            float yawInc = this.angularSpeed;
            float prevYaw = this.m_146908_();
            this.m_146922_(this.m_146908_() + yawInc);
            if (this.m_9236_().f_46443_) {
                Entity passenger = this.m_146895_();
                if (passenger instanceof Player) {
                    Player player = (Player)passenger;
                    if (AutomobileEntity.inLockedViewMode()) {
                        player.m_146922_(Mth.m_14177_((float)(this.m_146908_() + this.lockedViewOffset)));
                        player.m_5618_(Mth.m_14177_((float)(this.m_146908_() + this.lockedViewOffset)));
                    } else {
                        player.m_146922_(Mth.m_14177_((float)(player.m_146908_() + yawInc)));
                        player.m_5618_(Mth.m_14177_((float)(player.m_146908_() + yawInc)));
                    }
                }
            } else {
                for (Entity e : this.m_20197_()) {
                    if (e != this.m_146895_()) continue;
                    e.m_146922_(Mth.m_14177_((float)(e.m_146908_() + yawInc)));
                    e.m_5618_(Mth.m_14177_((float)(e.m_146908_() + yawInc)));
                }
            }
            if (this.m_9236_().m_5776_()) {
                this.f_19859_ = prevYaw;
            }
        }
    }

    public void m_6478_(MoverType movementType, Vec3 movement) {
        if (!this.m_9236_().m_5776_() && movementType == MoverType.PLAYER) {
            AUtils.IGNORE_ENTITY_GROUND_CHECK_STEPPING = true;
        }
        super.m_6478_(movementType, movement);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public void accumulateCollisionAreas(Collection<CollisionArea> areas) {
        this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82377_(3.0, 3.0, 3.0), e -> e != this && e.m_20202_() != this).forEach(e -> areas.add(CollisionArea.entity(e)));
    }

    public void displacementTick(boolean tick) {
        if (this.m_9236_().m_5776_()) {
            this.displacement.preTick();
            if (tick) {
                this.displacement.otherColliders.clear();
                this.accumulateCollisionAreas(this.displacement.otherColliders);
                this.displacement.tick(this.m_9236_(), this, this.m_20182_(), this.m_146908_(), this.m_274421_());
            }
            if (this.m_9236_().m_8055_(this.m_20183_()).m_60734_() instanceof AutomobileAssemblerBlock) {
                this.displacement.lastVertical = this.displacement.verticalTarget = -this.wheels.model().radius() / 16.0f;
            }
        }
    }

    public Displacement getDisplacement() {
        return this.displacement;
    }

    public void collisionStateTick() {
        this.wasOnGround = this.automobileOnGround;
        this.automobileOnGround = false;
        this.isFloorDirectlyBelow = false;
        this.touchingWall = false;
        AABB b = this.m_20191_();
        AABB groundBox = new AABB(b.f_82288_, b.f_82289_ - 0.04, b.f_82290_, b.f_82291_, b.f_82289_, b.f_82293_);
        double wid = (b.m_82362_() + b.m_82385_()) * 0.5;
        AABB floorBox = new AABB(b.f_82288_ + wid * 0.94, b.f_82289_ - 0.05, b.f_82290_ + wid * 0.94, b.f_82291_ - wid * 0.94, b.f_82289_, b.f_82293_ - wid * 0.94);
        AABB wallBox = b.m_82406_(0.05).m_82383_(this.lastVelocity.m_82541_().m_82490_(0.12));
        BlockPos start = new BlockPos((int)(b.f_82288_ - 0.1), (int)(b.f_82289_ - 0.2), (int)(b.f_82290_ - 0.1));
        BlockPos end = new BlockPos((int)(b.f_82291_ + 0.1), (int)(b.f_82292_ + 0.2 + (double)this.m_274421_()), (int)(b.f_82293_ + 0.1));
        VoxelShape groundCuboid = Shapes.m_83064_((AABB)groundBox);
        VoxelShape floorCuboid = Shapes.m_83064_((AABB)floorBox);
        VoxelShape wallCuboid = Shapes.m_83064_((AABB)wallBox);
        VoxelShape stepWallCuboid = wallCuboid.m_83216_(0.0, (double)this.m_274421_() - 0.05, 0.0);
        boolean wallHit = false;
        boolean stepWallHit = false;
        CollisionContext shapeCtx = CollisionContext.m_82750_((Entity)this);
        if (this.m_9236_().m_46832_(start, end)) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = start.m_123341_(); x <= end.m_123341_(); ++x) {
                for (int y = start.m_123342_(); y <= end.m_123342_(); ++y) {
                    for (int z = start.m_123343_(); z <= end.m_123343_(); ++z) {
                        pos.m_122178_(x, y, z);
                        BlockState state = this.m_9236_().m_8055_((BlockPos)pos);
                        VoxelShape blockShape = state.m_60742_((BlockGetter)this.m_9236_(), (BlockPos)pos, shapeCtx).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                        this.automobileOnGround |= Shapes.m_83157_((VoxelShape)blockShape, (VoxelShape)groundCuboid, (BooleanOp)BooleanOp.f_82689_);
                        this.isFloorDirectlyBelow |= Shapes.m_83157_((VoxelShape)blockShape, (VoxelShape)floorCuboid, (BooleanOp)BooleanOp.f_82689_);
                        wallHit |= Shapes.m_83157_((VoxelShape)blockShape, (VoxelShape)wallCuboid, (BooleanOp)BooleanOp.f_82689_);
                        stepWallHit |= Shapes.m_83157_((VoxelShape)blockShape, (VoxelShape)stepWallCuboid, (BooleanOp)BooleanOp.f_82689_);
                    }
                }
            }
        }
        this.touchingWall = wallHit && stepWallHit;
        HashSet<CollisionArea> otherColliders = new HashSet<CollisionArea>();
        this.accumulateCollisionAreas(otherColliders);
        this.automobileOnGround |= otherColliders.stream().anyMatch(col -> col.boxIntersects(groundBox));
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.trackedX = x;
        this.trackedY = y;
        this.trackedZ = z;
        this.trackedYaw = yaw;
        this.lerpTicks = this.m_6095_().m_20682_() + 1;
    }

    private float calculateAcceleration(float speed, AutomobileStats stats) {
        return 1.0f / (300.0f * speed + (18.5f - stats.getAcceleration() * 5.3f)) * (0.9f * ((stats.getAcceleration() + 1.0f) / 2.0f));
    }

    public void provideClientInput(boolean fwd, boolean back, boolean left, boolean right, boolean space) {
        if (fwd != this.accelerating || back != this.braking || left != this.steeringLeft || right != this.steeringRight || space != this.holdingDrift) {
            this.setInputs(fwd, back, left, right, space);
            ClientPackets.sendSyncAutomobileInputPacket(this, this.accelerating, this.braking, this.steeringLeft, this.steeringRight, this.holdingDrift);
        }
    }

    public void setInputs(boolean fwd, boolean back, boolean left, boolean right, boolean space) {
        this.accelerating = fwd;
        this.braking = back;
        this.steeringLeft = left;
        this.steeringRight = right;
        this.holdingDrift = space;
    }

    public void boost(float power, int time) {
        if (power > this.boostPower || time > this.boostTimer) {
            this.boostTimer = time;
            this.boostPower = power;
        }
        if (this.m_6109_()) {
            this.engineSpeed = Math.max(this.engineSpeed, this.stats.getComfortableSpeed() * 0.5f);
        }
    }

    private void steeringTick() {
        this.lastSteering = this.steering;
        if (this.steeringLeft == this.steeringRight) {
            this.steering = AUtils.zero(this.steering, 0.42f);
        } else if (this.steeringLeft) {
            this.steering -= 0.42f;
            this.steering = Math.max(-1.0f, this.steering);
        } else {
            this.steering += 0.42f;
            this.steering = Math.min(1.0f, this.steering);
        }
    }

    private void consumeTurboCharge() {
        if (this.turboCharge > 115) {
            this.boost(0.38f, 38);
        } else if (this.turboCharge > 70) {
            this.boost(0.3f, 21);
        } else if (this.turboCharge > 35) {
            this.boost(0.23f, 9);
        }
        this.turboCharge = 0;
    }

    private void driftingTick() {
        if (!this.prevHoldDrift && this.holdingDrift) {
            RearAttachment rearAttachment;
            if (this.steering != 0.0f && !this.drifting && this.hSpeed > 0.4f && this.automobileOnGround) {
                this.setDrifting(true);
                this.driftDir = this.steering > 0.0f ? 1 : -1;
                this.engineSpeed = (float)((double)this.engineSpeed - 0.028 * (double)this.engineSpeed);
            } else if (this.steering == 0.0f && !this.m_9236_().m_5776_() && (rearAttachment = this.getRearAttachment()) instanceof DeployableRearAttachment) {
                DeployableRearAttachment att = (DeployableRearAttachment)rearAttachment;
                att.deploy();
            }
        }
        if (this.drifting) {
            if (this.automobileOnGround()) {
                this.createDriftParticles();
            }
            if (this.prevHoldDrift && !this.holdingDrift) {
                this.setDrifting(false);
                this.consumeTurboCharge();
            } else if (this.hSpeed < 0.33f) {
                this.setDrifting(false);
                this.turboCharge = 0;
            }
            if (this.automobileOnGround) {
                this.turboCharge += this.steeringLeft && this.driftDir < 0 || this.steeringRight && this.driftDir > 0 ? 2 : 1;
            }
        }
        this.prevHoldDrift = this.holdingDrift;
    }

    private void endBurnout() {
        this.setBurningOut(false);
        this.engineSpeed = 0.0f;
    }

    private void burnoutTick() {
        if (this.burningOut()) {
            if (this.automobileOnGround()) {
                if (this.addedVelocity.m_82553_() > 0.05 || (double)Math.abs(this.angularSpeed) > 0.05) {
                    this.createDriftParticles();
                }
                if ((double)this.hSpeed < 0.08 && this.turboCharge <= 35) {
                    ++this.turboCharge;
                }
            }
            if (!this.braking) {
                this.endBurnout();
                this.consumeTurboCharge();
            } else if (!this.accelerating) {
                this.endBurnout();
                this.turboCharge = 0;
            }
            this.wheelAngle += 20.0f;
        } else if ((this.accelerating || (double)this.hSpeed > 0.05) && this.braking) {
            this.setBurningOut(true);
            this.turboCharge = 0;
        }
    }

    public void createDriftParticles() {
        Vec3 origin = this.m_20182_().m_82520_(0.0, (double)this.displacement.verticalTarget, 0.0);
        for (WheelBase.WheelPos wheel : this.getFrame().model().wheelBase().wheels) {
            if (wheel.end() != WheelBase.WheelEnd.BACK) continue;
            Vec3 pos = new Vec3((double)(wheel.right() + (float)(wheel.right() > 0.0f ? 1 : -1) * this.getWheels().model().width() * wheel.scale()), 0.0, (double)wheel.forward()).m_82496_((float)Math.toRadians(this.displacement.currAngularX)).m_82535_((float)Math.toRadians(this.displacement.currAngularZ)).m_82524_((float)Math.toRadians(-this.m_146908_())).m_82490_(0.0625).m_82520_(0.0, 0.4, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)AutomobilityParticles.DRIFT_SMOKE.require(), origin.f_82479_ + pos.f_82479_, origin.f_82480_ + pos.f_82480_, origin.f_82481_ + pos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private static boolean inLockedViewMode() {
        return Platform.get().inControllerMode();
    }

    @Override
    public float getAutomobileYaw(float tickDelta) {
        return this.m_5675_(tickDelta);
    }

    @Override
    public float getRearAttachmentYaw(float tickDelta) {
        return this.rearAttachment.yaw(tickDelta);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity firstPassenger = this.m_146895_();
        if (firstPassenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)firstPassenger;
            return living;
        }
        return null;
    }

    protected boolean m_7310_(Entity passenger) {
        return this.hasSpaceForPassengers();
    }

    @Override
    public boolean hasInventory() {
        return this.getRearAttachment().hasMenu();
    }

    @Override
    public void openInventory(Player player) {
        MenuProvider factory = this.getRearAttachment().createMenu(new AutomobileContainerLevelAccess(this));
        if (factory != null) {
            player.m_5893_(factory);
        }
    }

    public float getStandStillTime() {
        return this.standStillTime;
    }

    public void playHitSound(Vec3 pos) {
        this.m_9236_().m_220400_((Entity)this, GameEvent.f_223706_, pos);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144117_, SoundSource.AMBIENT, 1.0f, 0.9f + this.m_9236_().f_46441_.m_188501_() * 0.2f);
    }

    private void dropParts(Vec3 pos) {
        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, AutomobilityItems.AUTOMOBILE_FRAME.require().createStack(this.getFrame())));
        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, AutomobilityItems.AUTOMOBILE_ENGINE.require().createStack(this.getEngine())));
        ItemStack wheelStack = AutomobilityItems.AUTOMOBILE_WHEEL.require().createStack(this.getWheels());
        wheelStack.m_41764_(this.getFrame().model().wheelBase().wheelCount);
        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, wheelStack));
    }

    public void destroyRearAttachment(boolean drop) {
        if (drop) {
            Vec3 dropPos = this.rearAttachment.pos();
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, AutomobilityItems.REAR_ATTACHMENT.require().createStack(this.getRearAttachmentType())));
        }
        this.setRearAttachment(RearAttachmentType.EMPTY);
    }

    public void destroyFrontAttachment(boolean drop) {
        if (drop) {
            Vec3 dropPos = this.frontAttachment.pos();
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, AutomobilityItems.FRONT_ATTACHMENT.require().createStack(this.getFrontAttachmentType())));
        }
        this.setFrontAttachment(FrontAttachmentType.EMPTY);
    }

    public void destroyAutomobile(boolean drop, Entity.RemovalReason reason) {
        if (!((RearAttachmentType)this.rearAttachment.type).isEmpty()) {
            this.destroyRearAttachment(drop);
        }
        if (!((FrontAttachmentType)this.frontAttachment.type).isEmpty()) {
            this.destroyFrontAttachment(drop);
        }
        if (drop) {
            this.dropParts(this.m_20182_().m_82520_(0.0, 0.3, 0.0));
        }
        this.m_142687_(reason);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_6144_() && this.hasInventory()) {
            if (!this.m_9236_().m_5776_()) {
                this.openInventory(player);
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if ((!this.decorative || player.m_7500_()) && stack.m_150930_(AutomobilityItems.CROWBAR.require())) {
            double playerAngle = Math.toDegrees(Math.atan2(player.m_20189_() - this.m_20189_(), player.m_20185_() - this.m_20185_()));
            double angleDiff = Mth.m_14175_((double)((double)this.m_146908_() - playerAngle));
            if (angleDiff < 0.0 && !((FrontAttachmentType)this.frontAttachment.type).isEmpty()) {
                this.destroyFrontAttachment(!player.m_7500_());
                this.playHitSound(this.getHeadPos());
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!((RearAttachmentType)this.rearAttachment.type).isEmpty()) {
                this.destroyRearAttachment(!player.m_7500_());
                this.playHitSound(this.rearAttachment.pos());
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.destroyAutomobile(!player.m_7500_(), Entity.RemovalReason.KILLED);
            this.playHitSound(this.m_20182_());
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.decorative) {
            Item item = stack.m_41720_();
            if (item instanceof AutomobileInteractable) {
                AutomobileInteractable interactable = (AutomobileInteractable)item;
                return interactable.interactAutomobile(stack, player, hand, this);
            }
            if (!this.hasSpaceForPassengers()) {
                if (!(this.m_146895_() instanceof Player)) {
                    if (!this.m_9236_().m_5776_()) {
                        this.m_146895_().m_8127_();
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                return InteractionResult.PASS;
            }
            if (!this.m_9236_().m_5776_()) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return InteractionResult.PASS;
    }

    public double m_6048_() {
        return (this.wheels.model().radius() + this.frame.model().seatHeight() - 4.0f) / 16.0f;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunc) {
        if (passenger == this.m_146895_()) {
            Vec3 pos = this.m_20182_().m_82520_(0.0, (double)this.displacement.verticalTarget + passenger.m_6049_(), 0.0).m_82549_(new Vec3(0.0, this.m_6048_(), 0.0).m_82496_((float)Math.toRadians(-this.displacement.currAngularX)).m_82535_((float)Math.toRadians(-this.displacement.currAngularZ)));
            moveFunc.m_20372_(passenger, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        } else if (this.m_20363_(passenger)) {
            Vec3 pos = this.m_20182_().m_82549_(new Vec3(0.0, (double)this.displacement.verticalTarget, (double)this.getFrame().model().rearAttachmentPos() * 0.0625).m_82524_((float)Math.toRadians(180.0f - this.m_146908_())).m_82520_(0.0, this.rearAttachment.getPassengerHeightOffset() + passenger.m_6049_() - 0.14, 0.0).m_82549_(this.rearAttachment.scaledYawVec()).m_82496_((float)Math.toRadians(-this.displacement.currAngularX)).m_82535_((float)Math.toRadians(-this.displacement.currAngularZ)));
            moveFunc.m_20372_(passenger, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public boolean m_7337_(Entity other) {
        return Boat.m_38323_((Entity)this, (Entity)other);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(REAR_ATTACHMENT_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(REAR_ATTACHMENT_ANIMATION, (Object)Float.valueOf(0.0f));
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (REAR_ATTACHMENT_YAW.equals(data)) {
            this.rearAttachment.onTrackedYawUpdated(this.getTrackedRearAttachmentYaw());
        } else if (REAR_ATTACHMENT_ANIMATION.equals(data)) {
            this.rearAttachment.onTrackedAnimationUpdated(this.getTrackedRearAttachmentAnimation());
        } else if (FRONT_ATTACHMENT_ANIMATION.equals(data)) {
            this.frontAttachment.onTrackedAnimationUpdated(this.getTrackedFrontAttachmentAnimation());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void setTrackedRearAttachmentYaw(float value) {
        this.f_19804_.m_135381_(REAR_ATTACHMENT_YAW, (Object)Float.valueOf(value));
    }

    public float getTrackedRearAttachmentYaw() {
        return ((Float)this.f_19804_.m_135370_(REAR_ATTACHMENT_YAW)).floatValue();
    }

    public void setTrackedRearAttachmentAnimation(float animation) {
        this.f_19804_.m_135381_(REAR_ATTACHMENT_ANIMATION, (Object)Float.valueOf(animation));
    }

    public float getTrackedRearAttachmentAnimation() {
        return ((Float)this.f_19804_.m_135370_(REAR_ATTACHMENT_ANIMATION)).floatValue();
    }

    public void setTrackedFrontAttachmentAnimation(float animation) {
        this.f_19804_.m_135381_(FRONT_ATTACHMENT_ANIMATION, (Object)Float.valueOf(animation));
    }

    public float getTrackedFrontAttachmentAnimation() {
        return ((Float)this.f_19804_.m_135370_(FRONT_ATTACHMENT_ANIMATION)).floatValue();
    }

    public void bounce() {
        this.suspensionBounceTimer = 3;
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), AutomobilitySounds.LANDING.require(), SoundSource.AMBIENT, 1.0f, 1.5f + 0.15f * (this.m_9236_().f_46441_.m_188501_() - 0.5f), true);
    }

    public static final class Displacement {
        private static final int SCAN_STEPS_PER_BLOCK = 20;
        private static final double INV_SCAN_STEPS = 0.05;
        private boolean wereAllOnGround = true;
        private float lastVertical = 0.0f;
        private float lastAngularX = 0.0f;
        private float lastAngularZ = 0.0f;
        private float currAngularX = 0.0f;
        private float currAngularZ = 0.0f;
        private float verticalTarget = 0.0f;
        private float angularXTarget = 0.0f;
        private float angularZTarget = 0.0f;
        private final List<Vec3> scanPoints = new ArrayList<Vec3>();
        public final Set<CollisionArea> otherColliders = new HashSet<CollisionArea>();

        public void preTick() {
            this.lastAngularX = this.currAngularX;
            this.lastAngularZ = this.currAngularZ;
            this.lastVertical = this.verticalTarget;
            this.currAngularX = AUtils.shift(this.currAngularX, 9.0f, this.angularXTarget);
            this.currAngularZ = AUtils.shift(this.currAngularZ, 9.0f, this.angularZTarget);
        }

        public void tick(Level world, AutomobileEntity entity, Vec3 centerPos, double yaw, double stepHeight) {
            yaw = 360.0 - yaw;
            Vec3 lowestDisplacementPos = null;
            Vec3 highestDisplacementPos = null;
            ArrayList<Vec3> scannedPoints = new ArrayList<Vec3>();
            HashSet<CollisionArea> colliders = new HashSet<CollisionArea>();
            boolean anyOnGround = false;
            boolean allOnGround = true;
            for (Vec3 scanPoint : this.scanPoints) {
                scanPoint = scanPoint.m_82524_((float)Math.toRadians(yaw));
                Vec3 pointPos = scanPoint.m_82549_(centerPos);
                colliders.clear();
                colliders.addAll(this.otherColliders);
                double scanDist = scanPoint.m_82553_();
                int heightOffset = (int)Math.ceil(scanDist);
                Cursor3D iter = new Cursor3D((int)Math.min(Math.floor(centerPos.f_82479_), Math.floor(pointPos.f_82479_)), (int)Math.floor(centerPos.f_82480_) - heightOffset, (int)Math.min(Math.floor(centerPos.f_82481_), Math.floor(pointPos.f_82481_)), (int)Math.max(Math.floor(centerPos.f_82479_), Math.floor(pointPos.f_82479_)), (int)Math.floor(centerPos.f_82480_) + heightOffset, (int)Math.max(Math.floor(centerPos.f_82481_), Math.floor(pointPos.f_82481_)));
                BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
                while (iter.m_122304_()) {
                    mpos.m_122178_(iter.m_122305_(), iter.m_122306_(), iter.m_122307_());
                    VoxelShape shape = world.m_8055_((BlockPos)mpos).m_60812_((BlockGetter)world, (BlockPos)mpos);
                    if (shape.m_83281_()) continue;
                    if (shape == Shapes.m_83144_()) {
                        colliders.add(CollisionArea.box(mpos.m_123341_(), (double)mpos.m_123342_() - 0.1, mpos.m_123343_(), mpos.m_123341_() + 1, mpos.m_123342_() + 1, mpos.m_123343_() + 1));
                        continue;
                    }
                    shape.m_83216_((double)mpos.m_123341_(), (double)mpos.m_123342_(), (double)mpos.m_123343_()).m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> colliders.add(CollisionArea.box(minX, minY - 0.1, minZ, maxX, maxY, maxZ)));
                }
                Vec3 pointDir = new Vec3(scanPoint.f_82479_, 0.0, scanPoint.f_82481_).m_82541_().m_82490_(0.05);
                double pointY = centerPos.f_82480_;
                int i = 0;
                while ((double)i < Math.ceil(scanDist * 20.0)) {
                    double pointX = centerPos.f_82479_ + (double)i * pointDir.f_82479_;
                    double pointZ = centerPos.f_82481_ + (double)i * pointDir.f_82481_;
                    pointY -= 0.07500000000000001;
                    boolean ground = false;
                    for (CollisionArea col : colliders) {
                        double hY;
                        double diff;
                        if (!col.isPointInside(pointX, pointY, pointZ) || !((diff = (hY = col.highestY(pointX, pointY, pointZ)) - pointY) < stepHeight + 0.07500000000000001)) continue;
                        pointY = hY;
                        ground = true;
                    }
                    if (ground) {
                        anyOnGround = true;
                    } else {
                        allOnGround = false;
                    }
                    ++i;
                }
                pointPos = new Vec3(pointPos.f_82479_, pointY, pointPos.f_82481_);
                if (lowestDisplacementPos == null || pointPos.f_82480_ < lowestDisplacementPos.f_82480_) {
                    lowestDisplacementPos = pointPos;
                }
                if (highestDisplacementPos == null || pointPos.f_82480_ > highestDisplacementPos.f_82480_) {
                    highestDisplacementPos = pointPos;
                }
                scannedPoints.add(pointPos);
            }
            if (allOnGround && !this.wereAllOnGround) {
                entity.bounce();
            }
            this.wereAllOnGround = allOnGround;
            if (!anyOnGround) {
                return;
            }
            this.angularXTarget = 0.0f;
            this.angularZTarget = 0.0f;
            this.verticalTarget = 0.0f;
            if (lowestDisplacementPos != null) {
                Vec3 displacementCenterPos = new Vec3(centerPos.f_82479_, (lowestDisplacementPos.f_82480_ + highestDisplacementPos.f_82480_) * 0.5, centerPos.f_82481_);
                Vec3 combinedNormals = Vec3.f_82478_;
                int normalCount = 0;
                Vec3 positiveXOffset = null;
                Vec3 negativeXOffset = null;
                Vec3 positiveZOffset = null;
                Vec3 negativeZOffset = null;
                for (Vec3 pointPos : scannedPoints) {
                    Vec3 normal;
                    Vec3 pointOffset = pointPos.m_82546_(displacementCenterPos);
                    if (pointOffset.f_82479_ > 0.0) {
                        if (positiveXOffset != null) {
                            normal = positiveXOffset.m_82537_(pointOffset).m_82541_();
                            if (normal.f_82480_ < 0.0) {
                                normal = normal.m_82548_();
                            }
                            combinedNormals = combinedNormals.m_82549_(normal);
                            ++normalCount;
                            positiveXOffset = null;
                            continue;
                        }
                        positiveXOffset = pointOffset;
                        continue;
                    }
                    if (pointOffset.f_82479_ < 0.0) {
                        if (negativeXOffset != null) {
                            normal = negativeXOffset.m_82537_(pointOffset).m_82541_();
                            if (normal.f_82480_ < 0.0) {
                                normal = normal.m_82548_();
                            }
                            combinedNormals = combinedNormals.m_82549_(normal);
                            ++normalCount;
                            negativeXOffset = null;
                            continue;
                        }
                        negativeXOffset = pointOffset;
                        continue;
                    }
                    if (pointOffset.f_82481_ > 0.0) {
                        if (positiveZOffset != null) {
                            normal = positiveZOffset.m_82537_(pointOffset).m_82541_();
                            if (normal.f_82480_ < 0.0) {
                                normal = normal.m_82548_();
                            }
                            combinedNormals = combinedNormals.m_82549_(normal);
                            ++normalCount;
                            positiveZOffset = null;
                            continue;
                        }
                        positiveZOffset = pointOffset;
                        continue;
                    }
                    if (!(pointOffset.f_82481_ < 0.0)) continue;
                    if (negativeZOffset != null) {
                        normal = negativeZOffset.m_82537_(pointOffset).m_82541_();
                        if (normal.f_82480_ < 0.0) {
                            normal = normal.m_82548_();
                        }
                        combinedNormals = combinedNormals.m_82549_(normal);
                        ++normalCount;
                        negativeZOffset = null;
                        continue;
                    }
                    negativeZOffset = pointOffset;
                }
                combinedNormals = normalCount > 0 ? combinedNormals.m_82490_((double)(1.0f / (float)normalCount)) : new Vec3(0.0, 1.0, 0.0);
                this.angularXTarget = Mth.m_14177_((float)(90.0f - (float)Math.toDegrees(Math.atan2(combinedNormals.f_82480_, combinedNormals.f_82481_))));
                this.angularZTarget = Mth.m_14177_((float)(270.0f + (float)Math.toDegrees(Math.atan2(combinedNormals.f_82480_, combinedNormals.f_82479_))));
                this.verticalTarget = (float)displacementCenterPos.m_82546_((Vec3)centerPos).f_82480_;
            }
        }

        public void applyWheelbase(WheelBase wheelBase) {
            this.scanPoints.clear();
            for (WheelBase.WheelPos pos : wheelBase.wheels) {
                this.scanPoints.add(new Vec3((double)(pos.right() / 16.0f), 0.0, (double)(pos.forward() / 16.0f)));
            }
        }

        public float getVertical(float tickDelta) {
            return Mth.m_14179_((float)tickDelta, (float)this.lastVertical, (float)this.verticalTarget);
        }

        public float getAngularX(float tickDelta) {
            return Mth.m_14189_((float)tickDelta, (float)this.lastAngularX, (float)this.currAngularX);
        }

        public float getAngularZ(float tickDelta) {
            return Mth.m_14189_((float)tickDelta, (float)this.lastAngularZ, (float)this.currAngularZ);
        }
    }
}

