/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.forge.block.render;

import io.github.foundationgames.automobility.block.model.GeometryBuilder;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.minecraftforge.common.ForgeConfig;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ForgeGeometryBuilder
implements GeometryBuilder {
    private final Matrix4f transform;
    @Nullable
    private final Direction filter;
    private final QuadBakingVertexConsumer quads;

    public ForgeGeometryBuilder(Matrix4f transform, @Nullable Direction filter, List<BakedQuad> quadPool) {
        this.transform = transform;
        this.filter = filter;
        this.quads = new QuadBakingVertexConsumer(quadPool::add);
        this.quads.setShade(true);
        this.quads.setHasAmbientOcclusion(((Boolean)ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get()).booleanValue());
    }

    @Override
    public GeometryBuilder vertex(float x, float y, float z, @Nullable Direction face, float nx, float ny, float nz, TextureAtlasSprite sprite, float u, float v) {
        return this.vertex(x, y, z, face, nx, ny, nz, sprite, u, v, -1);
    }

    @Override
    public GeometryBuilder vertex(float x, float y, float z, @Nullable Direction face, float nx, float ny, float nz, TextureAtlasSprite sprite, float u, float v, int color) {
        if (face != null) {
            face = Direction.m_252919_((Matrix4f)this.transform, (Direction)face);
        }
        if (face != this.filter) {
            return this;
        }
        Vector4f pos = new Vector4f(x - 0.5f, y, z - 0.5f, 1.0f);
        Vector4f tNormal = new Vector4f(nx, ny, nz, 1.0f);
        pos.mul((Matrix4fc)this.transform);
        tNormal.mul((Matrix4fc)this.transform);
        Vector3f normal = new Vector3f(tNormal.x(), tNormal.y(), tNormal.z());
        normal.normalize();
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        this.quads.setDirection(face != null ? face : Direction.UP);
        this.quads.setSprite(sprite);
        this.quads.m_5483_((double)(pos.x() + 0.5f), (double)pos.y(), (double)(pos.z() + 0.5f)).m_193479_(color).m_7421_(u0 + (u1 - u0) * u, v0 + (v1 - v0) * v).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        return this;
    }
}

