/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.item;

import io.github.foundationgames.automobility.automobile.AutomobileData;
import io.github.foundationgames.automobility.automobile.AutomobilePrefab;
import io.github.foundationgames.automobility.automobile.AutomobileStats;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.entity.AutomobilityEntities;
import io.github.foundationgames.automobility.item.CustomCreativeOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AutomobileItem
extends Item
implements CustomCreativeOutput {
    public static final List<AutomobilePrefab> PREFABS = new ArrayList<AutomobilePrefab>();
    private static final AutomobileData data = new AutomobileData();
    private static final AutomobileStats stats = new AutomobileStats();

    public AutomobileItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().m_5776_()) {
            ItemStack stack = context.m_43722_();
            data.read(stack.m_41698_("Automobile"));
            AutomobileEntity e = new AutomobileEntity(AutomobilityEntities.AUTOMOBILE.require(), context.m_43725_());
            Vec3 pos = context.m_43720_();
            e.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, context.m_8125_().m_122435_(), 0.0f);
            e.setComponents(data.getFrame(), data.getWheel(), data.getEngine());
            context.m_43725_().m_7967_((Entity)e);
            stack.m_41774_(1);
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        data.read(stack.m_41698_("Automobile"));
        if (Screen.m_96638_()) {
            stats.from(data.getFrame(), data.getWheel(), data.getEngine());
            stats.appendTexts(tooltip, stats);
        } else {
            if (!data.isPrefab()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.automobility.frameLabel").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)data.getFrame().getTranslationKey()).m_130940_(ChatFormatting.DARK_GREEN)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.automobility.wheelLabel").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)data.getWheel().getTranslationKey()).m_130940_(ChatFormatting.DARK_GREEN)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.automobility.engineLabel").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237115_((String)data.getEngine().getTranslationKey()).m_130940_(ChatFormatting.DARK_GREEN)));
            }
            tooltip.add((Component)Component.m_237115_((String)"tooltip.automobility.shiftForStats").m_130940_(ChatFormatting.GOLD));
        }
    }

    public static void addPrefabs(AutomobilePrefab ... prefabs) {
        PREFABS.addAll(Arrays.asList(prefabs));
    }

    @Override
    public void provideCreativeOutput(CreativeModeTab.Output output) {
        for (AutomobilePrefab prefab : PREFABS) {
            output.m_246342_(prefab.toStack());
        }
    }
}

