/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerWidget;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class SelectController<T>
implements Controller<Integer> {
    private final Option<Integer> option;
    private final BiFunction<Integer, T, Component> valueFormatter;
    private List<T> values;
    private final List<T> refValues;
    private List<Component> formattedValues;

    public SelectController(Option<Integer> option, List<T> values, BiFunction<Integer, T, Component> valueFormatter) {
        this.option = option;
        this.valueFormatter = valueFormatter;
        this.refValues = values;
        this.updateValues();
    }

    public void updateValues() {
        this.values = ImmutableList.copyOf(this.refValues);
        this.formattedValues = new ArrayList<Component>();
        for (int i = 0; i < this.values.size(); ++i) {
            this.formattedValues.add(this.valueFormatter.apply(i, (Integer)this.values.get(i)));
        }
    }

    public void cycle(int direction) {
        int index = (Integer)this.option.pendingValue();
        if (direction > 0) {
            index = (index + 1) % this.values.size();
        } else if (direction < 0) {
            index = index <= 0 ? this.values.size() - 1 : index - 1;
        }
        this.option.requestSet((Object)index);
    }

    public List<Component> formatValues() {
        this.formattedValues.set(this.getSelectedIndex(), this.formatValue());
        return ImmutableList.copyOf(this.formattedValues);
    }

    public int getSelectedIndex() {
        return (Integer)this.option().pendingValue();
    }

    public Component formatValue() {
        int index = (Integer)this.option.pendingValue();
        return this.valueFormatter.apply(index, (Integer)this.values.get(index));
    }

    public Option<Integer> option() {
        return this.option;
    }

    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new SelectElement(this, screen, widgetDimension);
    }

    public static class SelectElement<T>
    extends ControllerWidget<SelectController<T>> {
        private final int ARROW_SPACE = 8;
        private Dimension<Integer> expandedBounds;
        private Dimension<Integer> arrowBounds;
        private boolean mouseInteracted;
        private long hoveringStart = 0L;
        protected static final Component UP_ARROW = Component.m_237113_((String)"\u25b2");
        protected static final Component DOWN_ARROW = Component.m_237113_((String)"\u25bc");

        public SelectElement(SelectController<T> control, YACLScreen screen, Dimension<Integer> dim) {
            super(control, screen, dim);
            this.updateValues();
        }

        public void updateValues() {
            this.updateExpandedBounds();
        }

        protected void updateExpandedBounds() {
            Dimension dim = this.getDimension();
            int lines = this.getLineCount();
            int lineHeight = this.getLineHeight();
            int yStart = (Integer)dim.yLimit() - 1;
            int ySpan = lines * lineHeight + 1;
            this.expandedBounds = Dimension.ofInt((int)((Integer)dim.x()), (int)yStart, (int)((Integer)dim.width()), (int)ySpan);
        }

        protected int getLineCount() {
            return Math.min(((SelectController)this.control).formatValues().size(), 5);
        }

        protected int getLineHeight() {
            Objects.requireNonNull(this.textRenderer);
            return 9 + this.getLinePadding();
        }

        protected int getLinePadding() {
            return 2;
        }

        public void setDimension(Dimension<Integer> dim) {
            super.setDimension(dim);
            this.updateExpandedBounds();
            this.updateArrowBounds();
        }

        protected void updateArrowBounds() {
            Dimension dim = this.getDimension();
            this.arrowBounds = Dimension.ofInt((int)((Integer)dim.xLimit() - 8 - 2 * this.getXPadding()), (int)((Integer)dim.y()), (int)(8 + 2 * this.getXPadding()), (int)((Integer)dim.height()));
        }

        public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            super.m_88315_(context, mouseX, mouseY, delta);
            if (this.isHovered() && this.hoveringStart == 0L) {
                this.hoveringStart = Util.m_137574_();
            } else if (!this.isHovered()) {
                this.hoveringStart = 0L;
            }
            if (this.mouseInteracted && !this.isHovered()) {
                this.mouseInteracted = false;
            }
            this.drawList(context);
        }

        protected void drawList(GuiGraphics context) {
            if (!this.isMouseInteracted() && !this.m_93696_() || !this.isAvailable()) {
                return;
            }
            context.m_280168_().m_85836_();
            context.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            List<Component> values = ((SelectController)this.control).formatValues();
            Dimension<Integer> dim = this.getExpandedBounds();
            int padding = this.getLinePadding();
            int lines = this.getLineCount();
            int lineHeight = this.getLineHeight();
            int selected = ((SelectController)this.control).getSelectedIndex();
            int indexFrom = Mth.m_14045_((int)(selected - lines / 2), (int)0, (int)(values.size() - lines));
            context.m_280509_((Integer)dim.x() + 1, (Integer)dim.y() + 1, (Integer)dim.xLimit() - 1, (Integer)dim.yLimit() - 1, -1342177280);
            this.drawOutline(context, (Integer)dim.x(), (Integer)dim.y(), (Integer)dim.xLimit(), (Integer)dim.yLimit(), 1, -1);
            for (int line = 0; line < lines; ++line) {
                int i = indexFrom + line;
                Component text = values.get(i);
                int x = (Integer)dim.xLimit() - this.textRenderer.m_92852_((FormattedText)text) - this.getXPadding();
                int y = (Integer)dim.y() + padding + lineHeight * line;
                if (selected == i) {
                    context.m_280509_(((Integer)dim.x()).intValue(), y - padding, ((Integer)dim.xLimit()).intValue(), y + lineHeight - 1, -2130706433);
                }
                context.m_280430_(this.textRenderer, text, x, y, this.getValueColor());
            }
            context.m_280168_().m_85849_();
        }

        public boolean isMouseInteracted() {
            return this.mouseInteracted;
        }

        public void setMouseInteracted(boolean mouseInteracted) {
            this.mouseInteracted = mouseInteracted;
        }

        public Dimension<Integer> getExpandedBounds() {
            return this.expandedBounds;
        }

        protected void drawHoveredControl(GuiGraphics context, int mouseX, int mouseY, float delta) {
            Dimension dim = this.getDimension();
            PoseStack matrices = context.m_280168_();
            matrices.m_85836_();
            int arrowWidth = this.textRenderer.m_92852_((FormattedText)UP_ARROW);
            matrices.m_252880_((float)((Integer)this.getDimension().xLimit() - this.getXPadding()) - 4.0f, (float)((Integer)dim.y()).intValue() + (float)((Integer)dim.height()).intValue() / 2.0f, 0.0f);
            matrices.m_85841_(1.5f, 1.0f, 1.0f);
            int hoveredArrow = this.getHoveredArrow(mouseX, mouseY);
            int n = -arrowWidth / 2;
            Objects.requireNonNull(this.textRenderer);
            context.m_280614_(this.textRenderer, UP_ARROW, n, -9 + 1, -12566464, false);
            context.m_280614_(this.textRenderer, DOWN_ARROW, -arrowWidth / 2, 1, -12566464, false);
            int n2 = -arrowWidth / 2;
            Objects.requireNonNull(this.textRenderer);
            context.m_280614_(this.textRenderer, UP_ARROW, n2, -9 + 2, hoveredArrow == -1 ? -1 : -4144960, false);
            context.m_280614_(this.textRenderer, DOWN_ARROW, -arrowWidth / 2, 0, hoveredArrow == 1 ? -1 : -4144960, false);
            matrices.m_85849_();
        }

        protected int getHoveredArrow(int mouseX, int mouseY) {
            if (!this.arrowBounds.isPointInside((Number)mouseX, (Number)mouseY)) {
                return 0;
            }
            boolean upper = (float)(mouseY - (Integer)this.arrowBounds.y()) / (float)((Integer)this.arrowBounds.height()).intValue() < 0.5f;
            return upper ? -1 : 1;
        }

        protected void drawValueText(GuiGraphics context, int mouseX, int mouseY, float delta) {
            context.m_280168_().m_85836_();
            if (this.isHovered()) {
                context.m_280168_().m_252880_((float)(-8 - this.getXPadding()), 0.0f, 0.0f);
            }
            super.drawValueText(context, mouseX, mouseY, delta);
            context.m_280168_().m_85849_();
        }

        protected Component getValueText() {
            Component valueText = ((SelectController)this.control).formatValue();
            int maxWidth = (Integer)this.getDimension().width() - this.getControlWidth() - this.getXPadding() - 7 - 8;
            String shortened = GuiUtils.shortenString((String)valueText.getString(), (Font)this.textRenderer, (int)maxWidth, (String)"...");
            return Component.m_237113_((String)shortened).m_6270_(valueText.m_7383_());
        }

        protected int getHoveredControlWidth() {
            return this.getUnhoveredControlWidth();
        }

        protected int getUnhoveredControlWidth() {
            return this.textRenderer.m_92852_((FormattedText)(((SelectController)this.control).option().changed() ? this.modifiedOptionName : ((SelectController)this.control).option().name()));
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.m_5953_(mouseX, mouseY) || button != 0 && button != 1 || !this.isAvailable()) {
                return false;
            }
            int hoveredArrow = this.getHoveredArrow((int)mouseX, (int)mouseY);
            if (hoveredArrow != 0) {
                this.cycle(hoveredArrow);
                this.setMouseInteracted(true);
                return true;
            }
            this.playDownSound();
            this.setMouseInteracted(!this.isMouseInteracted());
            return true;
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            Dimension dim = this.getDimension();
            if (dim == null) {
                return false;
            }
            if (dim.isPointInside((Number)((int)mouseX), (Number)((int)mouseY))) {
                return true;
            }
            Dimension<Integer> expanded = this.getExpandedBounds();
            return this.m_93696_() && expanded.isPointInside((Number)((int)mouseX), (Number)((int)mouseY));
        }

        public void cycle(int direction) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)2.0f, (float)0.1f));
            ((SelectController)this.control).cycle(direction);
        }

        public boolean m_6050_(double mouseX, double mouseY, double verticalAmount) {
            if (!this.m_5953_(mouseX, mouseY) || !this.isAvailable()) {
                return false;
            }
            if (this.hoveringStart == 0L || Util.m_137574_() - this.hoveringStart <= 100L) {
                return false;
            }
            if (verticalAmount == 0.0) {
                return false;
            }
            this.cycle(verticalAmount > 0.0 ? -1 : 1);
            this.setMouseInteracted(true);
            return true;
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (!this.focused) {
                return false;
            }
            switch (keyCode) {
                case 263: {
                    this.cycle(-1);
                    break;
                }
                case 262: {
                    this.cycle(1);
                    break;
                }
                default: {
                    return false;
                }
            }
            this.m_93692_(true);
            return true;
        }
    }
}

