/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.telemetry;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.gui.IssueReportScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class IssueReportManager {
    private static final long MAX_SHOW_INTERVAL = 10000L;
    private static long lastShowTime = 0L;
    private static IssueReportScreen queuedScreen = null;

    public static boolean enabled() {
        return ConfigManager.instance().issueReportEnabled && !BetterCloudsStatic.IS_DEV;
    }

    public static boolean handle(Throwable e, String details) {
        if (!IssueReportManager.enabled()) {
            return false;
        }
        long time = System.currentTimeMillis();
        if (time - lastShowTime < 10000L) {
            return false;
        }
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91080_ instanceof IssueReportScreen || queuedScreen != null) {
            return false;
        }
        lastShowTime = time;
        ConfigManager.instance().enabled = false;
        IssueReportScreen screen = new IssueReportScreen(e, details);
        client.execute(() -> {
            if (client.f_91080_ == null) {
                client.m_91152_((Screen)screen);
            } else if (!(client.f_91080_ instanceof IssueReportScreen)) {
                queuedScreen = screen;
            }
        });
        return true;
    }

    public static Screen popQueuedScreen() {
        IssueReportScreen tmp = queuedScreen;
        queuedScreen = null;
        return tmp;
    }
}

