/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.screens;

import java.util.NavigableMap;
import java.util.TreeMap;
import net.lyivx.ls_furniture.common.blocks.entity.TombstoneBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class TombstoneScreen
extends Screen {
    private static final Component SCREEN_NAME = Component.m_237115_((String)"container.ls_furniture.tombstone.edit");
    private final TombstoneBlockEntity tombstoneBlockEntity;
    private int selectedLine = 0;
    private TextFieldHelper[] textFieldHelpers;
    private String[] lines;
    private float[] textSizes;
    private static final int DECIMAL_PLACES = 1;
    private static final float MAX_TEXT_SIZE = 2.0f;
    private static final float MIN_TEXT_SIZE = 0.5f;
    private static final NavigableMap<Float, Integer> SIZE_TO_MAX_LENGTH = new TreeMap<Float, Integer>();

    public TombstoneScreen(TombstoneBlockEntity tombstoneBlockEntity) {
        super(SCREEN_NAME);
        this.tombstoneBlockEntity = tombstoneBlockEntity;
        this.lines = (String[])tombstoneBlockEntity.getLines().clone();
        this.textSizes = (float[])tombstoneBlockEntity.getTextSizes().clone();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.textFieldHelpers = new TextFieldHelper[4];
        for (int i = 0; i < 4; ++i) {
            int lineIndex = i;
            this.textFieldHelpers[i] = new TextFieldHelper(() -> this.lines[lineIndex], s -> {
                int maxLength = this.getMaxLengthForSize(this.textSizes[lineIndex]);
                if (s.length() > maxLength) {
                    s = s.substring(0, maxLength);
                }
                this.lines[lineIndex] = s;
                this.updateTombstone();
            }, TextFieldHelper.m_95153_((Minecraft)this.f_96541_), TextFieldHelper.m_95182_((Minecraft)this.f_96541_), s -> s.length() <= this.getMaxLengthForSize(this.textSizes[lineIndex]));
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> this.changeTextSize(lineIndex, 0.1f)).m_252987_(this.f_96543_ / 2 + 60, 65 + i * 20, 20, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), button -> this.changeTextSize(lineIndex, -0.1f)).m_252987_(this.f_96543_ / 2 + 105, 65 + i * 20, 20, 20).m_253136_());
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.onDone()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120, 200, 20).m_253136_());
    }

    private int getMaxLengthForSize(float size) {
        return SIZE_TO_MAX_LENGTH.ceilingEntry(Float.valueOf(size)).getValue();
    }

    private void changeTextSize(int lineIndex, float delta) {
        float newSize = Math.max(0.5f, Math.min(2.0f, this.textSizes[lineIndex] + delta));
        int newMaxLength = this.getMaxLengthForSize(newSize);
        this.lines[lineIndex] = this.truncateString(this.lines[lineIndex], newMaxLength);
        this.textFieldHelpers[lineIndex].m_95193_();
        this.textSizes[lineIndex] = newSize;
        this.updateTombstone();
    }

    private void updateTombstone() {
        this.tombstoneBlockEntity.setLines(this.lines);
        for (int i = 0; i < 4; ++i) {
            this.tombstoneBlockEntity.setTextSize(i, this.textSizes[i]);
        }
        this.tombstoneBlockEntity.m_6596_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.renderBlock(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 35, 0xFFFFFF);
        for (int i = 0; i < 4; ++i) {
            this.renderLine(guiGraphics, i);
            String sizeText = String.format("%.1f", Float.valueOf(this.textSizes[i]));
            int x = this.f_96543_ / 2 + 93;
            int y = 72 + i * 20;
            guiGraphics.m_280137_(this.f_96547_, sizeText, x, y, 0xFFFFFF);
        }
        this.renderCursor(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderBlock(GuiGraphics guiGraphics) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockState blockState = this.tombstoneBlockEntity.m_58900_();
        if (!blockState.m_60795_()) {
            guiGraphics.m_280168_().m_85836_();
            float blockX = (float)this.f_96543_ / 1.7325f;
            float blockY = (float)this.f_96544_ * 0.1875f;
            float blockZ = 100.0f;
            guiGraphics.m_280168_().m_252880_(blockX, blockY, blockZ);
            float scale = 100.0f;
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            Quaternionf rotation = new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(180.0), (float)Math.toRadians(180.0));
            Quaternionf northRotation = new Quaternionf().rotateXYZ(0.0f, 0.0f, 0.0f);
            Quaternionf southRotation = new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(180.0), 0.0f);
            Quaternionf westRotation = new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(270.0), 0.0f);
            Quaternionf eastRotation = new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(90.0), 0.0f);
            guiGraphics.m_280168_().m_252781_(rotation);
            Direction side = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            switch (side) {
                case NORTH: {
                    guiGraphics.m_280168_().m_252781_(northRotation);
                    guiGraphics.m_280168_().m_252880_(-1.0f, -1.0f, 0.0f);
                    break;
                }
                case SOUTH: {
                    guiGraphics.m_280168_().m_252781_(southRotation);
                    guiGraphics.m_280168_().m_252880_(0.0f, -1.0f, 0.0f);
                    break;
                }
                case WEST: {
                    guiGraphics.m_280168_().m_252781_(westRotation);
                    guiGraphics.m_280168_().m_252880_(0.0f, -1.0f, 0.0f);
                    break;
                }
                case EAST: {
                    guiGraphics.m_280168_().m_252781_(eastRotation);
                    guiGraphics.m_280168_().m_252880_(0.0f, -1.0f, -1.0f);
                }
            }
            try {
                blockRenderer.m_110912_(blockState, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_);
            }
            catch (Exception e) {
                System.out.println("Error rendering block: " + e.getMessage());
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void renderLine(GuiGraphics guiGraphics, int lineIndex) {
        String line = this.lines[lineIndex];
        if (line != null) {
            float scale = this.textSizes[lineIndex];
            int lineWidth = this.f_96547_.m_92895_(line);
            int centerX = this.f_96543_ / 2;
            int x = centerX - (int)((float)lineWidth * scale / 2.0f);
            int y = 70 + lineIndex * 20;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)x, (float)y, 200.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280056_(this.f_96547_, line, 0, 0, this.tombstoneBlockEntity.getColor().m_41071_(), false);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void renderCursor(GuiGraphics guiGraphics) {
        if (this.tombstoneBlockEntity.isEditable() && this.f_96541_.f_91074_.f_19797_ / 6 % 2 == 0) {
            String currentLine = this.lines[this.selectedLine];
            float scale = this.textSizes[this.selectedLine];
            int lineWidth = this.f_96547_.m_92895_(currentLine);
            int centerX = this.f_96543_ / 2;
            int y = 70 + this.selectedLine * 20;
            TextFieldHelper currentHelper = this.textFieldHelpers[this.selectedLine];
            int cursorPosition = Math.min(currentHelper.m_95194_(), currentLine.length());
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)centerX, (float)y, 200.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            String textUpToCursor = currentLine.substring(0, cursorPosition);
            int unscaledTextWidthUpToCursor = this.f_96547_.m_92895_(textUpToCursor);
            int centeredTextX = -lineWidth / 2;
            int cursorX = centeredTextX + unscaledTextWidthUpToCursor;
            guiGraphics.m_280056_(this.f_96547_, "_", cursorX, 0, this.tombstoneBlockEntity.getColor().m_41071_(), false);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private String truncateString(String input, int maxLength) {
        return input.length() > maxLength ? input.substring(0, maxLength) : input;
    }

    public boolean m_5534_(char c, int modifiers) {
        if (this.tombstoneBlockEntity.isEditable() && this.textFieldHelpers != null) {
            TextFieldHelper currentHelper = this.textFieldHelpers[this.selectedLine];
            int maxLength = this.getMaxLengthForSize(this.textSizes[this.selectedLine]);
            if (this.lines[this.selectedLine].length() >= maxLength) {
                return false;
            }
            boolean result = currentHelper.m_95143_(c);
            if (result) {
                this.lines[this.selectedLine] = this.truncateString(this.lines[this.selectedLine], maxLength);
                this.updateTombstone();
            }
            return result;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (int i = 0; i < 4; ++i) {
                int y = 70 + i * 20;
                if (!(mouseY >= (double)y) || !(mouseY < (double)(y + 20)) || !(mouseX >= (double)(this.f_96543_ / 2 - 90)) || !(mouseX < (double)(this.f_96543_ / 2 + 60))) continue;
                this.setSelectedLine(i);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void setSelectedLine(int line) {
        this.selectedLine = line;
        this.textFieldHelpers[this.selectedLine].m_95193_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.tombstoneBlockEntity.isEditable() && this.textFieldHelpers != null) {
            TextFieldHelper currentHelper = this.textFieldHelpers[this.selectedLine];
            if (keyCode == 257 || keyCode == 335) {
                this.setSelectedLine((this.selectedLine + 1) % 4);
                return true;
            }
            boolean result = currentHelper.m_95145_(keyCode);
            if (result) {
                int maxLength = this.getMaxLengthForSize(this.textSizes[this.selectedLine]);
                this.lines[this.selectedLine] = this.truncateString(this.lines[this.selectedLine], maxLength);
                this.updateTombstone();
            }
            return result || super.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void onDone() {
        this.tombstoneBlockEntity.setEditable(true);
        this.updateTombstone();
        this.f_96541_.m_91152_(null);
    }

    public boolean m_7043_() {
        return false;
    }

    static {
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(2.0f), 6);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(1.9f), 6);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(1.8f), 6);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(1.7f), 7);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(1.6f), 7);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(1.5f), 8);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(1.4f), 8);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(1.3f), 9);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(1.2f), 10);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(1.1f), 11);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(1.0f), 12);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(0.9f), 13);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(0.8f), 15);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(0.7f), 17);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(0.6f), 20);
        SIZE_TO_MAX_LENGTH.put(Float.valueOf(0.5f), 24);
    }
}

