/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.screens.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lyivx.ls_furniture.client.screens.widgets.NoOpTickAccess;
import net.lyivx.ls_furniture.common.blocks.ModBedBlock;
import net.lyivx.ls_furniture.common.blocks.PlatformBlock;
import net.lyivx.ls_furniture.common.blocks.TableBlock;
import net.lyivx.ls_furniture.common.blocks.WardrobeBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import org.jetbrains.annotations.Nullable;

public class FakeLevel
extends Level {
    private final Map<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();

    public FakeLevel() {
        super((WritableLevelData)new ClientLevel.ClientLevelData(Difficulty.NORMAL, false, false), Level.f_46428_, Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_9598_() : null, Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_204156_() : null, () -> null, true, false, 0L, 0);
    }

    public RecipeManager m_7465_() {
        return null;
    }

    public int m_141928_() {
        return 256;
    }

    public int m_141937_() {
        return 0;
    }

    public int m_151558_() {
        return this.m_141928_() + this.m_141937_();
    }

    public int m_7445_() {
        return 0;
    }

    public boolean m_45752_(BlockState state, BlockPos pos, CollisionContext context) {
        return true;
    }

    public float m_220419_(BlockPos pos) {
        return 0.0f;
    }

    public void m_6289_(BlockPos pos, Block block) {
        BlockState state = this.m_8055_(pos);
        for (Direction direction : Direction.values()) {
            BlockState updatedState;
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = this.m_8055_(neighborPos);
            if (neighborState == (updatedState = neighborState.m_60728_(direction.m_122424_(), state, (LevelAccessor)this, neighborPos, pos))) continue;
            this.m_6933_(neighborPos, updatedState, 3, 512);
        }
    }

    public BlockState m_8055_(BlockPos pos) {
        return this.blocks.getOrDefault(pos, Blocks.f_50016_.m_49966_());
    }

    public FluidState m_6425_(BlockPos pos) {
        BlockState blockState = this.m_8055_(pos);
        return blockState.m_60819_();
    }

    public void m_262808_(@Nullable Player player, double x, double y, double z, Holder<SoundEvent> sound, SoundSource source, float volume, float pitch, long seed) {
    }

    public void m_213890_(@Nullable Player player, Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public boolean m_6933_(BlockPos pos, BlockState state, int flags, int recursionLeft) {
        if (recursionLeft <= 0) {
            return false;
        }
        BlockState oldState = this.m_8055_(pos);
        if (oldState == state) {
            return false;
        }
        this.blocks.put(pos, state);
        if ((flags & 2) != 0) {
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.m_121945_(direction);
                BlockState neighborState = this.m_8055_(neighborPos);
                neighborState.m_60690_((Level)this, neighborPos, oldState.m_60734_(), pos, false);
            }
        }
        return true;
    }

    public void renderBlocks(PoseStack poseStack) {
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher dispatcher = mc.m_91289_();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            poseStack.m_85836_();
            poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            dispatcher.m_110912_(state, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
        bufferSource.m_109911_();
    }

    public void setBlocksWithConnections(BlockState state, List<BlockPos> positions) {
        this.clear();
        for (BlockPos pos : positions) {
            this.m_6933_(pos, state, 3, 512);
        }
        HashSet<BlockPos> updatePositions = new HashSet<BlockPos>(positions);
        for (BlockPos pos : positions) {
            for (Direction direction : Direction.values()) {
                updatePositions.add(pos.m_121945_(direction));
            }
        }
        for (BlockPos pos : updatePositions) {
            if (!this.blocks.containsKey(pos)) continue;
            this.updateBlockState(pos);
        }
        if (state.m_60734_() instanceof FenceBlock) {
            this.applyFenceConfigurations(positions);
        } else if (state.m_60734_() instanceof TableBlock) {
            this.applyTableConfigurations(positions);
        } else if (state.m_60734_() instanceof PlatformBlock) {
            this.applyPlatformConfigurations(positions);
        }
    }

    private void applyFenceConfigurations(List<BlockPos> positions) {
        for (BlockPos pos : positions) {
            BlockState state = this.m_8055_(pos);
            if (!(state.m_60734_() instanceof FenceBlock)) continue;
            FenceConfiguration config = this.getFenceConfigurationForPosition(pos, positions);
            this.m_6933_(pos, config.applyToBlockState(state), 3, 512);
        }
    }

    private FenceConfiguration getFenceConfigurationForPosition(BlockPos pos, List<BlockPos> allPositions) {
        EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (!allPositions.contains(pos.m_121945_(dir))) continue;
            connections.add(dir);
        }
        switch (connections.size()) {
            case 0: {
                return FenceConfiguration.SINGLE;
            }
            case 1: {
                Direction dir = (Direction)connections.iterator().next();
                return FenceConfiguration.valueOf((String)"NORTH_SOUTH").connections.contains(dir) ? FenceConfiguration.NORTH_SOUTH : FenceConfiguration.EAST_WEST;
            }
            case 2: {
                if (connections.contains(Direction.NORTH) && connections.contains(Direction.SOUTH)) {
                    return FenceConfiguration.NORTH_SOUTH;
                }
                if (connections.contains(Direction.EAST) && connections.contains(Direction.WEST)) {
                    return FenceConfiguration.EAST_WEST;
                }
                for (FenceConfiguration config : FenceConfiguration.values()) {
                    if (!config.connections.equals(connections)) continue;
                    return config;
                }
                break;
            }
            case 3: {
                for (FenceConfiguration config : FenceConfiguration.values()) {
                    if (!config.connections.equals(connections)) continue;
                    return config;
                }
                break;
            }
            case 4: {
                return FenceConfiguration.CROSS;
            }
        }
        return FenceConfiguration.SINGLE;
    }

    private BlockState updateFenceState(BlockPos pos, BlockState fenceState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = this.m_8055_(neighborPos);
            boolean shouldConnect = this.canFenceConnectTo(fenceState, neighborState, direction);
            fenceState = (BlockState)fenceState.m_61124_((Property)FakeLevel.getFenceProperty(direction), (Comparable)Boolean.valueOf(shouldConnect));
        }
        return fenceState;
    }

    static BooleanProperty getFenceProperty(Direction direction) {
        switch (direction) {
            case NORTH: {
                return FenceBlock.f_52309_;
            }
            case EAST: {
                return FenceBlock.f_52310_;
            }
            case SOUTH: {
                return FenceBlock.f_52311_;
            }
            case WEST: {
                return FenceBlock.f_52312_;
            }
        }
        throw new IllegalArgumentException("Invalid horizontal direction: " + String.valueOf(direction));
    }

    private void applyTableConfigurations(List<BlockPos> positions) {
        for (BlockPos pos : positions) {
            BlockState state = this.m_8055_(pos);
            if (!(state.m_60734_() instanceof TableBlock)) continue;
            this.m_6933_(pos, this.updateTableState(pos, state), 3, 512);
        }
    }

    private BlockState updateTableState(BlockPos pos, BlockState tableState) {
        boolean north = this.validTableConnection(this.m_8055_(pos.m_122012_()));
        boolean east = this.validTableConnection(this.m_8055_(pos.m_122029_()));
        boolean south = this.validTableConnection(this.m_8055_(pos.m_122019_()));
        boolean west = this.validTableConnection(this.m_8055_(pos.m_122024_()));
        boolean leg1 = !north && !east || north && east && !this.validTableConnection(this.m_8055_(pos.m_122012_().m_122029_()));
        boolean leg2 = !east && !south || east && south && !this.validTableConnection(this.m_8055_(pos.m_122019_().m_122029_()));
        boolean leg3 = !south && !west || south && west && !this.validTableConnection(this.m_8055_(pos.m_122019_().m_122024_()));
        boolean leg4 = !north && !west || north && west && !this.validTableConnection(this.m_8055_(pos.m_122012_().m_122024_()));
        return (BlockState)((BlockState)((BlockState)((BlockState)tableState.m_61124_((Property)TableBlock.LEG1, (Comparable)Boolean.valueOf(leg1))).m_61124_((Property)TableBlock.LEG2, (Comparable)Boolean.valueOf(leg2))).m_61124_((Property)TableBlock.LEG3, (Comparable)Boolean.valueOf(leg3))).m_61124_((Property)TableBlock.LEG4, (Comparable)Boolean.valueOf(leg4));
    }

    private boolean validTableConnection(BlockState state) {
        return state.m_60734_() instanceof TableBlock;
    }

    private static BooleanProperty getTableProperty(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> TableBlock.LEG1;
            case Direction.EAST -> TableBlock.LEG2;
            case Direction.SOUTH -> TableBlock.LEG3;
            case Direction.WEST -> TableBlock.LEG4;
            default -> throw new IllegalArgumentException("Invalid horizontal direction: " + String.valueOf(direction));
        };
    }

    private void applyPlatformConfigurations(List<BlockPos> positions) {
        for (BlockPos pos : positions) {
            BlockState state = this.m_8055_(pos);
            if (!(state.m_60734_() instanceof PlatformBlock)) continue;
            this.m_6933_(pos, this.updatePlatformState(pos, state), 3, 512);
        }
    }

    private BlockState updatePlatformState(BlockPos pos, BlockState platformState) {
        boolean north = this.validPlatformConnection(this.m_8055_(pos.m_122012_()));
        boolean east = this.validPlatformConnection(this.m_8055_(pos.m_122029_()));
        boolean south = this.validPlatformConnection(this.m_8055_(pos.m_122019_()));
        boolean west = this.validPlatformConnection(this.m_8055_(pos.m_122024_()));
        boolean northPlatform = !north || !this.validPlatformConnection(this.m_8055_(pos.m_122012_().m_122019_()));
        boolean eastPlatform = !east || !this.validPlatformConnection(this.m_8055_(pos.m_122029_().m_122024_()));
        boolean southPlatform = !south || !this.validPlatformConnection(this.m_8055_(pos.m_122019_().m_122012_()));
        boolean westPlatform = !west || !this.validPlatformConnection(this.m_8055_(pos.m_122024_().m_122029_()));
        return (BlockState)((BlockState)((BlockState)((BlockState)platformState.m_61124_((Property)PlatformBlock.NORTH_PLATFORM, (Comparable)Boolean.valueOf(northPlatform))).m_61124_((Property)PlatformBlock.EAST_PLATFORM, (Comparable)Boolean.valueOf(eastPlatform))).m_61124_((Property)PlatformBlock.SOUTH_PLATFORM, (Comparable)Boolean.valueOf(southPlatform))).m_61124_((Property)PlatformBlock.WEST_PLATFORM, (Comparable)Boolean.valueOf(westPlatform));
    }

    private boolean validPlatformConnection(BlockState state) {
        return state.m_60734_() instanceof PlatformBlock;
    }

    private static BooleanProperty getPlatformProperty(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> PlatformBlock.NORTH_PLATFORM;
            case Direction.EAST -> PlatformBlock.EAST_PLATFORM;
            case Direction.SOUTH -> PlatformBlock.SOUTH_PLATFORM;
            case Direction.WEST -> PlatformBlock.WEST_PLATFORM;
            default -> throw new IllegalArgumentException("Invalid horizontal direction: " + String.valueOf(direction));
        };
    }

    public void setBlocksWithRotation(BlockState state, List<BlockPos> positions, List<Direction> facings) {
        this.clear();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(positions);
        for (int i = 0; i < posList.size(); ++i) {
            BlockPos pos = (BlockPos)posList.get(i);
            BlockState blockState = state;
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                Direction facing = i < facings.size() ? facings.get(i) : facings.get(facings.size() - 1);
                blockState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
            }
            if (state.m_60734_() instanceof ModBedBlock) {
                if (blockState.m_61138_((Property)BlockStateProperties.f_61391_)) {
                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61391_, (Comparable)(i == 0 ? BedPart.HEAD : BedPart.FOOT));
                }
            } else if (state.m_60734_() instanceof WardrobeBlock) {
                if (blockState.m_61138_(WardrobeBlock.MODEL_TYPE)) {
                    blockState = (BlockState)blockState.m_61124_(WardrobeBlock.MODEL_TYPE, (Comparable)((Object)(i == 0 ? WardrobeBlock.WardrobeModelType.BOTTOM : WardrobeBlock.WardrobeModelType.TOP)));
                }
            } else if (state.m_60734_() instanceof DoorBlock) {
                if (blockState.m_61138_((Property)BlockStateProperties.f_61401_)) {
                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)(i == 0 ? DoubleBlockHalf.LOWER : DoubleBlockHalf.UPPER));
                }
                if (i == 0) {
                    this.m_6933_(pos.m_7495_(), Blocks.f_50375_.m_49966_(), 3, 512);
                }
            }
            this.m_6933_(pos, blockState, 3, 512);
        }
        HashSet<BlockPos> updatePositions = new HashSet<BlockPos>(positions);
        for (BlockPos pos : positions) {
            for (Direction direction : Direction.values()) {
                updatePositions.add(pos.m_121945_(direction));
            }
        }
        for (BlockPos pos : updatePositions) {
            if (!this.blocks.containsKey(pos)) continue;
            this.updateBlockState(pos);
        }
    }

    private void updateBlockState(BlockPos pos) {
        BlockState currentState;
        BlockState newState = currentState = this.m_8055_(pos);
        if (currentState.m_60734_() instanceof FenceBlock) {
            newState = this.updateFenceState(pos, currentState);
        } else if (currentState.m_60734_() instanceof TableBlock) {
            newState = this.updateTableState(pos, currentState);
        } else if (currentState.m_60734_() instanceof PlatformBlock) {
            newState = this.updatePlatformState(pos, currentState);
        } else {
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.m_121945_(direction);
                BlockState neighborState = this.m_8055_(neighborPos);
                newState = newState.m_60728_(direction, neighborState, (LevelAccessor)this, pos, neighborPos);
            }
        }
        if (newState != currentState) {
            this.m_6933_(pos, newState, 3, 512);
        }
    }

    private void updateBlockStateWithConnections(BlockPos pos) {
        BlockState currentState;
        BlockState newState = currentState = this.m_8055_(pos);
        Block block = currentState.m_60734_();
        if (block instanceof FenceBlock) {
            newState = this.updateFenceState(pos, currentState);
        } else if (block instanceof TableBlock) {
            newState = this.updateTableState(pos, currentState);
        } else if (block instanceof PlatformBlock) {
            newState = this.updatePlatformState(pos, currentState);
        }
        if (newState != currentState) {
            this.m_7731_(pos, newState, 3);
        }
    }

    private boolean canFenceConnectTo(BlockState fenceState, BlockState neighborState, Direction direction) {
        Block neighborBlock = neighborState.m_60734_();
        boolean isSameFence = this.isSameFence(neighborState);
        boolean isFenceGate = neighborBlock instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)neighborState, (Direction)direction.m_122424_());
        boolean isSideSolid = neighborState.m_60783_((BlockGetter)this, BlockPos.f_121853_.m_121945_(direction), direction.m_122424_());
        return !Block.m_152463_((BlockState)neighborState) && (isSideSolid || isSameFence || isFenceGate);
    }

    private boolean isSameFence(BlockState state) {
        return state.m_204336_(BlockTags.f_13039_) && state.m_204336_(BlockTags.f_13098_) == this.m_8055_(BlockPos.f_121853_).m_204336_(BlockTags.f_13098_);
    }

    private boolean checkTableConnection(BlockPos pos) {
        return this.m_8055_(pos).m_60734_() instanceof TableBlock;
    }

    private boolean checkPlatformConnection(BlockPos pos) {
        return this.m_8055_(pos).m_60734_() instanceof PlatformBlock;
    }

    public void clear() {
        this.blocks.clear();
    }

    public void m_6263_(@Nullable Player player, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch) {
    }

    public void m_7106_(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void m_5898_(@Nullable Player player, int type, BlockPos pos, int data) {
    }

    public void m_214171_(GameEvent event, Vec3 position, GameEvent.Context context) {
    }

    public List<? extends Player> m_6907_() {
        return Collections.emptyList();
    }

    public float m_7717_(Direction direction, boolean shade) {
        if (!shade) {
            return 1.0f;
        }
        switch (direction) {
            case DOWN: {
                return 0.5f;
            }
            case UP: {
                return 1.0f;
            }
            case NORTH: {
                return 0.4f;
            }
            case SOUTH: {
                return 0.8f;
            }
            case EAST: 
            case WEST: {
                return 0.8f;
            }
        }
        return 1.0f;
    }

    public ChunkSource m_7726_() {
        return Minecraft.m_91087_().f_91073_.m_7726_();
    }

    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public MinecraftServer m_7654_() {
        return null;
    }

    public EntityTypeTest<Entity, ?> getTypeTest() {
        return EntityTypeTest.m_156916_(Entity.class);
    }

    public void m_220400_(@Nullable Entity entity, GameEvent event, Vec3 pos) {
    }

    public RegistryAccess m_9598_() {
        return Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_9598_() : null;
    }

    public FeatureFlagSet m_246046_() {
        return null;
    }

    public LevelTickAccess<Block> m_183326_() {
        return new NoOpTickAccess<Block>();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return new NoOpTickAccess<Fluid>();
    }

    private boolean isPositionTicking(BlockPos pos) {
        return true;
    }

    public float m_46490_(float partialTick) {
        return 0.0f;
    }

    public String m_46464_() {
        return "";
    }

    @Nullable
    public Entity m_6815_(int id) {
        return null;
    }

    @Nullable
    public MapItemSavedData m_7489_(String mapName) {
        return null;
    }

    public void m_142325_(String mapName, MapItemSavedData data) {
    }

    public int m_7354_() {
        return 0;
    }

    public void m_6801_(int breakerId, BlockPos pos, int progress) {
    }

    public int m_46941_() {
        return 0;
    }

    public float m_46940_() {
        return 1.0f;
    }

    public float m_46942_(float partialTick) {
        return 0.5f;
    }

    public int m_45517_(LightLayer type, BlockPos pos) {
        return 15;
    }

    protected LevelEntityGetter<Entity> m_142646_() {
        return null;
    }

    public Scoreboard m_6188_() {
        return null;
    }

    public Holder<Biome> m_204166_(BlockPos pos) {
        return null;
    }

    public Holder<Biome> m_203675_(int x, int y, int z) {
        return null;
    }

    private static enum FenceConfiguration {
        SINGLE(EnumSet.noneOf(Direction.class)),
        NORTH_SOUTH(EnumSet.of(Direction.NORTH, Direction.SOUTH)),
        EAST_WEST(EnumSet.of(Direction.EAST, Direction.WEST)),
        CORNER_NE(EnumSet.of(Direction.NORTH, Direction.EAST)),
        CORNER_NW(EnumSet.of(Direction.NORTH, Direction.WEST)),
        CORNER_SE(EnumSet.of(Direction.SOUTH, Direction.EAST)),
        CORNER_SW(EnumSet.of(Direction.SOUTH, Direction.WEST)),
        T_SHAPE_N(EnumSet.of(Direction.NORTH, Direction.EAST, Direction.WEST)),
        T_SHAPE_S(EnumSet.of(Direction.SOUTH, Direction.EAST, Direction.WEST)),
        T_SHAPE_E(EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.EAST)),
        T_SHAPE_W(EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.WEST)),
        CROSS(EnumSet.allOf(Direction.class));

        private final EnumSet<Direction> connections;

        private FenceConfiguration(EnumSet<Direction> connections) {
            this.connections = connections;
        }

        public BlockState applyToBlockState(BlockState state) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                state = (BlockState)state.m_61124_((Property)FakeLevel.getFenceProperty(direction), (Comparable)Boolean.valueOf(this.connections.contains(direction)));
            }
            return state;
        }
    }

    private static enum PlatformConfiguration {
        SINGLE(EnumSet.noneOf(Direction.class)),
        NORTH_SOUTH(EnumSet.of(Direction.NORTH, Direction.SOUTH)),
        EAST_WEST(EnumSet.of(Direction.EAST, Direction.WEST)),
        CORNER_NE(EnumSet.of(Direction.NORTH, Direction.EAST)),
        CORNER_NW(EnumSet.of(Direction.NORTH, Direction.WEST)),
        CORNER_SE(EnumSet.of(Direction.SOUTH, Direction.EAST)),
        CORNER_SW(EnumSet.of(Direction.SOUTH, Direction.WEST)),
        T_SHAPE_N(EnumSet.of(Direction.NORTH, Direction.EAST, Direction.WEST)),
        T_SHAPE_S(EnumSet.of(Direction.SOUTH, Direction.EAST, Direction.WEST)),
        T_SHAPE_E(EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.EAST)),
        T_SHAPE_W(EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.WEST)),
        CROSS(EnumSet.allOf(Direction.class));

        private final EnumSet<Direction> connections;

        private PlatformConfiguration(EnumSet<Direction> connections) {
            this.connections = connections;
        }

        public BlockState applyToBlockState(BlockState state) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                state = (BlockState)state.m_61124_((Property)FakeLevel.getPlatformProperty(direction), (Comparable)Boolean.valueOf(this.connections.contains(direction)));
            }
            return state;
        }

        public static PlatformConfiguration fromConnections(Set<Direction> connections) {
            for (PlatformConfiguration config : PlatformConfiguration.values()) {
                if (!config.connections.equals(connections)) continue;
                return config;
            }
            return SINGLE;
        }
    }

    private static enum TableConfiguration {
        SINGLE(EnumSet.noneOf(Direction.class)),
        NORTH_SOUTH(EnumSet.of(Direction.NORTH, Direction.SOUTH)),
        EAST_WEST(EnumSet.of(Direction.EAST, Direction.WEST)),
        CORNER_NE(EnumSet.of(Direction.NORTH, Direction.EAST)),
        CORNER_NW(EnumSet.of(Direction.NORTH, Direction.WEST)),
        CORNER_SE(EnumSet.of(Direction.SOUTH, Direction.EAST)),
        CORNER_SW(EnumSet.of(Direction.SOUTH, Direction.WEST)),
        T_SHAPE_N(EnumSet.of(Direction.NORTH, Direction.EAST, Direction.WEST)),
        T_SHAPE_S(EnumSet.of(Direction.SOUTH, Direction.EAST, Direction.WEST)),
        T_SHAPE_E(EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.EAST)),
        T_SHAPE_W(EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.WEST)),
        CROSS(EnumSet.allOf(Direction.class));

        private final EnumSet<Direction> connections;

        private TableConfiguration(EnumSet<Direction> connections) {
            this.connections = connections;
        }

        public BlockState applyToBlockState(BlockState state) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                state = (BlockState)state.m_61124_((Property)FakeLevel.getTableProperty(direction), (Comparable)Boolean.valueOf(!this.connections.contains(direction)));
            }
            return state;
        }

        public static TableConfiguration fromConnections(Set<Direction> connections) {
            for (TableConfiguration config : TableConfiguration.values()) {
                if (!config.connections.equals(connections)) continue;
                return config;
            }
            return SINGLE;
        }
    }
}

