/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lyivx.ls_furniture.common.blocks.properties.HorizontalConnectionType;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.registry.ModItemTags;
import net.lyivx.ls_furniture.registry.ModSoundEvents;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlindsBlock
extends Block
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HorizontalConnectionType> HORIZONTAL_CONNECTION_TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty VERTICAL_CONNECTION_TYPE = ModBlockStateProperties.VERTICAL_CONNECTION_TYPE_UP_DOWN;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlindsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HORIZONTAL_CONNECTION_TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).m_61124_((Property)VERTICAL_CONNECTION_TYPE, (Comparable)Direction.UP)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        HorizontalConnectionType type = (HorizontalConnectionType)((Object)state.m_61143_(HORIZONTAL_CONNECTION_TYPE));
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean open;
        boolean sideR;
        Direction clickedFacingFace;
        Direction clickedFace;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        BlockPos clickedPos = context.m_8083_();
        BlockPos clickedFacingPos = clickedPos.m_121945_(clickedFace = context.m_43719_());
        BlockState clickedFacingState = level.m_8055_(clickedFacingPos);
        if (clickedFacingState.m_60734_() instanceof BlindsBlock && (clickedFacingFace = (Direction)clickedFacingState.m_61143_((Property)FACING)) != clickedFace && clickedFacingFace.m_122424_() != clickedFace) {
            facing = clickedFacingFace;
        }
        if (facing.m_122434_().m_122478_()) {
            facing = context.m_8125_().m_122424_();
        }
        BlockState stateL = level.m_8055_(pos.m_121945_(facing.m_122427_()));
        BlockState stateR = level.m_8055_(pos.m_121945_(facing.m_122428_()));
        boolean sideL = stateL.m_60734_() instanceof BlindsBlock && stateL.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == Direction.UP && stateL.m_61143_((Property)FACING) == facing;
        boolean bl = sideR = stateR.m_60734_() instanceof BlindsBlock && stateR.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == Direction.UP && stateR.m_61143_((Property)FACING) == facing;
        boolean bl2 = sideL && sideR ? ((Boolean)stateL.m_61143_((Property)OPEN)).booleanValue() || ((Boolean)stateR.m_61143_((Property)OPEN)).booleanValue() : (sideR ? (Boolean)stateR.m_61143_((Property)OPEN) : (open = sideL ? (Boolean)stateL.m_61143_((Property)OPEN) : true));
        if (context.m_43725_().m_8055_(pos.m_7494_()).m_60734_() instanceof BlindsBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open))).m_61124_((Property)VERTICAL_CONNECTION_TYPE, (Comparable)Direction.DOWN)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean sideR;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction facing_vertical = (Direction)state.m_61143_((Property)VERTICAL_CONNECTION_TYPE);
        if (direction != facing.m_122427_() && direction != facing.m_122428_()) {
            return state;
        }
        BlockState stateL = level.m_8055_(currentPos.m_121945_(facing.m_122427_()));
        BlockState stateR = level.m_8055_(currentPos.m_121945_(facing.m_122428_()));
        boolean sideL = stateL.m_60734_() instanceof BlindsBlock && stateL.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == facing_vertical && stateL.m_61143_((Property)FACING) == facing;
        boolean bl = sideR = stateR.m_60734_() instanceof BlindsBlock && stateR.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == facing_vertical && stateR.m_61143_((Property)FACING) == facing;
        HorizontalConnectionType type = sideL && sideR ? HorizontalConnectionType.MIDDLE : (sideR ? HorizontalConnectionType.LEFT : (sideL ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)state.m_61124_(HORIZONTAL_CONNECTION_TYPE, (Comparable)((Object)type));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.m_6861_(state, level, pos, neighborBlock, fromPos, moving);
        if (level.m_8055_(pos.m_7494_()).m_60734_() instanceof BlindsBlock) {
            BlockState newState = (BlockState)state.m_61124_((Property)VERTICAL_CONNECTION_TYPE, (Comparable)Direction.DOWN);
            level.m_7731_(pos, newState, 3);
        } else if (!(level.m_8055_(pos.m_7494_()).m_60734_() instanceof BlindsBlock)) {
            BlockState newState = (BlockState)state.m_61124_((Property)VERTICAL_CONNECTION_TYPE, (Comparable)Direction.UP);
            level.m_7731_(pos, newState, 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_204117_(ModItemTags.BLINDS) && state.m_61143_((Property)FACING) == Direction.UP && hit.m_82434_() == Direction.UP) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (state.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == Direction.UP) {
            this.toggleFromTop(state, level, pos);
        } else {
            this.toggleFromTop(level.m_8055_(pos.m_7494_()), level, pos.m_7494_());
        }
        level.m_5594_(null, pos, ModSoundEvents.BLINDS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void toggleFromTop(BlockState state, Level level, BlockPos pos) {
        boolean open = (Boolean)state.m_61143_((Property)OPEN) == false;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction relativeLeft = facing.m_122427_();
        Direction relativeRight = facing.m_122428_();
        this.toggleVertical(state, level, pos, open);
        this.toggleHorizontal(state, level, pos, open, facing, relativeLeft);
        this.toggleHorizontal(state, level, pos, open, facing, relativeRight);
    }

    public void toggleHorizontal(BlockState state, Level level, BlockPos pos, boolean open, Direction facing, Direction dir) {
        BlockPos facingHorizontalPos = pos.m_121945_(dir);
        BlockState facingHorizontalState = level.m_8055_(facingHorizontalPos);
        if (facingHorizontalState.m_60734_() instanceof BlindsBlock && facingHorizontalState.m_61143_((Property)FACING) == facing && state.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == facingHorizontalState.m_61143_((Property)VERTICAL_CONNECTION_TYPE)) {
            this.toggleVertical(facingHorizontalState, level, facingHorizontalPos, open);
            this.toggleHorizontal(facingHorizontalState, level, facingHorizontalPos, open, facing, dir);
        }
    }

    public void toggleVertical(BlockState state, Level level, BlockPos pos, boolean open) {
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        this.toggleVerticalRecursive(state, level, pos, open, processed);
    }

    private void toggleVerticalRecursive(BlockState state, Level level, BlockPos pos, boolean open, Set<BlockPos> processed) {
        BlockPos prevPos;
        BlockState prevState;
        if (processed.contains(pos)) {
            return;
        }
        processed.add(pos);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)));
        Direction verticalDirection = (Direction)state.m_61143_((Property)VERTICAL_CONNECTION_TYPE);
        BlockPos nextPos = pos.m_121945_(verticalDirection);
        BlockState nextState = level.m_8055_(nextPos);
        if (nextState.m_60734_() instanceof BlindsBlock && nextState.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == verticalDirection) {
            this.toggleVerticalRecursive(nextState, level, nextPos, open, processed);
        }
        if ((prevState = level.m_8055_(prevPos = pos.m_121945_(verticalDirection.m_122424_()))).m_60734_() instanceof BlindsBlock && prevState.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == verticalDirection.m_122424_()) {
            this.toggleVerticalRecursive(prevState, level, prevPos, open, processed);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HORIZONTAL_CONNECTION_TYPE, OPEN, VERTICAL_CONNECTION_TYPE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }
}

