/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.entity.CounterOvenBlockEntity;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.registry.ModBlockEntitys;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CounterOvenBlock
extends AbstractFurnaceBlock
implements WrenchItem.WrenchableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)4.0, (double)11.0, (double)-1.0, (double)12.0, (double)12.0, (double)0.0), Block.m_49796_((double)12.0, (double)11.0, (double)-1.0, (double)13.0, (double)12.0, (double)1.0), Block.m_49796_((double)3.0, (double)11.0, (double)-1.0, (double)4.0, (double)12.0, (double)1.0), Block.m_49796_((double)0.0, (double)16.0, (double)15.0, (double)16.0, (double)18.0, (double)16.0), Block.m_49796_((double)2.0, (double)16.0, (double)2.0, (double)7.0, (double)17.0, (double)7.0), Block.m_49796_((double)2.5, (double)16.0, (double)8.5, (double)6.5, (double)17.0, (double)12.5), Block.m_49796_((double)9.5, (double)16.0, (double)2.5, (double)13.5, (double)17.0, (double)6.5), Block.m_49796_((double)9.0, (double)16.0, (double)8.0, (double)14.0, (double)17.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape SHAPE_NORTH_OPEN = Stream.of(Block.m_49796_((double)9.0, (double)16.0, (double)8.0, (double)14.0, (double)17.0, (double)13.0), Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)12.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)16.0, (double)15.0, (double)16.0, (double)18.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)2.0, (double)12.0, (double)14.0), Block.m_49796_((double)14.0, (double)2.0, (double)1.0, (double)16.0, (double)12.0, (double)14.0), Block.m_49796_((double)13.0, (double)4.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)3.0, (double)5.0, (double)14.0), Block.m_49796_((double)3.0, (double)2.0, (double)2.0, (double)13.0, (double)3.0, (double)13.0), Block.m_49796_((double)2.0, (double)5.0, (double)-3.9000000000000004, (double)14.0, (double)6.0, (double)9.0), Block.m_49796_((double)2.0, (double)2.0, (double)0.5, (double)14.0, (double)3.0, (double)1.5), Block.m_49796_((double)2.0, (double)2.4, (double)-0.5, (double)14.0, (double)3.4, (double)0.5), Block.m_49796_((double)2.0, (double)2.8499999999999996, (double)-1.5, (double)14.0, (double)3.8499999999999996, (double)-0.5), Block.m_49796_((double)2.0, (double)3.25, (double)-2.5, (double)14.0, (double)4.25, (double)-1.5), Block.m_49796_((double)2.0, (double)3.6999999999999997, (double)-3.5, (double)14.0, (double)4.700000000000001, (double)-2.5), Block.m_49796_((double)2.0, (double)4.1, (double)-4.5, (double)14.0, (double)5.1, (double)-3.5), Block.m_49796_((double)2.0, (double)4.949999999999999, (double)-6.5, (double)14.0, (double)5.949999999999999, (double)-5.5), Block.m_49796_((double)2.0, (double)5.349999999999998, (double)-7.5, (double)14.0, (double)6.349999999999998, (double)-6.5), Block.m_49796_((double)2.0, (double)5.649999999999999, (double)-8.3, (double)14.0, (double)6.649999999999999, (double)-7.300000000000001), Block.m_49796_((double)12.0, (double)4.349999999999998, (double)-8.6, (double)13.0, (double)5.349999999999998, (double)-7.6), Block.m_49796_((double)12.0, (double)5.349999999999998, (double)-8.4, (double)13.0, (double)6.349999999999998, (double)-7.4), Block.m_49796_((double)3.0, (double)5.349999999999998, (double)-8.4, (double)4.0, (double)6.349999999999998, (double)-7.4), Block.m_49796_((double)3.0, (double)4.349999999999998, (double)-8.6, (double)4.0, (double)5.349999999999998, (double)-7.6), Block.m_49796_((double)3.0, (double)3.849999999999998, (double)-8.9, (double)13.0, (double)4.349999999999998, (double)-7.9), Block.m_49796_((double)2.0, (double)4.5, (double)-5.5, (double)14.0, (double)5.5, (double)-4.5), Block.m_49796_((double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)2.0, (double)16.0, (double)2.0, (double)7.0, (double)17.0, (double)7.0), Block.m_49796_((double)2.5, (double)16.0, (double)8.5, (double)6.5, (double)17.0, (double)12.5), Block.m_49796_((double)9.5, (double)16.0, (double)2.5, (double)13.5, (double)17.0, (double)6.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST_OPEN = ShapeUtil.rotateShape(SHAPE_NORTH_OPEN, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH_OPEN = ShapeUtil.rotateShape(SHAPE_NORTH_OPEN, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST_OPEN = ShapeUtil.rotateShape(SHAPE_NORTH_OPEN, Direction.WEST);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_SOUTH, SHAPE_WEST, SHAPE_NORTH, SHAPE_EAST, SHAPE_SOUTH_OPEN, SHAPE_WEST_OPEN, SHAPE_NORTH_OPEN, SHAPE_EAST_OPEN};

    public CounterOvenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_48684_, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CounterOvenBlockEntity(pos, state);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CounterOvenBlockEntity) {
            CounterOvenBlockEntity counterOvenBE = (CounterOvenBlockEntity)blockEntity;
            counterOvenBE.recheckOpen();
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return CounterOvenBlock.m_151987_((Level)level, blockEntityType, ModBlockEntitys.COUNTER_OVEN_ENTITY.get());
    }

    protected void m_7137_(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CounterOvenBlockEntity) {
            player.m_5893_((MenuProvider)blockEntity);
            player.m_36220_(Stats.f_12966_);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)f_48684_)).booleanValue()) {
            double d = (double)pos.m_123341_() + 0.5;
            double e = pos.m_123342_();
            double f = (double)pos.m_123343_() + 0.5;
            if (random.m_188500_() < 0.1) {
                level.m_7785_(d, e, f, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            Direction.Axis axis = direction.m_122434_();
            double g = 0.52;
            double h = random.m_188500_() * 0.6 - 0.3;
            double i = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : h;
            double j = random.m_188500_() * 6.0 / 16.0;
            double k = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : h;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CounterOvenBlockEntity) {
            player.m_5893_((MenuProvider)blockEntity);
            player.m_36220_(Stats.f_12966_);
        }
        return InteractionResult.CONSUME;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, f_48684_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shape = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            shape += 4;
        }
        return SHAPES[shape];
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }
}

