/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.entity.CounterSinkBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.FluidInteractionUtil;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.config.ConfigProvider;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CounterSinkBlock
extends Block
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HAS_WATER = ModBlockStateProperties.HAS_WATER;
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)0.0, (double)16.0, (double)15.0, (double)16.0, (double)18.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.m_49796_((double)2.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), Block.m_49796_((double)14.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)2.0, (double)14.0, (double)13.0, (double)14.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0), Block.m_49796_((double)2.0, (double)12.0, (double)1.0, (double)14.0, (double)14.0, (double)3.0), Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)3.0, (double)11.0, (double)4.0, (double)13.0, (double)13.0, (double)12.0), Block.m_49796_((double)13.0, (double)13.0, (double)2.0, (double)15.0, (double)17.0, (double)14.0), Block.m_49796_((double)1.0, (double)13.0, (double)2.0, (double)3.0, (double)17.0, (double)14.0), Block.m_49796_((double)3.0, (double)13.0, (double)12.0, (double)13.0, (double)17.0, (double)14.0), Block.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)17.0, (double)4.0), Block.m_49796_((double)3.0, (double)14.0, (double)2.0, (double)13.0, (double)17.0, (double)3.0), Block.m_49796_((double)7.0, (double)17.0, (double)12.0, (double)9.0, (double)20.0, (double)14.0), Block.m_49796_((double)7.0, (double)20.0, (double)9.0, (double)9.0, (double)22.0, (double)14.0), Block.m_49796_((double)7.5, (double)19.0, (double)9.5, (double)8.5, (double)20.0, (double)10.5), Block.m_49796_((double)4.0, (double)17.4, (double)11.5, (double)5.0, (double)18.4, (double)12.5), Block.m_49796_((double)4.0, (double)17.4, (double)13.5, (double)5.0, (double)18.4, (double)14.5), Block.m_49796_((double)5.0, (double)17.4, (double)12.5, (double)6.0, (double)18.4, (double)13.5), Block.m_49796_((double)3.0, (double)17.4, (double)12.5, (double)4.0, (double)18.4, (double)13.5), Block.m_49796_((double)4.0, (double)17.4, (double)12.5, (double)5.0, (double)18.4, (double)13.5), Block.m_49796_((double)4.0, (double)17.0, (double)12.5, (double)5.0, (double)18.0, (double)13.5), Block.m_49796_((double)11.0, (double)17.0, (double)12.5, (double)12.0, (double)18.0, (double)13.5), Block.m_49796_((double)11.0, (double)17.4, (double)13.5, (double)12.0, (double)18.4, (double)14.5), Block.m_49796_((double)12.0, (double)17.4, (double)12.5, (double)13.0, (double)18.4, (double)13.5), Block.m_49796_((double)10.0, (double)17.4, (double)12.5, (double)11.0, (double)18.4, (double)13.5), Block.m_49796_((double)11.0, (double)17.4, (double)12.5, (double)12.0, (double)18.4, (double)13.5), Block.m_49796_((double)11.0, (double)17.4, (double)11.5, (double)12.0, (double)18.4, (double)12.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_SOUTH, SHAPE_WEST, SHAPE_NORTH, SHAPE_EAST};

    public CounterSinkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_WATER, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CounterSinkBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CounterSinkBlockEntity)) {
            return InteractionResult.FAIL;
        }
        CounterSinkBlockEntity sinkBE = (CounterSinkBlockEntity)blockEntity;
        if (stack.m_41619_()) {
            BlockPos sourcePos = pos.m_6625_(2);
            FluidState fluidStateBelow = level.m_6425_(sourcePos);
            if (fluidStateBelow.m_76170_() && !fluidStateBelow.m_76178_()) {
                Fluid fluidBelow = fluidStateBelow.m_76152_();
                if (!ConfigProvider.isSinkUniversal() && fluidBelow != Fluids.f_76193_) {
                    return InteractionResult.FAIL;
                }
                int currentAmount = sinkBE.getStoredAmount();
                int capacity = sinkBE.getCapacity();
                int amountToAdd = 1000;
                if ((sinkBE.isEmpty() || sinkBE.getFluid() == fluidBelow) && currentAmount + amountToAdd <= capacity) {
                    sinkBE.setFluidAndAmount(fluidBelow, currentAmount + amountToAdd);
                    level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
        if (item instanceof WrenchItem) {
            return InteractionResult.PASS;
        }
        Fluid fluidToFill = FluidInteractionUtil.getFluidFromItemStack(stack);
        if (fluidToFill != Fluids.f_76191_ && item != Items.f_42446_) {
            if (!ConfigProvider.isSinkUniversal() && fluidToFill != Fluids.f_76193_) {
                return InteractionResult.FAIL;
            }
            int currentAmount = sinkBE.getStoredAmount();
            int capacity = sinkBE.getCapacity();
            int amountToAdd = 1000;
            if ((sinkBE.isEmpty() || sinkBE.getFluid() == fluidToFill) && currentAmount + amountToAdd <= capacity) {
                sinkBE.setFluidAndAmount(fluidToFill, currentAmount + amountToAdd);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, Items.f_42446_.m_7968_());
                }
                SoundEvent fillSound = null;
                if (fluidToFill == Fluids.f_76193_) {
                    fillSound = SoundEvents.f_11778_;
                } else if (fluidToFill == Fluids.f_76195_) {
                    fillSound = SoundEvents.f_11780_;
                }
                if (fillSound != null) {
                    level.m_5594_(null, pos, fillSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (item == Items.f_42446_) {
            int currentAmount = sinkBE.getStoredAmount();
            int amountToRemove = 1000;
            Fluid fluidInSink = sinkBE.getFluid();
            if (!sinkBE.isEmpty() && currentAmount >= amountToRemove) {
                Item filledBucketItem = fluidInSink.m_6859_();
                if (filledBucketItem != Items.f_41852_) {
                    sinkBE.setFluidAndAmount(fluidInSink, currentAmount - amountToRemove);
                    if (!player.m_7500_()) {
                        ItemStack filledBucketStack = filledBucketItem.m_7968_();
                        stack.m_41774_(1);
                        if (stack.m_41619_()) {
                            player.m_21008_(hand, filledBucketStack);
                        } else if (!player.m_150109_().m_36054_(filledBucketStack)) {
                            player.m_36176_(filledBucketStack, false);
                        }
                    }
                    SoundEvent emptySound = null;
                    if (fluidInSink == Fluids.f_76193_) {
                        emptySound = SoundEvents.f_11781_;
                    } else if (fluidInSink == Fluids.f_76195_) {
                        emptySound = SoundEvents.f_11783_;
                    }
                    if (emptySound != null) {
                        level.m_5594_(null, pos, emptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.CONSUME;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shape = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        return SHAPES[shape];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, HAS_WATER});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }
}

