/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.entity.LockableBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.blocks.properties.VerticalConnectionType;
import net.lyivx.ls_furniture.common.items.HammerItem;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.common.utils.block.ILockable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FirePlaceChimneyShaftBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock,
HammerItem.HammerableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<VerticalConnectionType> VERTICAL = ModBlockStateProperties.VERTICAL_CONNECTION_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTH_SINGLE = Stream.of(Block.m_49796_((double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)15.0, (double)16.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)1.0, (double)16.0), Block.m_49796_((double)2.0, (double)15.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape NORTH_TOP = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)12.0, (double)13.0, (double)15.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)15.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape NORTH_MIDDLE = Block.m_49796_((double)3.0, (double)0.0, (double)12.0, (double)13.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_BOTTOM = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)1.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape[] SHAPES_SINGLE = new VoxelShape[4];
    private static final VoxelShape[] SHAPES_TOP;
    private static final VoxelShape[] SHAPES_MIDDLE;
    private static final VoxelShape[] SHAPES_BOTTOM;

    public FirePlaceChimneyShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VERTICAL, (Comparable)((Object)VerticalConnectionType.SINGLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (state.m_61143_(VERTICAL) == VerticalConnectionType.SINGLE) {
            return SHAPES_SINGLE[direction.m_122416_()];
        }
        if (state.m_61143_(VERTICAL) == VerticalConnectionType.TOP) {
            return SHAPES_TOP[direction.m_122416_()];
        }
        if (state.m_61143_(VERTICAL) == VerticalConnectionType.MIDDLE) {
            return SHAPES_MIDDLE[direction.m_122416_()];
        }
        if (state.m_61143_(VERTICAL) == VerticalConnectionType.BOTTOM) {
            return SHAPES_BOTTOM[direction.m_122416_()];
        }
        return SHAPES_SINGLE[direction.m_122416_()];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        return (BlockState)((BlockState)state.m_61124_(VERTICAL, (Comparable)((Object)this.getType(state, level.m_8055_(clickedPos.m_7494_()), level.m_8055_(clickedPos.m_7495_()))))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        LockableBlockEntity lockable;
        if (level.f_46443_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LockableBlockEntity && !(lockable = (LockableBlockEntity)blockEntity).isLocked()) {
            VerticalConnectionType type = this.getType(state, level.m_8055_(pos.m_7494_()), level.m_8055_(pos.m_7495_()));
            state = (BlockState)state.m_61124_(VERTICAL, (Comparable)((Object)type));
            level.m_7731_(pos, state, 3);
            super.m_6861_(state, level, pos, block, fromPos, isMoving);
        }
    }

    public VerticalConnectionType getType(BlockState state, BlockState above, BlockState below) {
        boolean up = this.isConnected(state, above);
        boolean down = this.isConnected(state, below);
        if (up && down) {
            return VerticalConnectionType.MIDDLE;
        }
        if (up) {
            return VerticalConnectionType.BOTTOM;
        }
        if (down) {
            return VerticalConnectionType.TOP;
        }
        return VerticalConnectionType.SINGLE;
    }

    public boolean isConnected(BlockState state, BlockState other) {
        return other.m_60713_(state.m_60734_()) && other.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VERTICAL, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        ILockable lockable;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((blockEntity = level.m_7702_(currentPos)) instanceof ILockable && (lockable = (ILockable)blockEntity).isLocked()) {
            return state;
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.lockable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.hammerable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    @Override
    public List<Property<?>> getHammerableProperties() {
        return List.of(VERTICAL);
    }

    @Override
    public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
        return WrenchItem.WrenchableBlock.super.updateAfterCycle(state, level, pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockableBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    static {
        FirePlaceChimneyShaftBlock.SHAPES_SINGLE[0] = ShapeUtil.rotateShape(NORTH_SINGLE, Direction.SOUTH);
        FirePlaceChimneyShaftBlock.SHAPES_SINGLE[1] = ShapeUtil.rotateShape(NORTH_SINGLE, Direction.WEST);
        FirePlaceChimneyShaftBlock.SHAPES_SINGLE[2] = ShapeUtil.rotateShape(NORTH_SINGLE, Direction.NORTH);
        FirePlaceChimneyShaftBlock.SHAPES_SINGLE[3] = ShapeUtil.rotateShape(NORTH_SINGLE, Direction.EAST);
        SHAPES_TOP = new VoxelShape[4];
        FirePlaceChimneyShaftBlock.SHAPES_TOP[0] = ShapeUtil.rotateShape(NORTH_TOP, Direction.SOUTH);
        FirePlaceChimneyShaftBlock.SHAPES_TOP[1] = ShapeUtil.rotateShape(NORTH_TOP, Direction.WEST);
        FirePlaceChimneyShaftBlock.SHAPES_TOP[2] = ShapeUtil.rotateShape(NORTH_TOP, Direction.NORTH);
        FirePlaceChimneyShaftBlock.SHAPES_TOP[3] = ShapeUtil.rotateShape(NORTH_TOP, Direction.EAST);
        SHAPES_MIDDLE = new VoxelShape[4];
        FirePlaceChimneyShaftBlock.SHAPES_MIDDLE[0] = ShapeUtil.rotateShape(NORTH_MIDDLE, Direction.SOUTH);
        FirePlaceChimneyShaftBlock.SHAPES_MIDDLE[1] = ShapeUtil.rotateShape(NORTH_MIDDLE, Direction.WEST);
        FirePlaceChimneyShaftBlock.SHAPES_MIDDLE[2] = ShapeUtil.rotateShape(NORTH_MIDDLE, Direction.NORTH);
        FirePlaceChimneyShaftBlock.SHAPES_MIDDLE[3] = ShapeUtil.rotateShape(NORTH_MIDDLE, Direction.EAST);
        SHAPES_BOTTOM = new VoxelShape[4];
        FirePlaceChimneyShaftBlock.SHAPES_BOTTOM[0] = ShapeUtil.rotateShape(NORTH_BOTTOM, Direction.SOUTH);
        FirePlaceChimneyShaftBlock.SHAPES_BOTTOM[1] = ShapeUtil.rotateShape(NORTH_BOTTOM, Direction.WEST);
        FirePlaceChimneyShaftBlock.SHAPES_BOTTOM[2] = ShapeUtil.rotateShape(NORTH_BOTTOM, Direction.NORTH);
        FirePlaceChimneyShaftBlock.SHAPES_BOTTOM[3] = ShapeUtil.rotateShape(NORTH_BOTTOM, Direction.EAST);
    }
}

