/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.Locale;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.entity.WardrobeBottomBlockEntity;
import net.lyivx.ls_furniture.common.blocks.entity.WardrobeTopBlockEntity;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WardrobeBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<WardrobeModelType> MODEL_TYPE = EnumProperty.m_61587_((String)"model", WardrobeModelType.class);
    private static final VoxelShape BASE_LOWER_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)32.0, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0), Block.m_49796_((double)1.0, (double)31.0, (double)0.0, (double)15.0, (double)32.0, (double)16.0), Block.m_49796_((double)1.0, (double)13.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0), Block.m_49796_((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)3.0, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)16.0), Block.m_49796_((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)13.0, (double)16.0), Block.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)31.0, (double)16.0), Block.m_49796_((double)8.25, (double)14.5, (double)0.0, (double)14.5, (double)30.5, (double)15.0), Block.m_49796_((double)1.5, (double)14.5, (double)0.0, (double)7.75, (double)30.5, (double)15.0), Block.m_49796_((double)1.5, (double)8.5, (double)0.0, (double)14.5, (double)12.5, (double)15.0), Block.m_49796_((double)1.5, (double)3.5, (double)0.0, (double)14.5, (double)7.5, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BASE_UPPER_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.m_49796_((double)15.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)-3.0, (double)0.0, (double)15.0, (double)-2.0, (double)16.0), Block.m_49796_((double)1.0, (double)-14.0, (double)0.0, (double)15.0, (double)-13.0, (double)16.0), Block.m_49796_((double)1.0, (double)-16.0, (double)1.0, (double)15.0, (double)-14.0, (double)16.0), Block.m_49796_((double)1.0, (double)-13.0, (double)1.0, (double)15.0, (double)-3.0, (double)16.0), Block.m_49796_((double)1.0, (double)-2.0, (double)1.0, (double)15.0, (double)15.0, (double)16.0), Block.m_49796_((double)8.25, (double)-1.5, (double)0.0, (double)14.5, (double)14.5, (double)15.0), Block.m_49796_((double)1.5, (double)-1.5, (double)0.0, (double)7.75, (double)14.5, (double)15.0), Block.m_49796_((double)1.5, (double)-7.5, (double)0.0, (double)14.5, (double)-3.5, (double)15.0), Block.m_49796_((double)1.5, (double)-12.5, (double)0.0, (double)14.5, (double)-8.5, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BASE_LOWER_OPEN_SHAPE = Stream.of(Block.m_49796_((double)1.5, (double)8.5, (double)-3.0, (double)14.5, (double)12.5, (double)-2.0), Block.m_49796_((double)3.0, (double)10.0, (double)10.0, (double)13.0, (double)12.0, (double)11.0), Block.m_49796_((double)13.0, (double)10.0, (double)-2.0, (double)14.0, (double)12.0, (double)11.0), Block.m_49796_((double)2.0, (double)10.0, (double)-2.0, (double)3.0, (double)12.0, (double)11.0), Block.m_49796_((double)2.0, (double)9.0, (double)-2.0, (double)14.0, (double)10.0, (double)11.0), Block.m_49796_((double)1.5, (double)3.5, (double)-6.0, (double)14.5, (double)7.5, (double)-5.0), Block.m_49796_((double)3.0, (double)5.0, (double)7.0, (double)13.0, (double)7.0, (double)8.0), Block.m_49796_((double)13.0, (double)5.0, (double)-5.0, (double)14.0, (double)7.0, (double)8.0), Block.m_49796_((double)2.0, (double)5.0, (double)-5.0, (double)3.0, (double)7.0, (double)8.0), Block.m_49796_((double)2.0, (double)4.0, (double)-5.0, (double)14.0, (double)5.0, (double)8.0), Block.m_49796_((double)1.0, (double)27.0, (double)15.0, (double)15.0, (double)31.0, (double)16.0), Block.m_49796_((double)1.0, (double)14.0, (double)15.0, (double)15.0, (double)27.0, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)13.0, (double)16.0), Block.m_49796_((double)15.0, (double)27.0, (double)0.0, (double)16.0, (double)31.0, (double)16.0), Block.m_49796_((double)0.0, (double)27.0, (double)0.0, (double)1.0, (double)31.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)1.0, (double)27.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)13.0, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)2.0), Block.m_49796_((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)15.0, (double)14.0, (double)0.0, (double)16.0, (double)27.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)31.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0), Block.m_49796_((double)2.0, (double)3.0, (double)1.0, (double)14.0, (double)4.0, (double)2.0), Block.m_49796_((double)1.0, (double)3.0, (double)1.0, (double)2.0, (double)13.0, (double)2.0), Block.m_49796_((double)2.0, (double)12.0, (double)1.0, (double)14.0, (double)13.0, (double)2.0), Block.m_49796_((double)2.0, (double)7.0, (double)1.0, (double)14.0, (double)9.0, (double)2.0), Block.m_49796_((double)14.0, (double)3.0, (double)1.0, (double)15.0, (double)13.0, (double)2.0), Block.m_49796_((double)14.0, (double)15.0, (double)1.0, (double)15.0, (double)30.0, (double)2.0), Block.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)15.0, (double)2.0), Block.m_49796_((double)7.5, (double)15.0, (double)1.0, (double)8.5, (double)30.0, (double)2.0), Block.m_49796_((double)1.0, (double)15.0, (double)1.0, (double)2.0, (double)30.0, (double)2.0), Block.m_49796_((double)1.0, (double)30.0, (double)1.0, (double)15.0, (double)31.0, (double)2.0), Block.m_49796_((double)1.5, (double)27.0, (double)0.0, (double)7.75, (double)30.5, (double)1.0), Block.m_49796_((double)1.5, (double)14.5, (double)0.0, (double)7.75, (double)27.0, (double)1.0), Block.m_49796_((double)8.25, (double)27.0, (double)0.0, (double)14.5, (double)30.5, (double)1.0), Block.m_49796_((double)8.25, (double)14.5, (double)0.0, (double)14.5, (double)27.0, (double)1.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BASE_UPPER_OPEN_SHAPE = Stream.of(Block.m_49796_((double)14.0, (double)-1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)1.0, (double)-2.0, (double)1.0, (double)15.0, (double)-1.0, (double)15.0), Block.m_49796_((double)7.5, (double)-1.0, (double)1.0, (double)8.5, (double)14.0, (double)2.0), Block.m_49796_((double)1.0, (double)-1.0, (double)1.0, (double)2.0, (double)14.0, (double)15.0), Block.m_49796_((double)1.5, (double)-7.5, (double)0.0, (double)14.5, (double)-3.5, (double)1.0), Block.m_49796_((double)3.0, (double)-6.0, (double)13.0, (double)13.0, (double)-4.0, (double)14.0), Block.m_49796_((double)13.0, (double)-6.0, (double)1.0, (double)14.0, (double)-4.0, (double)14.0), Block.m_49796_((double)2.0, (double)-6.0, (double)1.0, (double)3.0, (double)-4.0, (double)14.0), Block.m_49796_((double)2.0, (double)-12.0, (double)1.0, (double)14.0, (double)-11.0, (double)14.0), Block.m_49796_((double)2.0, (double)-11.0, (double)1.0, (double)3.0, (double)-9.0, (double)14.0), Block.m_49796_((double)1.0, (double)11.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), Block.m_49796_((double)1.0, (double)-2.0, (double)15.0, (double)15.0, (double)11.0, (double)16.0), Block.m_49796_((double)1.0, (double)-16.0, (double)15.0, (double)15.0, (double)-3.0, (double)16.0), Block.m_49796_((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)-2.0, (double)0.0, (double)1.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)1.0, (double)-3.0, (double)16.0), Block.m_49796_((double)1.0, (double)-16.0, (double)1.0, (double)15.0, (double)-14.0, (double)2.0), Block.m_49796_((double)1.0, (double)-14.0, (double)0.0, (double)15.0, (double)-13.0, (double)15.0), Block.m_49796_((double)15.0, (double)-16.0, (double)0.0, (double)16.0, (double)-3.0, (double)16.0), Block.m_49796_((double)15.0, (double)-2.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)-3.0, (double)0.0, (double)16.0, (double)-2.0, (double)16.0), Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)2.0, (double)-13.0, (double)1.0, (double)14.0, (double)-12.0, (double)2.0), Block.m_49796_((double)1.0, (double)-13.0, (double)1.0, (double)2.0, (double)-3.0, (double)2.0), Block.m_49796_((double)2.0, (double)-4.0, (double)1.0, (double)14.0, (double)-3.0, (double)2.0), Block.m_49796_((double)2.0, (double)-9.0, (double)1.0, (double)14.0, (double)-7.0, (double)2.0), Block.m_49796_((double)14.0, (double)-13.0, (double)1.0, (double)15.0, (double)-3.0, (double)2.0), Block.m_49796_((double)13.0, (double)-11.0, (double)1.0, (double)14.0, (double)-9.0, (double)14.0), Block.m_49796_((double)3.0, (double)-11.0, (double)13.0, (double)13.0, (double)-9.0, (double)14.0), Block.m_49796_((double)1.5, (double)-12.5, (double)0.0, (double)14.5, (double)-8.5, (double)1.0), Block.m_49796_((double)2.0, (double)-7.0, (double)1.0, (double)14.0, (double)-6.0, (double)14.0), Block.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.m_49796_((double)1.0, (double)-1.5, (double)0.0, (double)2.0, (double)14.5, (double)1.0), Block.m_49796_((double)1.5, (double)-1.5, (double)-0.5, (double)2.5, (double)14.5, (double)0.5), Block.m_49796_((double)2.5, (double)-1.5, (double)-1.5, (double)3.5, (double)14.5, (double)-0.5), Block.m_49796_((double)2.0, (double)-1.5, (double)-1.0, (double)3.0, (double)14.5, (double)0.0), Block.m_49796_((double)3.5, (double)-1.5, (double)-2.5, (double)4.5, (double)14.5, (double)-1.5), Block.m_49796_((double)3.0, (double)-1.5, (double)-2.0, (double)4.0, (double)14.5, (double)-1.0), Block.m_49796_((double)4.5, (double)-1.5, (double)-3.5, (double)5.5, (double)14.5, (double)-2.5), Block.m_49796_((double)5.0, (double)-1.5, (double)-4.0, (double)6.0, (double)14.5, (double)-3.0), Block.m_49796_((double)5.5, (double)-1.5, (double)-4.5, (double)6.5, (double)14.5, (double)-3.5), Block.m_49796_((double)13.899999999999999, (double)-1.5, (double)-0.25, (double)14.899999999999999, (double)14.5, (double)0.75), Block.m_49796_((double)13.500000000000002, (double)-1.5, (double)-1.25, (double)14.500000000000002, (double)14.5, (double)-0.25), Block.m_49796_((double)12.650000000000002, (double)-1.5, (double)-3.25, (double)13.650000000000002, (double)14.5, (double)-2.25), Block.m_49796_((double)13.075, (double)-1.5, (double)-2.25, (double)14.075, (double)14.5, (double)-1.25), Block.m_49796_((double)11.850000000000005, (double)-1.5, (double)-5.25, (double)12.850000000000005, (double)14.5, (double)-4.25), Block.m_49796_((double)11.700000000000006, (double)-1.5, (double)-5.75, (double)12.700000000000006, (double)14.5, (double)-4.75), Block.m_49796_((double)12.250000000000002, (double)-1.5, (double)-4.25, (double)13.250000000000002, (double)14.5, (double)-3.25), Block.m_49796_((double)12.050000000000004, (double)-1.5, (double)-4.75, (double)13.050000000000004, (double)14.5, (double)-3.75), Block.m_49796_((double)12.450000000000001, (double)-1.5, (double)-3.75, (double)13.450000000000001, (double)14.5, (double)-2.75), Block.m_49796_((double)12.875000000000002, (double)-1.5, (double)-2.75, (double)13.875000000000002, (double)14.5, (double)-1.75), Block.m_49796_((double)13.274999999999999, (double)-1.5, (double)-1.75, (double)14.274999999999999, (double)14.5, (double)-0.75), Block.m_49796_((double)13.700000000000001, (double)-1.5, (double)-0.75, (double)14.700000000000001, (double)14.5, (double)0.25), Block.m_49796_((double)4.0, (double)-1.5, (double)-3.0, (double)5.0, (double)14.5, (double)-2.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] SHAPES = new VoxelShape[8];
    private static final VoxelShape[] SHAPES_OPEN = new VoxelShape[8];

    public WardrobeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(MODEL_TYPE, (Comparable)((Object)WardrobeModelType.BOTTOM))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, MODEL_TYPE, OPEN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        Level level = context.m_43725_();
        if (level.m_8055_(blockPos.m_7494_()).m_60629_(context)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (state.m_61143_(MODEL_TYPE) == WardrobeModelType.BOTTOM) {
            if (blockEntity instanceof WardrobeBottomBlockEntity) {
                WardrobeBottomBlockEntity drawerBlockEntity = (WardrobeBottomBlockEntity)blockEntity;
                player.m_5893_((MenuProvider)drawerBlockEntity);
                PiglinAi.m_34873_((Player)player, (boolean)true);
                return InteractionResult.SUCCESS;
            }
        } else if (state.m_61143_(MODEL_TYPE) == WardrobeModelType.TOP && blockEntity instanceof WardrobeTopBlockEntity) {
            WardrobeTopBlockEntity drawerBlockEntity = (WardrobeTopBlockEntity)blockEntity;
            player.m_5893_((MenuProvider)drawerBlockEntity);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private static Direction getNeighbourDirection(WardrobeModelType modelType) {
        return modelType == WardrobeModelType.BOTTOM ? Direction.UP : Direction.DOWN;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        WardrobeModelType modelType;
        BlockPos otherPos;
        BlockState otherState;
        if (!level.f_46443_ && (otherState = level.m_8055_(otherPos = pos.m_121945_(WardrobeBlock.getNeighbourDirection(modelType = (WardrobeModelType)((Object)state.m_61143_(MODEL_TYPE)))))).m_60734_() == this && otherState.m_61143_(MODEL_TYPE) != modelType) {
            BlockPos bottomPos = modelType == WardrobeModelType.BOTTOM ? pos : otherPos;
            BlockPos topPos = modelType == WardrobeModelType.TOP ? pos : otherPos;
            level.m_7731_(bottomPos, Blocks.f_50016_.m_49966_(), 3);
            level.m_5898_(player, 2001, bottomPos, Block.m_49956_((BlockState)state));
            level.m_7731_(topPos, Blocks.f_50016_.m_49966_(), 3);
            level.m_5898_(player, 2001, topPos, Block.m_49956_((BlockState)otherState));
            if (!player.m_7500_()) {
                WardrobeBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
                WardrobeBlock.m_49881_((BlockState)otherState, (Level)level, (BlockPos)otherPos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_) {
            level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(MODEL_TYPE, (Comparable)((Object)WardrobeModelType.TOP)), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WardrobeBottomBlockEntity) {
            WardrobeBottomBlockEntity wardrobeBE = (WardrobeBottomBlockEntity)blockEntity;
            wardrobeBE.recheckOpen();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(MODEL_TYPE) == WardrobeModelType.TOP) {
            return new WardrobeTopBlockEntity(pos, state);
        }
        return new WardrobeBottomBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        int shape = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        if (state.m_61143_(MODEL_TYPE) == WardrobeModelType.BOTTOM && !((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return SHAPES[4 + direction.m_122416_()];
        }
        if (state.m_61143_(MODEL_TYPE) == WardrobeModelType.BOTTOM && ((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return SHAPES_OPEN[4 + direction.m_122416_()];
        }
        if (state.m_61143_(MODEL_TYPE) == WardrobeModelType.TOP && !((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return SHAPES[direction.m_122416_()];
        }
        if (state.m_61143_(MODEL_TYPE) == WardrobeModelType.TOP && ((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return SHAPES_OPEN[direction.m_122416_()];
        }
        return SHAPES[shape];
    }

    static {
        WardrobeBlock.SHAPES[0] = ShapeUtil.rotateShape(BASE_UPPER_SHAPE, Direction.SOUTH);
        WardrobeBlock.SHAPES[1] = ShapeUtil.rotateShape(BASE_UPPER_SHAPE, Direction.WEST);
        WardrobeBlock.SHAPES[2] = ShapeUtil.rotateShape(BASE_UPPER_SHAPE, Direction.NORTH);
        WardrobeBlock.SHAPES[3] = ShapeUtil.rotateShape(BASE_UPPER_SHAPE, Direction.EAST);
        WardrobeBlock.SHAPES[4] = ShapeUtil.rotateShape(BASE_LOWER_SHAPE, Direction.SOUTH);
        WardrobeBlock.SHAPES[5] = ShapeUtil.rotateShape(BASE_LOWER_SHAPE, Direction.WEST);
        WardrobeBlock.SHAPES[6] = ShapeUtil.rotateShape(BASE_LOWER_SHAPE, Direction.NORTH);
        WardrobeBlock.SHAPES[7] = ShapeUtil.rotateShape(BASE_LOWER_SHAPE, Direction.EAST);
        WardrobeBlock.SHAPES_OPEN[0] = ShapeUtil.rotateShape(BASE_UPPER_OPEN_SHAPE, Direction.SOUTH);
        WardrobeBlock.SHAPES_OPEN[1] = ShapeUtil.rotateShape(BASE_UPPER_OPEN_SHAPE, Direction.WEST);
        WardrobeBlock.SHAPES_OPEN[2] = ShapeUtil.rotateShape(BASE_UPPER_OPEN_SHAPE, Direction.NORTH);
        WardrobeBlock.SHAPES_OPEN[3] = ShapeUtil.rotateShape(BASE_UPPER_OPEN_SHAPE, Direction.EAST);
        WardrobeBlock.SHAPES_OPEN[4] = ShapeUtil.rotateShape(BASE_LOWER_OPEN_SHAPE, Direction.SOUTH);
        WardrobeBlock.SHAPES_OPEN[5] = ShapeUtil.rotateShape(BASE_LOWER_OPEN_SHAPE, Direction.WEST);
        WardrobeBlock.SHAPES_OPEN[6] = ShapeUtil.rotateShape(BASE_LOWER_OPEN_SHAPE, Direction.NORTH);
        WardrobeBlock.SHAPES_OPEN[7] = ShapeUtil.rotateShape(BASE_LOWER_OPEN_SHAPE, Direction.EAST);
    }

    public static enum WardrobeModelType implements StringRepresentable
    {
        BOTTOM,
        TOP;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

