/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.compat;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.plugins.vanilla.crafting.VanillaRecipes;
import net.lyivx.ls_furniture.common.compat.ChoppingBoardCategory;
import net.lyivx.ls_furniture.common.compat.CuttingBoardCategory;
import net.lyivx.ls_furniture.common.compat.WorkstationRecipeCategory;
import net.lyivx.ls_furniture.common.compat.WorldInteractionRecipeCategory;
import net.lyivx.ls_furniture.common.menus.WorkstationMenu;
import net.lyivx.ls_furniture.registry.ModBlocks;
import net.lyivx.ls_furniture.registry.ModMenus;
import net.lyivx.ls_furniture.registry.ModRecipes;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class ModJeiPlugin
implements IModPlugin {
    @Nullable
    private IRecipeCategory<SmokingRecipe> smokingCategory;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new WorkstationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new WorldInteractionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChoppingBoardCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CuttingBoardCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IIngredientManager ingredientManager = registration.getIngredientManager();
        VanillaRecipes vanillaRecipes = new VanillaRecipes(ingredientManager);
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List recipesCraftingWorkstation = rm.m_44013_(ModRecipes.WORKSTATION_RECIPE.get());
        registration.addRecipes(WorkstationRecipeCategory.WORKSTATION_RECIPE_TYPE, recipesCraftingWorkstation);
        List recipesCraftingWorldInteraction = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.WORLD_INTERACTION_RECIPE.get());
        registration.addRecipes(WorldInteractionRecipeCategory.WORLD_INTERACTION_RECIPE_TYPE, recipesCraftingWorldInteraction);
        List recipesCraftingChoppingBoard = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.CHOPPING_BOARD_RECIPE.get());
        registration.addRecipes(ChoppingBoardCategory.CHOPPING_BOARD_RECIPE_TYPE, recipesCraftingChoppingBoard);
        List recipesCraftingCuttingBoard = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.CUTTING_BOARD_RECIPE.get());
        registration.addRecipes(CuttingBoardCategory.CUTTING_BOARD_RECIPE_TYPE, recipesCraftingCuttingBoard);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WORKSTATION.get()), new RecipeType[]{WorkstationRecipeCategory.WORKSTATION_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50440_), new RecipeType[]{WorldInteractionRecipeCategory.WORLD_INTERACTION_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CHOPPING_BOARD.get()), new RecipeType[]{ChoppingBoardCategory.CHOPPING_BOARD_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CUTTING_BOARD.get()), new RecipeType[]{CuttingBoardCategory.CUTTING_BOARD_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.OAK_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SPRUCE_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BIRCH_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.JUNGLE_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ACACIA_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DARK_OAK_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MANGROVE_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CHERRY_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BAMBOO_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CRIMSON_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WARPED_COUNTER_OVEN.get()), new RecipeType[]{RecipeTypes.SMOKING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(WorkstationMenu.class, (MenuType)ModMenus.WORKSTATION_MENU.get(), WorkstationRecipeCategory.WORKSTATION_RECIPE_TYPE, 0, 2, 2, 36);
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ls_furniture", "jei_mod_plugin");
    }
}

