/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.entity;

import java.util.List;
import net.lyivx.ls_furniture.common.blocks.SeatBlock;
import net.lyivx.ls_furniture.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SeatEntity
extends Entity {
    private BlockPos sittingPosition;

    public SeatEntity(Level level) {
        super(ModEntities.SEAT.get(), level);
        this.f_19794_ = true;
    }

    public SeatEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.sittingPosition = BlockPos.f_121853_;
    }

    public SeatEntity(Level level, BlockPos pos) {
        this(level);
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.001, (double)pos.m_123343_() + 0.5);
        this.sittingPosition = pos;
    }

    public void m_8119_() {
        boolean canSit;
        if (this.m_9236_().f_46443_) {
            return;
        }
        BlockState state = this.m_9236_().m_8055_(this.m_20183_());
        Block block = state.m_60734_();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            canSit = seatBlock.isSittable(state);
        } else {
            canSit = false;
        }
        if (this.m_20160_() && canSit) {
            return;
        }
        this.m_146870_();
        this.m_9236_().m_46717_(this.m_20183_(), this.m_9236_().m_8055_(this.m_20183_()).m_60734_());
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public double m_6048_() {
        List passengers = this.m_20197_();
        if (passengers.isEmpty()) {
            return 0.0;
        }
        double seatHeight = 0.0;
        BlockState state = this.m_9236_().m_8055_(this.m_20183_());
        Block block = state.m_60734_();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            seatHeight = seatBlock.seatHeight(state);
        }
        return seatHeight + SeatEntity.getEntitySeatOffset((Entity)passengers.get(0));
    }

    public static double getEntitySeatOffset(Entity entity) {
        if (entity instanceof Slime) {
            return 0.25;
        }
        if (entity instanceof Parrot) {
            return 0.0625;
        }
        if (entity instanceof Skeleton) {
            return 0.125;
        }
        if (entity instanceof Creeper) {
            return 0.25;
        }
        if (entity instanceof Cat) {
            return 0.125;
        }
        if (entity instanceof Wolf) {
            return 0.0625;
        }
        return 0.0;
    }

    protected boolean m_7341_(Entity entity) {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public Vec3 m_7688_(LivingEntity entity) {
        Direction[] offsets;
        Vec3 safeVec;
        BlockPos pos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            safeVec = DismountHelper.m_38441_((EntityType)entity.m_6095_(), (CollisionGetter)this.m_9236_(), (BlockPos)seatBlock.primaryDismountLocation(this.m_9236_(), state, pos), (boolean)false);
            if (safeVec != null) {
                return safeVec.m_82520_(0.0, 0.25, 0.0);
            }
        }
        Direction original = this.m_6350_();
        for (Direction dir : offsets = new Direction[]{original, original.m_122427_(), original.m_122428_(), original.m_122424_()}) {
            safeVec = DismountHelper.m_38441_((EntityType)entity.m_6095_(), (CollisionGetter)this.m_9236_(), (BlockPos)pos.m_121945_(dir), (boolean)false);
            if (safeVec == null) continue;
            return safeVec.m_82520_(0.0, 0.25, 0.0);
        }
        return super.m_7688_(entity);
    }

    protected void m_20348_(Entity passenger) {
        BlockPos pos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof SeatBlock) {
            SeatBlock seatBlock = (SeatBlock)block;
            passenger.m_146922_(seatBlock.setRiderRotation(state, passenger));
        }
        super.m_20348_(passenger);
    }

    protected void m_20351_(Entity entity) {
        super.m_20351_(entity);
        if (entity instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)entity;
            ta.m_21837_(false);
        }
    }
}

