/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.items;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.lyivx.ls_furniture.common.utils.block.ILockable;
import net.lyivx.ls_furniture.registry.ModSoundEvents;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class WrenchItem
extends Item {
    private double selectedPropertyIndex = 0.0;
    private static final String LOCKED_TAG = "locked";

    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrench"));
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrench.shift"));
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_7373_(stack, level, tooltipComponents, flag);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockState state = level.m_8055_(pos);
        if (player != null && player.m_6144_()) {
            return this.handleLockToggle(level, pos, player);
        }
        Block block = state.m_60734_();
        if (block instanceof WrenchableBlock) {
            WrenchableBlock wrenchBlock = (WrenchableBlock)block;
            List<Property<?>> wrenchProperties = wrenchBlock.getWrenchableProperties();
            if (wrenchProperties.isEmpty()) {
                return InteractionResult.PASS;
            }
            int numProperties = wrenchProperties.size();
            if (this.selectedPropertyIndex >= (double)numProperties) {
                this.selectedPropertyIndex = 0.0;
            }
            boolean isShiftDown = player != null && player.m_6144_();
            boolean result = this.tryWrenchBlock(state, (LevelAccessor)level, pos, player, hand, wrenchBlock, wrenchProperties, isShiftDown);
            return result ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleLockToggle(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        String blockName = block.m_49954_().getString();
        String posString = String.format("(%d, %d, %d)", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        if (blockEntity instanceof ILockable) {
            ILockable lockable = (ILockable)blockEntity;
            boolean newLockState = !lockable.isLocked();
            lockable.setLocked(newLockState);
            MutableComponent lockStatus = newLockState ? Component.m_237115_((String)"msg.ls_furniture.wrench.locked") : Component.m_237115_((String)"msg.ls_furniture.wrench.unlocked");
            MutableComponent lockedMessage = lockStatus.m_130946_(" ").m_130946_(blockName).m_130946_(" at ").m_130946_(posString);
            player.m_5661_((Component)lockedMessage, true);
            level.m_5594_(null, pos, this.getUseSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        MutableComponent noLock = Component.m_237115_((String)"msg.ls_furniture.wrench.no_lock");
        MutableComponent blockNameComponent = Component.m_237113_((String)blockName);
        MutableComponent posStringComponent = Component.m_237113_((String)posString);
        MutableComponent noLockMessage = blockNameComponent.m_7220_((Component)noLock).m_7220_((Component)posStringComponent);
        player.m_5661_((Component)noLockMessage, true);
        return InteractionResult.FAIL;
    }

    private String formatString(String input) {
        return Arrays.stream(input.replace("_", " ").split("\\s+")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    private Property<?> getNextWrenchableProperty(BlockState state, List<Property<?>> properties) {
        if (properties.isEmpty()) {
            return null;
        }
        int currentIndex = properties.indexOf(state.m_61148_().keySet().stream().filter(properties::contains).findFirst().orElse(null));
        return properties.get((currentIndex + 1) % properties.size());
    }

    private <T extends Comparable<T>> T getNextPropertyValue(Property<T> property, T currentValue) {
        if (property instanceof BooleanProperty) {
            return (T)Boolean.valueOf((Boolean)currentValue == false);
        }
        if (property instanceof EnumProperty) {
            Enum currentEnum = (Enum)((Object)currentValue);
            Enum[] enumValues = ((EnumProperty)property).m_6908_().toArray(new Enum[0]);
            int nextIndex = (Arrays.asList(enumValues).indexOf(currentEnum) + 1) % enumValues.length;
            return (T)enumValues[nextIndex];
        }
        if (property instanceof IntegerProperty) {
            IntegerProperty intProperty = (IntegerProperty)property;
            int min = intProperty.m_6908_().stream().mapToInt(v -> v).min().orElse(0);
            int max = intProperty.m_6908_().stream().mapToInt(v -> v).max().orElse(0);
            int currentInt = (Integer)currentValue;
            int nextInt = (currentInt + 1 - min) % (max - min + 1) + min;
            return (T)Integer.valueOf(nextInt);
        }
        return currentValue;
    }

    private boolean tryWrenchBlock(BlockState state, LevelAccessor level, BlockPos pos, Player player, InteractionHand hand, WrenchableBlock wrenchableBlock, List<Property<?>> wrenchProperties, boolean isShiftDown) {
        List<Property<?>> wrenchableProperties = wrenchableBlock.getWrenchableProperties();
        if (wrenchableProperties.isEmpty()) {
            return false;
        }
        if (isShiftDown) {
            this.selectedPropertyIndex = (this.selectedPropertyIndex + 0.5) % (double)wrenchableProperties.size();
            Property<?> nextProperty = wrenchableProperties.get((int)this.selectedPropertyIndex);
            if (level instanceof Level && !((Level)level).m_5776_()) {
                String propertyName = this.formatString(nextProperty.m_61708_());
                MutableComponent selected = Component.m_237115_((String)"msg.ls_furniture.tool.selected");
                MutableComponent propertyNameComponent = Component.m_237113_((String)propertyName);
                MutableComponent selectedMessage = selected.m_7220_((Component)propertyNameComponent);
                player.m_5661_((Component)selectedMessage, true);
            }
        } else {
            Property<?> propertyToChange = wrenchableProperties.get((int)this.selectedPropertyIndex);
            if (propertyToChange != null && state.m_61138_(propertyToChange)) {
                state = this.cyclePropertyValue(state, propertyToChange);
                state = wrenchableBlock.updateAfterCycle(state, level, pos);
                level.m_7731_(pos, state, 18);
                level.m_5594_(null, pos, this.getUseSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (level instanceof Level && !((Level)level).m_5776_()) {
                    String propertyName = this.formatString(propertyToChange.m_61708_());
                    String value = this.formatString(this.getPropertyValueAsString(state, propertyToChange));
                    player.m_5661_((Component)Component.m_237113_((String)(propertyName + ": " + value)), true);
                }
            }
        }
        return true;
    }

    private <T extends Comparable<T>> BlockState cyclePropertyValue(BlockState state, Property<T> property) {
        Comparable currentValue = state.m_61143_(property);
        Comparable nextValue = this.getNextPropertyValue(property, currentValue);
        return (BlockState)state.m_61124_(property, nextValue);
    }

    private <T extends Comparable<T>> String getPropertyValueAsString(BlockState state, Property<T> property) {
        return property.m_6940_(state.m_61143_(property));
    }

    private SoundEvent getUseSound() {
        return ModSoundEvents.TOOL_USE.get();
    }

    public static boolean isBlockLocked(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ILockable) {
            ILockable lockable = (ILockable)blockEntity;
            return lockable.isLocked();
        }
        return false;
    }

    public static interface WrenchableBlock {
        public List<Property<?>> getWrenchableProperties();

        default public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
            return state;
        }
    }
}

