/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.lyivx.ls_core.client.screens.ModConfigScreen;
import net.lyivx.ls_core.client.screens.widgets.CustomOptionsList;
import net.lyivx.ls_core.common.config.CustomConfigSpec;
import net.lyivx.ls_core.common.config.ILyivxConfigProvider;
import net.lyivx.ls_furniture.LYIVXsFurnitureMod;
import net.lyivx.ls_furniture.config.ClientConfigHelper;
import org.jetbrains.annotations.NotNull;

public class ConfigProvider
implements ILyivxConfigProvider {
    public static final String PROVIDER_ID = "ls_furniture";
    private static CustomConfigSpec configSpecInstance = null;

    @NotNull
    public static CustomConfigSpec getConfigSpec() {
        if (configSpecInstance == null) {
            LYIVXsFurnitureMod.LOGGER.error("Furnection ConfigProvider accessed before configSpec was registered!");
            return null;
        }
        return configSpecInstance;
    }

    public static boolean shouldSortRecipes() {
        CustomConfigSpec spec = ConfigProvider.getConfigSpec();
        return spec != null ? spec.getBoolean("sort_recipes", true) : true;
    }

    public static boolean shouldShowPreview() {
        CustomConfigSpec spec = ConfigProvider.getConfigSpec();
        return spec != null ? spec.getBoolean("show_preview", true) : true;
    }

    public static SearchMode getSearchMode() {
        CustomConfigSpec spec = ConfigProvider.getConfigSpec();
        return spec != null ? (SearchMode)spec.getEnum("search_bar_mode", (Enum)SearchMode.AUTOMATIC, SearchMode.class) : SearchMode.AUTOMATIC;
    }

    public static int getSearchBarThreshold() {
        CustomConfigSpec spec = ConfigProvider.getConfigSpec();
        return spec != null ? spec.getInt("search_bar_threshold", 32) : 32;
    }

    public static boolean hasSearchBar(int recipeCount) {
        return switch (ConfigProvider.getSearchMode().ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> true;
            case 0 -> false;
            case 2 -> {
                if (recipeCount > 25) {
                    yield true;
                }
                yield false;
            }
            case 3 -> recipeCount > ConfigProvider.getSearchBarThreshold();
        };
    }

    public static boolean isSinkUniversal() {
        CustomConfigSpec spec = ConfigProvider.getConfigSpec();
        return spec != null ? spec.getBoolean("sink_allow_all_liquids", false) : false;
    }

    public static int getSinkCapacityBuckets() {
        CustomConfigSpec spec = ConfigProvider.getConfigSpec();
        return spec != null ? spec.getInt("sink_capacity_buckets", 3) : 3;
    }

    public String getModId() {
        return PROVIDER_ID;
    }

    public String getModName() {
        return "Furnection";
    }

    public String getConfigCategoryName() {
        return "Furnection";
    }

    public JsonObject getDefaultConfig() {
        JsonObject defaults = new JsonObject();
        defaults.addProperty("sort_recipes", Boolean.valueOf(true));
        defaults.addProperty("show_preview", Boolean.valueOf(true));
        defaults.addProperty("search_bar_mode", SearchMode.AUTOMATIC.name());
        defaults.addProperty("search_bar_threshold", (Number)32);
        defaults.addProperty("sink_allow_all_liquids", Boolean.valueOf(false));
        defaults.addProperty("sink_capacity_buckets", (Number)3);
        return defaults;
    }

    public void registerConfigSpec(CustomConfigSpec spec) {
        configSpecInstance = spec;
        LYIVXsFurnitureMod.LOGGER.info("Registered config spec for LYIVX's Furniture.");
    }

    public void addConfigOptions(ModConfigScreen screen, CustomOptionsList list) {
        if (screen != null && list != null) {
            ClientConfigHelper.addConfigOptions(this, screen, list);
        }
    }

    public void resetConfigDefaults() {
        CustomConfigSpec spec = configSpecInstance;
        if (spec != null) {
            JsonObject defaults = this.getDefaultConfig();
            defaults.entrySet().forEach(entry -> spec.set((String)entry.getKey(), (JsonElement)entry.getValue()));
        }
    }

    public static enum SearchMode {
        OFF("Off"),
        ON("On"),
        AUTOMATIC("Automatic"),
        DYNAMIC("Dynamic");

        private final String displayName;

        private SearchMode(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }

        public static SearchMode safeValueOf(String name) {
            try {
                return SearchMode.valueOf(name);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return AUTOMATIC;
            }
        }
    }
}

