/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.utils;

import com.leclowndu93150.particular.Main;
import com.leclowndu93150.particular.mixin.NativeImageAccessor;
import com.leclowndu93150.particular.utils.TextureCache;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafColorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LeafColorUtil");
    private static final RandomSource renderRandom = RandomSource.m_216327_();

    public static double[] averageColor(NativeImage image) {
        if (image.m_85102_() != NativeImage.Format.RGBA) {
            LOGGER.error("RGBA image required, was {}", (Object)image.m_85102_());
            return new double[]{1.0, 1.0, 1.0};
        }
        long pixels = ((NativeImageAccessor)image).getPixels();
        if (pixels == 0L) {
            LOGGER.error("Image is not allocated");
            return new double[]{1.0, 1.0, 1.0};
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        int width = image.m_84982_();
        int height = image.m_85084_();
        for (int i = 0; i < width * height; ++i) {
            int c = MemoryUtil.memGetInt((long)(pixels + 4L * (long)i));
            int cr = c & 0xFF;
            int cg = c >> 8 & 0xFF;
            int cb = c >> 16 & 0xFF;
            int ca = c >> 24 & 0xFF;
            if (ca == 0) continue;
            r += (double)cr;
            g += (double)cg;
            b += (double)cb;
            ++n;
        }
        if (n == 0) {
            return new double[]{1.0, 1.0, 1.0};
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }

    public static double[] getBlockTextureColor(BlockState state, Level world, BlockPos pos) {
        boolean shouldColor;
        TextureAtlasSprite sprite;
        Minecraft client = Minecraft.m_91087_();
        BakedModel model = client.m_91289_().m_110910_(state);
        ModelData modelData = model.getModelData((BlockAndTintGetter)world, pos, state, ModelData.EMPTY);
        renderRandom.m_188584_(state.m_60726_(pos));
        List quads = model.getQuads(state, Direction.DOWN, renderRandom, modelData, RenderType.m_110463_());
        if (!quads.isEmpty()) {
            BakedQuad quad = (BakedQuad)quads.get(0);
            sprite = quad.m_173410_();
            shouldColor = quad.m_111304_();
        } else {
            sprite = model.getParticleIcon(modelData);
            shouldColor = true;
        }
        SpriteContents contents = sprite.m_245424_();
        ResourceLocation spriteId = contents.m_246162_();
        NativeImage texture = contents.f_243731_[0];
        int blockColor = shouldColor ? client.m_91298_().m_92577_(state, (BlockAndTintGetter)world, pos, 0) : -1;
        return LeafColorUtil.calculateLeafColor(spriteId, texture, blockColor);
    }

    private static double[] calculateLeafColor(ResourceLocation spriteId, NativeImage texture, int blockColor) {
        double[] textureColor = TextureCache.INST.computeIfAbsent(spriteId, loc -> {
            double[] doubles = LeafColorUtil.averageColor(texture);
            Main.LOGGER.debug("{}: Calculated texture color {} ", (Object)spriteId, (Object)doubles);
            return new TextureCache.Data(doubles);
        }).getColor();
        if (blockColor != -1) {
            textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
            textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
            textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
        }
        return textureColor;
    }

    public static Color getColorFromValues(double[] values) {
        return new Color((float)Math.max(0.0, Math.min(1.0, values[0])), (float)Math.max(0.0, Math.min(1.0, values[1])), (float)Math.max(0.0, Math.min(1.0, values[2])));
    }
}

