/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.config;

import java.lang.reflect.Field;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.config.ListHandler;
import tschipp.carryon.common.pickupcondition.PickupConditionHandler;
import tschipp.carryon.config.AnnotationData;
import tschipp.carryon.config.BuiltCategory;
import tschipp.carryon.config.BuiltConfig;
import tschipp.carryon.config.PropertyData;
import tschipp.carryon.config.PropertyType;
import tschipp.carryon.config.annotations.Category;
import tschipp.carryon.config.annotations.Config;
import tschipp.carryon.config.annotations.Property;
import tschipp.carryon.platform.Services;

public class ConfigLoader {
    public static void registerConfig(Object object) {
        BuiltCategory category;
        try {
            category = ConfigLoader.buildCategory(null, object);
        }
        catch (Exception e) {
            e.printStackTrace();
            category = null;
        }
        if (!(category instanceof BuiltConfig)) {
            throw new IllegalArgumentException("Config supplied does not have a @Config annotation");
        }
        BuiltConfig config = (BuiltConfig)category;
        ConfigLoader.registerConfig(config);
    }

    public static void registerConfig(BuiltConfig config) {
        Services.PLATFORM.registerConfig(config);
    }

    public static void onConfigLoaded() {
        ListHandler.initConfigLists();
        PickupConditionHandler.initPickupConditions();
        ModelOverrideHandler.initModelOverrides();
    }

    public static BuiltCategory buildCategory(String categoryDesc, Object object) throws IllegalAccessException {
        BuiltCategory category;
        Class<?> configClass = object.getClass();
        if (configClass.isAnnotationPresent(Config.class)) {
            category = new BuiltConfig(configClass.getAnnotation(Config.class).value());
        } else if (configClass.isAnnotationPresent(Category.class)) {
            category = new BuiltCategory(categoryDesc, configClass.getAnnotation(Category.class).value());
        } else {
            throw new IllegalStateException("Config does not contain any @Config annotation or @Category");
        }
        for (Field field : configClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class) || !field.canAccess(object)) continue;
            PropertyType type = field.getAnnotation(Property.class).type();
            if (type.equals((Object)PropertyType.CATEGORY)) {
                category.categories.add(ConfigLoader.buildCategory(field.getAnnotation(Property.class).description(), field.get(object)));
                continue;
            }
            category.properties.add(new PropertyData(object, field, AnnotationData.getData(field)));
        }
        return category;
    }
}

