/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.api;

import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.config.Config;
import java.util.HashSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightyHelper {
    static HashSet<ResourceLocation> invalidBlocks = new HashSet();

    private static boolean isRedstone(Block block) {
        return block instanceof RedStoneWireBlock || block instanceof ButtonBlock || block instanceof PressurePlateBlock || block instanceof LeverBlock;
    }

    private static boolean protectedIsValidSpawnCheck(BlockState block, BlockPos pos, ClientLevel world) {
        if (block.m_60734_() instanceof MagmaBlock) {
            return true;
        }
        try {
            return block.m_60643_((BlockGetter)world, pos, null);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            ResourceLocation rl = BuiltInRegistries.f_256975_.m_7981_((Object)block.m_60734_());
            if (!invalidBlocks.contains(rl)) {
                invalidBlocks.add(rl);
                Lighty.LOGGER.error(e.getMessage());
                Lighty.LOGGER.error("Cannot check `isValidSpawn` on Block {} because it uses entity checks. The overlay might not be accurate for that block.", (Object)rl);
            }
            return true;
        }
    }

    private static boolean specialCases(Block block) {
        return block instanceof CarpetBlock;
    }

    public static float getOffset(BlockState block, BlockPos pos, ClientLevel world) {
        float offset = 0.0f;
        if (block.m_60734_() instanceof SnowLayerBlock) {
            int layer = (Integer)world.m_8055_(pos).m_61143_((Property)SnowLayerBlock.f_56581_);
            if (layer != 1) {
                return -1.0f;
            }
            offset = 0.125f * (float)layer;
        }
        return offset;
    }

    public static boolean isBlocked(BlockState block, BlockState up, ClientLevel world, BlockPos pos, BlockPos upPos) {
        return up.m_60838_((BlockGetter)world, upPos) || !block.m_60783_((BlockGetter)world, pos, Direction.UP) || LightyHelper.isRedstone(up.m_60734_()) || LightyHelper.specialCases(up.m_60734_()) || !LightyHelper.protectedIsValidSpawnCheck(block, pos, world) || !up.m_60819_().m_76178_() || !up.m_60734_().m_48673_(up) || up.m_204336_(BlockTags.f_13054_);
    }

    public static boolean isSafe(int blockLightLevel) {
        return blockLightLevel > Config.getBlockThreshold();
    }
}

