/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.network.GliderNetwork;
import org.jetbrains.annotations.NotNull;

public class SyncGliderData
extends MessageS2C {
    public int entityID;
    public CompoundTag nbt;

    public SyncGliderData(int entityID, CompoundTag nbt) {
        this.entityID = entityID;
        this.nbt = nbt;
    }

    public SyncGliderData(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.nbt = buf.m_130260_();
    }

    @NotNull
    public MessageType getType() {
        return GliderNetwork.SYNC_DATA;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130079_(this.nbt);
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(this.entityID);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            GliderData.get((LivingEntity)player).ifPresent(c -> c.deserializeNBT(this.nbt));
        }
    }
}

